/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.ExceptionUtil;

public class ScpOrderPushMobilePlugin
extends AbstractMobFormPlugin {
    private static Log log = LogFactory.getLog(ScpOrderPushMobilePlugin.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkId = customParams.get("pkId");
        if (pkId != null) {
            this.allotDynamicData(pkId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mbarreceive", "addimg", "minimg"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IFormView view = this.getView();
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "mbarreceive": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                this.pushToSalOutStack(new Long[]{Long.valueOf(customParams.get("pkId").toString())});
                break;
            }
            case "addimg": {
                this.calOutStockQty("+");
                break;
            }
            case "minimg": {
                this.calOutStockQty("-");
            }
        }
    }

    private void calOutStockQty(String ob) {
        int rowindex = this.getModel().getEntryCurrentRowIndex("entryentity");
        BigDecimal outstockqty = (BigDecimal)this.getModel().getValue("outstockqty", rowindex);
        BigDecimal sumoutstockqty = (BigDecimal)this.getModel().getValue("sumoutstockqty", rowindex);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowindex);
        BigDecimal maxqty = qty.subtract(sumoutstockqty);
        switch (ob) {
            case "+": {
                if (maxqty.compareTo(outstockqty) <= 0) break;
                this.getModel().setValue("outstockqty", (Object)outstockqty.add(BigDecimal.ONE), rowindex);
                break;
            }
            case "-": {
                if (outstockqty.compareTo(BigDecimal.ONE) < 0) break;
                this.getModel().setValue("outstockqty", (Object)outstockqty.subtract(BigDecimal.ONE), rowindex);
                break;
            }
        }
    }

    protected void beforePush(Object[] pkValues) {
    }

    protected void pushToSalOutStack(Long[] pkValues) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashMap<String, BigDecimal> matchQtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject entry : entryEntity) {
            matchQtyMap.put(entry.getString("poentryid"), entry.getBigDecimal("outstockqty"));
        }
        PushArgs pushArgs = new PushArgs();
        DynamicObject currentObj = BusinessDataServiceHelper.loadSingle((Object)pkValues[0], (String)"scp_order");
        String cfmstatus = currentObj.getString("cfmstatus");
        if (ConfirmStatusEnum.UNCONFIRM.getVal().equals(cfmstatus)) {
            OperationResult confirmResult = null;
            StringBuilder errorMessage = new StringBuilder();
            try {
                confirmResult = OperationServiceHelper.executeOperate((String)"confirm", (String)"scp_order", (Object[])pkValues, (OperateOption)OperateOption.create());
            }
            catch (Exception exception) {
                log.info(ExceptionUtil.getStackTrace((Throwable)exception));
                errorMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u786e\u8ba4\u62a5\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpOrderPushMobilePlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
            if (confirmResult == null || !confirmResult.isSuccess()) {
                errorMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u786e\u8ba4\u62a5\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpOrderPushMobilePlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
            if (errorMessage.length() > 0) {
                this.getView().showMessage(errorMessage.toString());
            }
        }
        if (ConfirmStatusEnum.REJECT.getVal().equals(cfmstatus)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u6253\u56de\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d27\u3002", (String)"ScpOrderPushMobilePlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        } else {
            pushArgs.setSourceEntityNumber("scp_order");
            pushArgs.setTargetEntityNumber("scp_saloutstock");
            pushArgs.setBuildConvReport(false);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            DynamicObjectCollection dynamicObjects = currentObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject rowMal : dynamicObjects) {
                String poentryid = rowMal.getString("poentryid");
                if (!matchQtyMap.containsKey(poentryid)) continue;
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(currentObj.getPkValue());
                row.setEntryEntityKey("materialentry");
                selectedRowList.add(row);
                row.setEntryPrimaryKeyValue(rowMal.getPkValue());
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"scp_saloutstock");
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                for (DynamicObject dynamicObject : targetData) {
                    DynamicObjectCollection materialColl = dynamicObject.getDynamicObjectCollection("materialentry");
                    for (DynamicObject material : materialColl) {
                        String poentryid = material.getString("poentryid");
                        BigDecimal bigDecimal = (BigDecimal)matchQtyMap.get(poentryid);
                        if (bigDecimal == null) continue;
                        material.set("qty", (Object)bigDecimal);
                    }
                }
                OperationResult operationResult = null;
                StringBuilder errorMessage = new StringBuilder();
                try {
                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"scp_saloutstock", (DynamicObject[])targetData.toArray(new DynamicObject[0]), null);
                }
                catch (Exception e) {
                    log.info(ExceptionUtil.getStackTrace((Throwable)e));
                    errorMessage.append(ResManager.loadKDString((String)"\u53d1\u8d27\u5931\u8d25\u4e86\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpOrderPushMobilePlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                }
                if (operationResult != null) {
                    if (operationResult.isSuccess()) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u8d27\u6210\u529f", (String)"ScpOrderPushMobilePlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    } else {
                        for (IOperateInfo info : operationResult.getAllErrorOrValidateInfo()) {
                            errorMessage.append(info.getMessage());
                        }
                    }
                }
                if (errorMessage.length() > 0) {
                    this.getView().showErrorNotification(errorMessage.toString());
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u8d27\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u53d1\u8d27\u6570\u91cf\u3002", (String)"ScpOrderPushMobilePlugin_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                log.info(result.getMessage());
            }
        }
    }

    private void allotDynamicData(Object pkId) {
        DynamicObject scpOrderBill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"scp_order", (String)"id,billno,billdate,curr,org,logstatus,materialentry.pobillno,materialentry.material,materialentry.unit,materialentry.price,materialentry.sumoutstockqty,materialentry.qty,materialentry.pobillid,materialentry.poentryid,materialentry.basicUnit");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Long billId = scpOrderBill.getLong("id");
        model.setValue("billno", scpOrderBill.get("billno"));
        model.setValue("org", scpOrderBill.get("org_id"));
        model.setValue("billdate", scpOrderBill.get("billdate"));
        model.setValue("curr", scpOrderBill.get("curr_id"));
        model.deleteEntryData("entryentity");
        DynamicObjectCollection materialentry = scpOrderBill.getDynamicObjectCollection("materialentry");
        int rowCount = 0;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (DynamicObject mater : materialentry) {
            vs.set("material", mater.get("material_id"), rowCount);
            vs.set("unit", mater.get("unit_id"), rowCount);
            vs.set("unit1", mater.get("unit_id"), rowCount);
            vs.set("basicunit", mater.get("basicunit_id"), rowCount);
            vs.set("billid", (Object)billId, rowCount);
            vs.set("entryid", mater.get("id"), rowCount);
            vs.set("poentryid", mater.get("poentryid"), rowCount);
            vs.set("pobillid", mater.get("pobillid"), rowCount);
            vs.set("qty", mater.get("qty"), rowCount);
            vs.set("outstockqty", (Object)mater.getBigDecimal("qty").subtract(mater.getBigDecimal("sumoutstockqty")), rowCount);
            vs.set("sumoutstockqty", mater.get("sumoutstockqty"), rowCount);
            ++rowCount;
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }
}

