/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OrgUtil;
import org.apache.commons.lang.StringUtils;

public class ScpConsumeReportQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filter = reportQueryParam.getFilter();
        DataSet dataSet = null;
        String jointSystemType = this.getJointSystemType(filter);
        if ("self".equals(jointSystemType)) {
            Collection<QFilter> qFilters = this.buildQFilter(filter, "pm_transferbill", "billentry");
            dataSet = QueryServiceHelper.queryDataSet((String)"VmiConsumeReportListPlugin", (String)"pm_transferbill", (String)this.bulidSelectField(), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"biztime");
        } else if ("xkcloud".equals(jointSystemType)) {
            Collection<QFilter> qFilters = this.buildQFilter(filter, "pur_instock", "materialentry");
            qFilters.add(new QFilter("vmisettle", "=", (Object)"1"));
            dataSet = QueryServiceHelper.queryDataSet((String)"VmiSettleReportListPlugin", (String)"pur_instock", (String)this.buildInStockSelectField(), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"billdate");
        }
        return dataSet;
    }

    protected String getJointSystemType(FilterInfo filter) {
        FilterItemInfo executechannel = filter.getFilterItem("executechannel");
        String jointSystemType = "self";
        Object value = executechannel.getValue();
        if (value instanceof DynamicObject) {
            DynamicObject executeChannelValue = (DynamicObject)value;
            DynamicObject jointChannelCache = BusinessDataServiceHelper.loadSingleFromCache((Object)executeChannelValue.getPkValue(), (String)"pbd_scdatachannel");
            jointSystemType = jointChannelCache.getString("jointchanneltype.jointsystemtype");
        }
        return jointSystemType;
    }

    protected String buildInStockSelectField() {
        return "billno,curr settlecurrency,org inventoryorg,purorg,billdate biztime,supplier,businesstype biztype,materialentry.material material,materialentry.unit unit,materialentry.qty qty,materialentry.warehouse warehouse,materialentry.entrystatus settlestatus,materialentry.lotnumber lotnumber,materialentry.project project";
    }

    protected String bulidSelectField() {
        return "org inventoryorg,purorg,billentry.supplier.id supplier,biztype,biztime,billentry.material material,billentry.auxpty auxpty,billentry.unit unit,billentry.qty qty,billentry.warehouse warehouse,billentry.settlestatus settlestatus,billentry.joinqty joinqty,billentry.project project,billentry.lotnumber lotnumber";
    }

    protected Collection<QFilter> buildQFilter(FilterInfo filter, String entityKey, String entryKey) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        QFilter invOrgFilter = this.bulidInvOrgFilter(filter);
        QFilter purorgQfilter = this.bulidPurorgFilter(filter);
        QFilter supQfilter = this.bulidSupplerFilter(entityKey);
        QFilter fromDateqFilter = this.bulidFromdateQfilter(filter, entityKey);
        QFilter toDateqFilter = this.bulidTodateQfilter(filter, entityKey);
        QFilter materialQfilter = this.bulidMaterialQfilter(filter, entryKey);
        QFilter warehouseFilter = this.bulidWarehouseQfilter(filter, entryKey);
        if (Objects.nonNull(invOrgFilter)) {
            qFilters.add(invOrgFilter);
        }
        if (Objects.nonNull(purorgQfilter)) {
            qFilters.add(purorgQfilter);
        }
        qFilters.add(supQfilter);
        if (Objects.nonNull(fromDateqFilter)) {
            qFilters.add(fromDateqFilter);
        }
        if (Objects.nonNull(toDateqFilter)) {
            qFilters.add(toDateqFilter);
        }
        if (Objects.nonNull(materialQfilter)) {
            qFilters.add(materialQfilter);
        }
        if (Objects.nonNull(warehouseFilter)) {
            qFilters.add(warehouseFilter);
        }
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qFilters.add(statusQFilter);
        return qFilters;
    }

    private QFilter bulidPurorgFilter(FilterInfo filter) {
        FilterItemInfo orgfilter = filter.getFilterItem("purorgfilter");
        QFilter qFilter = null;
        if (Objects.nonNull(orgfilter)) {
            String orgnames = (String)orgfilter.getValue();
            if (orgnames != null && !StringUtils.isEmpty((String)orgnames)) {
                String[] orglist = orgnames.split(",");
                qFilter = new QFilter("purorg.name", "in", (Object)orglist);
            } else {
                List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
                qFilter = new QFilter("purorg.id", "in", (Object)userHasAllPurPermissionOrgs);
            }
        }
        return qFilter;
    }

    private QFilter bulidInvOrgFilter(FilterInfo filter) {
        FilterItemInfo orgfilter = filter.getFilterItem("orgfilter");
        QFilter qFilter = null;
        if (Objects.nonNull(orgfilter)) {
            String orgnames = (String)orgfilter.getValue();
            if (orgnames != null && !StringUtils.isEmpty((String)orgnames)) {
                String[] orglist = orgnames.split(",");
                qFilter = new QFilter("org.name", "in", (Object)orglist);
            } else {
                List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
                qFilter = new QFilter("org.id", "in", (Object)userHasAllPurPermissionOrgs);
            }
        }
        return qFilter;
    }

    private QFilter bulidMaterialQfilter(FilterInfo filter, String entryKey) {
        String materialname;
        FilterItemInfo materialfilter = filter.getFilterItem("materialnamefilter");
        QFilter qFilter = null;
        if (Objects.nonNull(materialfilter) && (materialname = (String)materialfilter.getValue()) != null && !StringUtils.isEmpty((String)materialname)) {
            qFilter = new QFilter(entryKey + ".material.name", "match", (Object)materialname);
            return qFilter;
        }
        return qFilter;
    }

    private QFilter bulidWarehouseQfilter(FilterInfo filter, String entryKey) {
        String value;
        FilterItemInfo warehousefilter = filter.getFilterItem("warehousefilter");
        QFilter qFilter = null;
        if (Objects.nonNull(warehousefilter) && !StringUtils.isEmpty((String)(value = (String)warehousefilter.getValue()))) {
            qFilter = new QFilter(entryKey + ".warehouse.name", "match", (Object)value);
            return qFilter;
        }
        return qFilter;
    }

    private QFilter bulidFromdateQfilter(FilterInfo filter, String entityKey) {
        FilterItemInfo datefrom = filter.getFilterItem("datefrom");
        QFilter qFilter = null;
        if (Objects.nonNull(datefrom) && datefrom.getValue() != null) {
            Date datefromValue = (Date)datefrom.getValue();
            if ("pm_transferbill".equals(entityKey)) {
                qFilter = new QFilter("biztime", ">=", (Object)datefromValue);
            } else if ("pur_instock".equals(entityKey)) {
                qFilter = new QFilter("billdate", ">=", (Object)datefromValue);
            }
        }
        return qFilter;
    }

    private QFilter bulidTodateQfilter(FilterInfo filter, String entityKey) {
        FilterItemInfo dateto = filter.getFilterItem("dateto");
        QFilter qFilter = null;
        if (Objects.nonNull(dateto) && dateto.getValue() != null) {
            Date datefromValue = (Date)dateto.getValue();
            if ("pm_transferbill".equals(entityKey)) {
                qFilter = new QFilter("biztime", "<=", (Object)datefromValue);
            } else if ("pur_instock".equals(entityKey)) {
                qFilter = new QFilter("billdate", "<=", (Object)datefromValue);
            }
        }
        return qFilter;
    }

    private QFilter bulidSupplerFilter(String entityKey) {
        List supList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        QFilter qFilter = null;
        if ("pm_transferbill".equals(entityKey)) {
            qFilter = new QFilter("billentry.supplier.id", "in", (Object)supList);
        } else if ("pur_instock".equals(entityKey)) {
            qFilter = new QFilter("supplier.id", "in", (Object)supList);
        }
        return qFilter;
    }
}

