/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import org.apache.commons.lang.StringUtils;

public class ScpSettleReportPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit org = (TextEdit)this.getView().getControl("orgfilter");
        if (Objects.nonNull(org)) {
            org.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Date today = TimeServiceHelper.today();
        Calendar instance = Calendar.getInstance();
        instance.setTime(today);
        instance.add(2, -3);
        Date datefrom = instance.getTime();
        this.getModel().setValue("datefrom", (Object)datefrom);
        this.getModel().setValue("dateto", (Object)today);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("orgType", "purorg");
        String orgfilter = (String)this.getModel().getValue("orgfilter");
        ArrayList selectedOrgs = new ArrayList();
        if (!orgfilter.isEmpty()) {
            String[] split = orgfilter.split(",");
            Collections.addAll(selectedOrgs, split);
        }
        if (!selectedOrgs.isEmpty()) {
            paramMap.put("selectdOrgs", selectedOrgs);
        }
        if ("orgfilter".equals(fieldKey)) {
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_orgs", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if (!closedCallBackEvent.getActionId().equals("orgclose") || returnData == null) {
            return;
        }
        StringBuilder purorg = new StringBuilder();
        List orgNameList = (List)returnData.get("orgNameList");
        if (orgNameList != null) {
            for (String orgname : orgNameList) {
                if (StringUtils.isEmpty((String)purorg.toString())) {
                    purorg.append(orgname);
                    continue;
                }
                purorg.append(",").append(orgname);
            }
        }
        this.getModel().setValue("orgfilter", (Object)purorg);
    }
}

