/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OrgUtil;
import org.apache.commons.lang.StringUtils;

public class ScpSettleReportQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String[] SETTLESELECTS = new String[]{"purorg", "supplier", "settledate", "material", "unit", "qty", "purinbillnumber"};
    private static final String[] CONSUMESELECTS = new String[]{"priceandtax", "taxrateid", "amountandtax", "settlecurrency", "entrysettleorg", "billno"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filter = reportQueryParam.getFilter();
        QFilter[] qFilters = this.buildMainQfilter(filter);
        QFilter[] commonQfilter = this.buildCommonQfilter(filter);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"VmiSettleReportListPlugin", (String)"pm_vmisettlerecord", (String)this.buildSelectField(), (QFilter[])qFilters, (String)"settledate");
        DataSet joinDataSet = QueryServiceHelper.queryDataSet((String)"VmiSettleReportListPlugin", (String)"im_purinbill", (String)this.buildJoinField(), (QFilter[])commonQfilter, (String)"");
        DataSet mainData = mainDataSet.select(new String[]{"purorg", "supplier", "settledate", "material", "unit", "qty", "purinbillnumber", "cast(purinbillentryseq as String) seq"});
        DataSet joinData = joinDataSet.select(new String[]{"priceandtax", "taxrateid", "amountandtax", "settlecurrency", "entrysettleorg", "billno", "cast(seq as String) seq"});
        JoinDataSet resultDataset = mainData.join(joinData, JoinType.LEFT);
        resultDataset.on("seq", "seq");
        resultDataset.on("purinbillnumber", "billno");
        JoinDataSet resultSet = resultDataset.select(SETTLESELECTS, CONSUMESELECTS);
        return resultSet.finish();
    }

    protected String buildSelectField() {
        return "org purorg,billentry.supplier.id supplier,settledate,billentry.material material,billentry.unit unit,billentry.qty qty,billentry.purinbillnumber purinbillnumber,billentry.purinbillentryseq purinbillentryseq";
    }

    protected String buildJoinField() {
        return "billno,billentry.seq as seq,billentry.priceandtax priceandtax,billentry.taxrateid taxrateid,billentry.amountandtax amountandtax,settlecurrency settlecurrency,billentry.entrysettleorg entrysettleorg";
    }

    protected QFilter[] buildMainQfilter(FilterInfo filter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        QFilter purorgQfilter = this.bulidPurorgFilter(filter);
        QFilter supQfilter = this.bulidSupplerFilter();
        QFilter fromDateqFilter = this.buildFromdateQfilter(filter);
        QFilter toDateqFilter = this.buildTodateQfilter(filter);
        QFilter materialQfilter = this.buildMaterialQfilter(filter);
        if (Objects.nonNull(purorgQfilter)) {
            qFilters.add(purorgQfilter);
        }
        qFilters.add(supQfilter);
        if (Objects.nonNull(fromDateqFilter)) {
            qFilters.add(fromDateqFilter);
        }
        if (Objects.nonNull(toDateqFilter)) {
            qFilters.add(toDateqFilter);
        }
        if (Objects.nonNull(materialQfilter)) {
            qFilters.add(materialQfilter);
        }
        QFilter[] qFiltersArray = qFilters.toArray(new QFilter[qFilters.size()]);
        return qFiltersArray;
    }

    protected QFilter[] buildCommonQfilter(FilterInfo filter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        QFilter purorgQfilter = this.buildBizorgFilter(filter);
        if (Objects.nonNull(purorgQfilter)) {
            qFilters.add(purorgQfilter);
        }
        QFilter[] qFiltersArray = qFilters.toArray(new QFilter[qFilters.size()]);
        return qFiltersArray;
    }

    private QFilter bulidPurorgFilter(FilterInfo filter) {
        FilterItemInfo orgfilter = filter.getFilterItem("orgfilter");
        QFilter qFilter = null;
        if (Objects.nonNull(orgfilter)) {
            String orgnames = (String)orgfilter.getValue();
            if (orgnames != null && !StringUtils.isEmpty((String)orgnames)) {
                String[] orglist = orgnames.split(",");
                qFilter = new QFilter("org.name", "in", (Object)orglist);
            } else {
                List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
                qFilter = new QFilter("org.id", "in", (Object)userHasAllPurPermissionOrgs);
            }
        }
        return qFilter;
    }

    private QFilter buildBizorgFilter(FilterInfo filter) {
        FilterItemInfo orgfilter = filter.getFilterItem("orgfilter");
        QFilter qFilter = null;
        if (Objects.nonNull(orgfilter)) {
            String orgnames = (String)orgfilter.getValue();
            if (orgnames != null && !StringUtils.isEmpty((String)orgnames)) {
                String[] orglist = orgnames.split(",");
                qFilter = new QFilter("bizorg.name", "in", (Object)orglist);
            } else {
                List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
                qFilter = new QFilter("bizorg.id", "in", (Object)userHasAllPurPermissionOrgs);
            }
        }
        return qFilter;
    }

    private QFilter buildMaterialQfilter(FilterInfo filter) {
        String materialname;
        FilterItemInfo materialfilter = filter.getFilterItem("materialnamefilter");
        QFilter qFilter = null;
        if (Objects.nonNull(materialfilter) && (materialname = (String)materialfilter.getValue()) != null && !StringUtils.isEmpty((String)materialname)) {
            qFilter = new QFilter("billentry.material.name", "match", (Object)materialname);
            return qFilter;
        }
        return qFilter;
    }

    private QFilter buildFromdateQfilter(FilterInfo filter) {
        FilterItemInfo datefrom = filter.getFilterItem("datefrom");
        QFilter qFilter = null;
        if (Objects.nonNull(datefrom) && datefrom.getValue() != null) {
            Date datefromValue = (Date)datefrom.getValue();
            qFilter = new QFilter("settledate", ">=", (Object)datefromValue);
        }
        return qFilter;
    }

    private QFilter buildTodateQfilter(FilterInfo filter) {
        FilterItemInfo dateto = filter.getFilterItem("dateto");
        QFilter qFilter = null;
        if (Objects.nonNull(dateto) && dateto.getValue() != null) {
            Date datefromValue = (Date)dateto.getValue();
            qFilter = new QFilter("settledate", "<=", (Object)datefromValue);
        }
        return qFilter;
    }

    private QFilter bulidSupplerFilter() {
        List supList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        return new QFilter("billentry.supplier.id", "in", (Object)supList);
    }
}

