/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.scp.report.util.RptForm;
import kd.scm.scp.report.util.RptParam;
import org.apache.commons.lang.StringUtils;

public class ScpOrderBaseForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private RptForm localRptForm;

    protected RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit purorg = (TextEdit)this.getView().getControl("purorg");
        if (Objects.nonNull(purorg)) {
            purorg.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getRptForm().initPage();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        if ("purorg".equals(fieldKey)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            String orgfilter = (String)this.getModel().getValue(fieldKey);
            ArrayList selectedOrgs = new ArrayList();
            if (!orgfilter.isEmpty()) {
                String[] split = orgfilter.split(",");
                Collections.addAll(selectedOrgs, split);
            }
            if (!selectedOrgs.isEmpty()) {
                paramMap.put("selectdOrgs", selectedOrgs);
            }
            paramMap.put("orgType", "purorg");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setCaption(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237", (String)"ScpOrderBaseForm_0", (String)"scm-scp-report", (Object[])new Object[0]));
            fsp.setFormId("scp_orgs");
            fsp.setCustomParams(paramMap);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "purorg"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData != null && "purorg".equals(actionId)) {
            StringBuilder purorg = new StringBuilder();
            List orgNameList = (List)returnData.get("orgNameList");
            List orgidList = (List)returnData.get("orgidList");
            if (orgNameList != null) {
                for (String orgname : orgNameList) {
                    if (StringUtils.isEmpty((String)purorg.toString())) {
                        purorg.append(orgname);
                        continue;
                    }
                    purorg.append(',').append(orgname);
                }
            }
            this.getPageCache().put("purorg", SerializationUtils.toJsonString((Object)orgidList));
            this.getModel().setValue("purorg", (Object)purorg);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.getRptForm().hyperLinkClick(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        this.getRptForm().beforeF7Select(event, this.getModel());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"ScpOrderBaseForm_1", (String)"scm-scp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyMaterial(RptParam reportParam) {
        String material = reportParam.getMaterial();
        if (StringUtils.isNotEmpty((String)material)) {
            String materialLike = '%' + material + '%';
            QFilter qFilter = new QFilter("name", "like", (Object)materialLike).or("number", "like", (Object)materialLike);
            DynamicObject[] dynList = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,name", (QFilter[])qFilter.toArray());
            if (dynList != null && dynList.length > 0) {
                HashSet<Long> materialIds = new HashSet<Long>(dynList.length);
                for (DynamicObject dyn : dynList) {
                    materialIds.add(dyn.getLong("id"));
                }
                reportParam.setMaterialIds(materialIds);
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7269\u6599\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ScpOrderBaseForm_2", (String)"scm-scp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

