/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.deliveryrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.report.deliveryrate.ScpOrderDeliveryParam;
import kd.scm.scp.report.deliveryrate.trans.ScpDeliverQtyTransform;
import kd.scm.scp.report.deliveryrate.trans.ScpDeliverRateTransform;

public class ScpOrderDeliveryHandle
implements IReportDataHandle {
    private ScpOrderDeliveryParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (ScpOrderDeliveryParam)ctx.getParam(ScpOrderDeliveryParam.class.getName());
        this.setPageFs(ctx);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ScpDeliverQtyTransform(ctx, this.reportParam));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ScpDeliverRateTransform());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("poentryid");
        repoColFilter.add("entrydelidate");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if ("orderqty".equals(field) || "ontimeqty".equals(field) || "delayqty".equals(field)) {
                reportCol.setHyperlink(true);
            }
            if (!"material".equals(field) && !"basicunit".equals(field)) continue;
            reportCol.setHide(true);
        }
        return columns;
    }

    private void setPageFs(ReportDataCtx ctx) {
        ArrayList<QFilter> pageFs = ctx.getPageFs();
        if (pageFs == null) {
            pageFs = new ArrayList<QFilter>();
            ctx.setPageFs(pageFs);
        }
        pageFs.addAll(this.getPageFilter());
    }

    private List<QFilter> getPageFilter() {
        String billsattus;
        List<Long> billids;
        Date endDate;
        String orgnames;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List<QFilter> bizPartnerFilter = this.reportParam.getBizPartnerFilter();
        if (bizPartnerFilter != null && !bizPartnerFilter.isEmpty()) {
            qFilters.addAll(bizPartnerFilter);
        }
        if ((orgnames = this.reportParam.getOrgnames()) != null && !StringUtils.isEmpty((CharSequence)orgnames)) {
            String[] orglist = orgnames.split(",");
            qFilters.add(new QFilter("org.name", "in", (Object)orglist));
        } else {
            qFilters.add(new QFilter("org", "in", this.reportParam.getOrgs()));
        }
        qFilters.add(new QFilter("poentryid", "!=", (Object)"0"));
        Date startDate = this.reportParam.getStartdate();
        if (startDate != null) {
            qFilters.add(new QFilter("entrydelidate", ">=", (Object)startDate));
        }
        if ((endDate = this.reportParam.getEnddate()) != null) {
            qFilters.add(new QFilter("entrydelidate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if ((billids = this.reportParam.getBillIds()) != null && !billids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", billids));
        }
        if (StringUtils.isEmpty((CharSequence)(billsattus = this.reportParam.getBillstatus())) || "A".equals(billsattus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.add(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.add(new QFilter("billstatus", "=", (Object)billsattus));
        }
        Set<Long> materialIds = this.reportParam.getMaterialIds();
        if (materialIds != null && !materialIds.isEmpty()) {
            qFilters.add(new QFilter("material", "in", materialIds));
        }
        return qFilters;
    }
}

