/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.jointplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.scp.business.ScpAutoStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpOrderCreateReceiptNoticeForSelfCosmicStdPlugin
extends AbstractCustomParamPlugin {
    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        List queryDynamicObjects = this.loadDynamicObjects(pkIds);
        List<DynamicObject> dys = queryDynamicObjects.stream().filter(dy -> !BussinessTypeUtils.checkIsPmOmBussinessType((DynamicObject)dy.getDynamicObject("businesstype"))).collect(Collectors.toList());
        return dys;
    }

    protected Boolean verifyEnable(List<DynamicObject> dynamicObjects) {
        Boolean isAutoReceive = Boolean.FALSE;
        HashSet<Long> unitOrgIds = new HashSet<Long>(16);
        for (DynamicObject bill : dynamicObjects) {
            unitOrgIds.add(bill.getLong("org.id"));
        }
        Map autoReceiptNoticeBill = ScpAutoStockBillHelper.verifyAutoReceiptNoticeBill(unitOrgIds);
        isAutoReceive = autoReceiptNoticeBill.values().stream().allMatch(row -> row);
        return isAutoReceive;
    }

    public ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        ScMultiCosmicStdParamArgs scMultiParamArgs = null;
        if (ScmcUtil.checkReceiptVersion().booleanValue()) {
            LinkedHashMap<Long, Collection<Long>> pushOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
            LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap = new LinkedHashMap<String, List<Map<String, String>>>(56);
            HashSet<String> salOutEntryIds = new HashSet<String>(16);
            Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
            for (DynamicObject bill : dynamicObjects) {
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : rows) {
                    boolean lineTypeacceptance = LineTypeUtil.isLineTypeacceptance((DynamicObject)row);
                    if (lineTypeacceptance) continue;
                    ScpAutoStockBillHelper.buildParam((DynamicObject)bill, (DynamicObject)row, pushOrderData, rowSalOutInfoMap, salOutEntryIds, (Map)autoExtEntryPro, (Boolean)false);
                }
            }
            if (!CollectionUtils.isEmpty(pushOrderData)) {
                scMultiParamArgs = new ScMultiCosmicStdParamArgs();
                scMultiParamArgs.setCloudId("scm");
                scMultiParamArgs.setAppId("scp");
                scMultiParamArgs.setServiceName("IPurSalOutStockToReceive");
                scMultiParamArgs.setMethodName("salOutStockToReceive");
                scMultiParamArgs.setParamMap(this.executeService(pushOrderData, rowSalOutInfoMap, salOutEntryIds));
            }
        }
        return scMultiParamArgs;
    }

    private Map<String, Object> executeService(Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Set<String> salOutEntryIds) {
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(2);
        toStockParamMap.put("sourceEntity", "pm_purorderbill");
        toStockParamMap.put("targetEntity", "pm_receiptnotice");
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("rowSalOutInfoMap", rowSalOutInfoMap);
        toStockParamMap.put("salOutEntryIds", salOutEntryIds);
        toStockParamMap.put("needWriteBillNo", Boolean.TRUE);
        return toStockParamMap;
    }
}

