/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.jointplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.multisystemjoint.constant.MServiceParamType;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.common.util.BussinessTypeUtils;

public final class ScpOrderRejectForSelfCosmicStdPlugin
extends AbstractCustomParamPlugin {
    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        List queryDynamicObjects = this.queryDynamicObjects(pkIds);
        List<DynamicObject> dys = queryDynamicObjects.stream().filter(dy -> !BussinessTypeUtils.isPmOmBussinessType((String)dy.getString("businesstype"))).collect(Collectors.toList());
        return dys;
    }

    protected Collection<String> getProperty() {
        HashSet<String> propertys = new HashSet<String>(1);
        propertys.add("materialentry.pobillid pobillid");
        propertys.add("businesstype.number businesstype");
        return propertys;
    }

    protected Set<String> getGroupKeys() {
        HashSet<String> groupKey = new HashSet<String>(1);
        groupKey.add("pobillid");
        groupKey.add("businesstype");
        return groupKey;
    }

    public ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        ScMultiCosmicStdParamArgs scMultiParamArgs = new ScMultiCosmicStdParamArgs();
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        HashSet<Long> confirmIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String poBillId = dynamicObject.getString("pobillid");
            if (poBillId == null || poBillId.trim().isEmpty()) continue;
            confirmIdSet.add(Long.parseLong(poBillId));
        }
        HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
        ArrayList confirmIds = new ArrayList(confirmIdSet);
        confirmMap.put("ids", confirmIds);
        confirmMap.put("status", ConfirmStatusEnum.REJECT.getVal());
        scMultiParamArgs.setCloudId("scmc");
        scMultiParamArgs.setAppId("pm");
        scMultiParamArgs.setServiceName("PmSupColService");
        scMultiParamArgs.setMethodName("upOrderConfirmStatus");
        scMultiParamArgs.setParamType(MServiceParamType.GATHERMAP);
        scMultiParamArgs.setParamMap(confirmMap);
        return scMultiParamArgs;
    }
}

