/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.jointplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.helper.multisystemjoint.constant.MServiceParamType;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.scp.business.ScpModuleConsumeHelper;
import kd.scm.scp.common.enums.BillStatus;

public final class ScpSalOutAuditCreateModuleConsumeForSelfPlugin
extends AbstractCustomParamPlugin {
    public ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(8);
        HashMap<Long, Collection<Long>> pushOrderData = new HashMap<Long, Collection<Long>>(8);
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ScpSalOutAuditCreateModuleConsumeForSelfPlugin.buildParam(dynamicObject, paramMap, pushOrderData);
        }
        toStockParamMap.put("sourceEntity", "scp_order");
        toStockParamMap.put("targetEntity", "scp_moduleconsume");
        String consumemomentbotp = ScpModuleConsumeHelper.getConsumeMomentBotp((String)"backconsumemomentbotp");
        Long ruleId = 2000881926105430016L;
        if (StringUtils.isNotEmpty((CharSequence)consumemomentbotp)) {
            ruleId = Long.parseLong(consumemomentbotp);
        }
        toStockParamMap.put("botpNumber", ruleId);
        toStockParamMap.put("paramMap", paramMap);
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("billStatus", BillStatus.AUDIT.getVal());
        ScMultiCosmicStdParamArgs scMultiParamArgs = new ScMultiCosmicStdParamArgs();
        scMultiParamArgs.setCloudId("scm");
        scMultiParamArgs.setAppId("scp");
        scMultiParamArgs.setServiceName("IScpSalOutAuditAutoModuleConsumeService");
        scMultiParamArgs.setMethodName("autoCreateModuleConsumeService");
        scMultiParamArgs.setParamMap(toStockParamMap);
        scMultiParamArgs.setParamType(MServiceParamType.GATHERMAP);
        return scMultiParamArgs;
    }

    public static Map<String, String> buildParam(DynamicObject bill, Map<String, String> salOutInfoMap, Map<Long, Collection<Long>> pushOrderData) {
        DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
        ScpModuleConsumeHelper.buildPurOrderData(pushOrderData, null, (List)rows);
        for (DynamicObject row : rows) {
            DynamicObjectCollection subEntryEntitys = row.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntryEntitys) {
                String subsrcbillentryid = subEntry.getString("subsrcbillentryid");
                ScpSalOutAuditCreateModuleConsumeForSelfPlugin.assembleCosmicParam(subsrcbillentryid, subEntry, salOutInfoMap);
                salOutInfoMap.put("subsrcbillno_" + subsrcbillentryid, bill.getString("billno"));
                salOutInfoMap.put("subsrcbilltype_" + subsrcbillentryid, "scp_saloutstock");
                salOutInfoMap.put("subsrcbillid_" + subsrcbillentryid, bill.getString("id"));
                salOutInfoMap.put("subsrcbillentryid_" + subsrcbillentryid, subEntry.getString("id"));
            }
        }
        return salOutInfoMap;
    }

    private static void assembleCosmicParam(String subsrcbillentryid, DynamicObject row, Map<String, String> salOutInfoMap) {
        BigDecimal qty = row.getBigDecimal("curconsumesubqty");
        BigDecimal basicQty = row.getBigDecimal("curconsumesubbaseqty");
        salOutInfoMap.put("curconsumesubqty_" + subsrcbillentryid, qty.toPlainString());
        salOutInfoMap.put("curconsumesubbaseqty_" + subsrcbillentryid, basicQty.toPlainString());
    }
}

