/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.orderalert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.util.OrderUtil;

public final class ScpOrderAlertHandle
extends AbstractDataHandlePlugin {
    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        if (dynamicObjects != null) {
            CosmicParamArgs cosmicParamArgs = (CosmicParamArgs)this.getScDataHandleArgs();
            if (cosmicParamArgs == null) {
                cosmicParamArgs = new CosmicParamArgs();
                cosmicParamArgs.setCloudId("scmc");
                cosmicParamArgs.setAppId("pm");
                cosmicParamArgs.setServiceName("PmSupColService");
                cosmicParamArgs.setMethodName("upChangeConfirmStatus");
            }
            ArrayList<Long> pks = new ArrayList<Long>(dynamicObjects.length);
            for (DynamicObject bill : dynamicObjects) {
                pks.add(bill.getLong("id"));
            }
            Map map = BFTrackerServiceHelper.findSourceBills((String)"pur_ordchange", (Long[])pks.toArray(new Long[pks.size()]));
            Set idSet = map == null ? null : (Set)map.get("pm_xpurorderbill");
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (idSet != null && !idSet.isEmpty()) {
                params.put("ids", new ArrayList(idSet));
                params.put("status", "B");
                cosmicParamArgs.setParamMap(params);
                cosmicParamArgs.setDataServiceId(this.getScDataHandleInfo().getHandleId());
                this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs);
            }
        }
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        if (dynamicObjects != null) {
            EASParamArgs easParamArgs = (EASParamArgs)this.getScDataHandleArgs();
            if (easParamArgs == null) {
                easParamArgs = new EASParamArgs();
                easParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
                easParamArgs.setMethod("doOrderAlertConfirm");
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            Map<String, Object> billdata = ScpOrderAlertHandle.getBillData(dynamicObjects);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billno", billdata);
            dataMap.put("cmfstatus", "3");
            dataMap.put("logstatus", this.getLogStatusMap(dynamicObjects));
            param.put("data", dataMap);
            param.put("billtype", "scp_ordchange");
            param.put("action", "confirm");
            param.put("code", "200");
            easParamArgs.setParamMap(param);
            this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
        }
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        if (dynamicObjects != null) {
            XkParamArgs xkParamArgs = (XkParamArgs)this.getScDataHandleArgs();
            if (xkParamArgs != null) {
                this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
            } else {
                xkParamArgs = new XkParamArgs();
                xkParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
                xkParamArgs.setMethod("doOrderAlertConfirm");
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            Map<String, Object> billdata = ScpOrderAlertHandle.getBillData(dynamicObjects);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billno", billdata);
            dataMap.put("cmfstatus", "3");
            dataMap.put("logstatus", this.getLogStatusMap(dynamicObjects));
            param.put("data", dataMap);
            param.put("billtype", "scp_ordchange");
            param.put("action", "confirm");
            param.put("code", "200");
            xkParamArgs.setParamMap(param);
            this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
        }
    }

    private static Map<String, Object> getBillData(DynamicObject[] objs) {
        HashMap<String, Object> billData = new HashMap<String, Object>((int)((double)objs.length / 0.75));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject dynamicObject : objs) {
            String billno = dynamicObject.getString("pobillno");
            HashMap entryMap = new HashMap();
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                Date entrydelidate = entry.getDate("entrydelidate");
                BigDecimal qty = entry.getBigDecimal("qty");
                String srcentryid = entry.getString("poentryid");
                if (billno.trim().length() <= 0 || !dynamicObject.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal())) continue;
                HashMap<String, Object> entryDataMap = new HashMap<String, Object>();
                entryDataMap.put("entrydelidate", sdf.format(entrydelidate));
                entryDataMap.put("qty", qty);
                entryMap.put(srcentryid, entryDataMap);
            }
            billData.put(billno, entryMap);
        }
        return billData;
    }

    private Set<String> getPoBillId(DynamicObject[] dynamicObjects) {
        HashSet<String> poBillIds = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            String poBillId = bill.getString("pobillid");
            if (poBillId == null || poBillId.isEmpty()) continue;
            poBillIds.add(poBillId);
        }
        return poBillIds;
    }

    private Map<String, String> getLogStatusMap(DynamicObject[] dynamicObjects) {
        DynamicObject[] orders = OrderUtil.getOrdersByPoBillIdS((String)"id,logstatus,materialentry.pobillid", this.getPoBillId(dynamicObjects));
        return OrderUtil.getPKValueStr((DynamicObject[])orders);
    }
}

