/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scporder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.util.DateUtil;

public final class ScpOrderConfirmPlugin
extends AbstractDataHandlePlugin {
    private Log logger = LogFactory.getLog(ScpOrderConfirmPlugin.class);

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
        HashSet<Long> confirmIdSet = new HashSet<Long>();
        confirmMap.put("status", ConfirmStatusEnum.CONFIRM.getVal());
        HashMap params = new HashMap();
        ArrayList batchBills = new ArrayList(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Serializable> batchBillsMap = new HashMap<String, Serializable>();
            ArrayList billEntry = new ArrayList();
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : dynamicObjectCollection) {
                String poBillId = entryRow.getString("pobillid");
                if (poBillId != null && !poBillId.trim().isEmpty()) {
                    confirmIdSet.add(Long.parseLong(poBillId));
                }
                batchBillsMap.put("orderBillId", Long.valueOf(entryRow.getString("pobillid")));
                HashMap<String, Object> billEntryMap = new HashMap<String, Object>();
                billEntryMap.put("entryId", Long.valueOf(entryRow.getString("poentryid")));
                billEntryMap.put("promiseDate", DateUtil.date2str((Date)entryRow.getDate("promiseday"), (String)"yyyy-MM-dd"));
                billEntry.add(billEntryMap);
            }
            batchBillsMap.put("billEntry", billEntry);
            batchBills.add(batchBillsMap);
        }
        params.put("batchBills", batchBills);
        ArrayList confirmIds = new ArrayList(confirmIdSet);
        confirmMap.put("ids", confirmIds);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scmc");
        cosmicParamArgs.setAppId("pm");
        cosmicParamArgs.setServiceName("PmSupColService");
        cosmicParamArgs.setMethodName("upOrderConfirmStatus");
        cosmicParamArgs.setParamMap(confirmMap);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, ConfirmStatusEnum.CONFIRM.getVal());
        HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
        logisticsMap.put("status", LogisticsStatusEnum.CONFIRM.getVal());
        logisticsMap.put("ids", confirmIds);
        CosmicParamArgs logStatus = new CosmicParamArgs();
        logStatus.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        logStatus.setCloudId("scmc");
        logStatus.setAppId("pm");
        logStatus.setServiceName("PmSupColService");
        logStatus.setMethodName("upLogisticsStatus");
        logStatus.setParamMap(logisticsMap);
        logStatus.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)logStatus, LogisticsStatusEnum.CONFIRM.getVal());
        CosmicParamArgs promiseDay = new CosmicParamArgs();
        promiseDay.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        promiseDay.setCloudId("scmc");
        promiseDay.setAppId("pm");
        promiseDay.setServiceName("PurOrderService");
        promiseDay.setMethodName("changeOrderBillPromiseDate");
        promiseDay.setParamMap(params);
        promiseDay.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)promiseDay, "ScpOrderConfirmPromiseDay");
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Set<String> billnoSet = this.getBillnoStr(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno");
        dataMap.put("billno", billnoSet);
        dataMap.put("cmfstatus", "3");
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "confirm");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        XkParamArgs xkParam = new XkParamArgs();
        xkParam.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        xkParam.setMethod("doOrderConfirm");
        xkParam.setParamMap(param);
        xkParam.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParam);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Set<String> billnoSet = this.getBillnoStr(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno");
        dataMap.put("billno", billnoSet);
        dataMap.put("cmfstatus", "3");
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "confirm");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        EASParamArgs easParamArgs = new EASParamArgs();
        easParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        easParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        easParamArgs.setApi("");
        easParamArgs.setMethod("doOrderConfirm");
        easParamArgs.setParamMap(param);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
    }

    private Set<String> getBillnoStr(DynamicObject[] objs, String billnoProperty) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            String billno = dynamicObject.getString(billnoProperty);
            if (numbers.contains(billno) && (billno.trim().length() <= 0 || !dynamicObject.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal()))) continue;
            numbers.add(billno);
        }
        return numbers;
    }
}

