/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scporder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;

public final class ScpOrderRejectPlugin
extends AbstractDataHandlePlugin {
    private Log logger = LogFactory.getLog(ScpOrderRejectPlugin.class);

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
        HashSet<Long> confirmIdSet = new HashSet<Long>();
        confirmMap.put("status", ConfirmStatusEnum.REJECT.getVal());
        for (DynamicObject dynamicObject : this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects()) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : dynamicObjectCollection) {
                String poBillId = entryRow.getString("pobillid");
                if (poBillId == null || poBillId.trim().isEmpty()) continue;
                confirmIdSet.add(Long.parseLong(poBillId));
            }
        }
        ArrayList confirmIds = new ArrayList(confirmIdSet);
        confirmMap.put("ids", confirmIds);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scmc");
        cosmicParamArgs.setAppId("pm");
        cosmicParamArgs.setServiceName("PmSupColService");
        cosmicParamArgs.setMethodName("upOrderConfirmStatus");
        cosmicParamArgs.setParamMap(confirmMap);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs);
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Set<String> billnoSet = this.getBillnoStr(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno");
        dataMap.put("billno", billnoSet);
        dataMap.put("cmfstatus", "3");
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "reject");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        XkParamArgs xkParam = new XkParamArgs();
        xkParam.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        xkParam.setMethod("doOrderReject");
        xkParam.setParamMap(param);
        xkParam.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParam);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Set<String> billnoSet = this.getBillnoStr(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno");
        dataMap.put("billno", billnoSet);
        dataMap.put("cmfstatus", "3");
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "reject");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        EASParamArgs easParamArgs = new EASParamArgs();
        easParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        easParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        easParamArgs.setApi("");
        easParamArgs.setMethod("doOrderReject");
        easParamArgs.setParamMap(param);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
    }

    private Set<String> getBillnoStr(DynamicObject[] objs, String billnoProperty) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            String billno = dynamicObject.getString(billnoProperty);
            if (numbers.contains(billno) && (billno.trim().length() <= 0 || !dynamicObject.getString("cfmstatus").equals(ConfirmStatusEnum.REJECT.getVal()))) continue;
            numbers.add(billno);
        }
        return numbers;
    }
}

