/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scporder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;

public final class ScpOrderUnConfirmPlugin
extends AbstractDataHandlePlugin {
    protected Log logger = LogFactory.getLog(ScpOrderUnConfirmPlugin.class);

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
        HashSet<Long> confirmIdSet = new HashSet<Long>();
        confirmMap.put("status", ConfirmStatusEnum.UNCONFIRM.getVal());
        for (DynamicObject dynamicObject : this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects()) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : dynamicObjectCollection) {
                String poBillId = entryRow.getString("pobillid");
                if (poBillId == null || poBillId.trim().isEmpty()) continue;
                confirmIdSet.add(Long.parseLong(poBillId));
            }
        }
        ArrayList confirmIds = new ArrayList(confirmIdSet);
        confirmMap.put("ids", confirmIds);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scmc");
        cosmicParamArgs.setAppId("pm");
        cosmicParamArgs.setServiceName("PmSupColService");
        cosmicParamArgs.setMethodName("upOrderConfirmStatus");
        cosmicParamArgs.setParamMap(confirmMap);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, ConfirmStatusEnum.UNCONFIRM.getVal());
        HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
        logisticsMap.put("status", "");
        logisticsMap.put("ids", confirmIds);
        CosmicParamArgs logStatus = new CosmicParamArgs();
        logStatus.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        logStatus.setCloudId("scmc");
        logStatus.setAppId("pm");
        logStatus.setServiceName("PmSupColService");
        logStatus.setMethodName("upLogisticsStatus");
        logStatus.setParamMap(logisticsMap);
        logStatus.setDynamicObjects(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects());
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)logStatus);
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("billno", this.getBillnoSet(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno"));
        dataMap.put("cmfstatus", ConfirmStatusEnum.UNCONFIRM.getVal());
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "unconfirm");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        XkParamArgs xkParamArgs = new XkParamArgs();
        xkParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        xkParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        xkParamArgs.setMethod("doOrderUnConfirm");
        xkParamArgs.setParamMap(param);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("billno", this.getBillnoSet(this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects(), "billno"));
        dataMap.put("cmfstatus", ConfirmStatusEnum.UNCONFIRM.getVal());
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "unconfirm");
        param.put("code", "200");
        this.logger.info(((Object)param).toString());
        EASParamArgs easParamArgs = new EASParamArgs();
        easParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        easParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        easParamArgs.setApi("");
        easParamArgs.setMethod("doOrderUnConfirm");
        easParamArgs.setParamMap(param);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
    }

    private Set<String> getBillnoSet(DynamicObject[] objs, String billnoProperty) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            String billno = dynamicObject.getString(billnoProperty);
            if (billno.trim().length() <= 0 || !dynamicObject.getString("cfmstatus").equals(ConfirmStatusEnum.UNCONFIRM.getVal())) continue;
            numbers.add(billno);
        }
        return numbers;
    }
}

