/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scpsaloutstock;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.service.botp.entity.BotpRule;
import kd.scm.common.service.botp.impl.EasBotpServiceImpl;
import kd.scm.common.service.botp.impl.XkBotpServiceImpl;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.scp.business.ScpAutoStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpAutoSalOutStockPlugin
extends AbstractDataHandlePlugin {
    private static final String PM_PURORDER = "pm_purorderbill";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        Boolean isAutoReceive = this.isAutoReceive(dynamicObjects);
        Boolean isautoaccept = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"isautoaccept");
        if (ScmcUtil.checkReceiptVersion().booleanValue() && "splitrow".equals(ScmcUtil.checkSplitStrategy())) {
            for (DynamicObject bill : dynamicObjects) {
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                LinkedHashMap<Long, Collection<Long>> pushOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
                LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap = new LinkedHashMap<String, List<Map<String, String>>>(56);
                HashSet<String> salOutEntryIds = new HashSet<String>(16);
                LinkedHashMap<Long, Collection<Long>> pushAcceptOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
                LinkedHashMap<String, List<Map<String, String>>> rowAcceptSalOutInfoMap = new LinkedHashMap<String, List<Map<String, String>>>(56);
                HashSet<String> acceptSalOutEntryIds = new HashSet<String>(16);
                for (DynamicObject row : rows) {
                    String entrystatus = row.getString("entrystatus");
                    if ("B".equals(entrystatus)) continue;
                    boolean lineTypeacceptance = LineTypeUtil.isLineTypeacceptance((DynamicObject)row);
                    if (!lineTypeacceptance) {
                        this.buildParam(bill, row, pushOrderData, rowSalOutInfoMap, salOutEntryIds, autoExtEntryPro, false);
                        continue;
                    }
                    this.buildParam(bill, row, pushAcceptOrderData, rowAcceptSalOutInfoMap, acceptSalOutEntryIds, autoExtEntryPro, true);
                }
                if (!CollectionUtils.isEmpty(pushOrderData) && isAutoReceive.booleanValue()) {
                    this.executeService(dynamicObjects, pushOrderData, null, rowSalOutInfoMap, salOutEntryIds, bill.getString("id"));
                }
                if (CollectionUtils.isEmpty(pushAcceptOrderData) || !isautoaccept.booleanValue()) continue;
                this.executeAcceptService(dynamicObjects, pushAcceptOrderData, null, rowAcceptSalOutInfoMap, acceptSalOutEntryIds, bill.getString("id"));
            }
        } else {
            ArrayList<String> unDoData = new ArrayList<String>();
            ArrayList<String> unDoAcceptData = new ArrayList<String>();
            for (DynamicObject bill : dynamicObjects) {
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : rows) {
                    String entrystatus = row.getString("entrystatus");
                    if ("B".equals(entrystatus)) continue;
                    boolean lineTypeacceptance = LineTypeUtil.isLineTypeacceptance((DynamicObject)row);
                    if (!lineTypeacceptance) {
                        unDoData.add(row.getString("id"));
                        continue;
                    }
                    unDoAcceptData.add(row.getString("id"));
                }
            }
            if (!CollectionUtils.isEmpty(unDoData) && isAutoReceive.booleanValue()) {
                this.executeService(dynamicObjects, autoExtEntryPro, unDoData, false);
            }
            if (!CollectionUtils.isEmpty(unDoAcceptData) && isautoaccept.booleanValue()) {
                this.executeService(dynamicObjects, autoExtEntryPro, unDoAcceptData, true);
            }
        }
    }

    private void executeService(DynamicObject[] dynamicObjects, Map<String, String> autoExtEntryPro, List<String> unDoData, Boolean isAccept) {
        LinkedHashMap<String, String> havePushSalOut = new LinkedHashMap<String, String>(1024);
        int rowIndex = 1;
        while (unDoData.size() > 0) {
            ArrayList<String> unDoTempData = new ArrayList<String>();
            HashSet<String> salOutEntryIds = new HashSet<String>(16);
            for (DynamicObject bill : dynamicObjects) {
                LinkedHashMap<String, String> havePush = new LinkedHashMap<String, String>(1024);
                LinkedHashMap<Long, Collection<Long>> pushOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
                HashSet<Long> poEntryIdSet = null;
                LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
                HashMap billMap = new HashMap(16);
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : rows) {
                    String entryId = row.getString("id");
                    String poBillId = row.getString("pobillid");
                    String poEntryId = row.getString("poentryid");
                    if (poBillId.isEmpty() || poEntryId.isEmpty() || havePushSalOut.containsKey(entryId)) continue;
                    String entryHaveId = (String)havePush.get(poEntryId);
                    if (entryHaveId != null) {
                        unDoTempData.add(entryId);
                        continue;
                    }
                    salOutEntryIds.add(entryId);
                    havePush.put(poEntryId, entryId);
                    havePushSalOut.put(entryId, poEntryId);
                    poEntryIdSet = (HashSet<Long>)pushOrderData.get(Long.parseLong(poBillId));
                    if (poEntryIdSet == null) {
                        poEntryIdSet = new HashSet<Long>();
                        poEntryIdSet.add(Long.parseLong(poEntryId));
                        pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
                    } else {
                        poEntryIdSet.add(Long.parseLong(poEntryId));
                        pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
                    }
                    salOutInfoMap.putAll(this.assembleCosmicfParam(poEntryId, bill, row, autoExtEntryPro, isAccept));
                    if (billMap.isEmpty()) {
                        billMap.putAll(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)bill, autoExtEntryPro));
                        salOutInfoMap.putAll(billMap);
                        continue;
                    }
                    salOutInfoMap.putAll(billMap);
                }
                String suffix = bill.getString("id") + rowIndex;
                if (!isAccept.booleanValue()) {
                    this.executeService(dynamicObjects, pushOrderData, salOutInfoMap, null, salOutEntryIds, suffix);
                    continue;
                }
                this.executeAcceptService(dynamicObjects, pushOrderData, salOutInfoMap, null, salOutEntryIds, suffix);
            }
            unDoData = unDoTempData;
            ++rowIndex;
        }
    }

    private void buildParam(DynamicObject bill, DynamicObject row, Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Set<String> salOutEntryIds, Map<String, String> autoExtEntryPro, Boolean isAccept) {
        String poBillId = row.getString("pobillid");
        String poEntryId = row.getString("poentryid");
        if (!poBillId.isEmpty() && !poEntryId.isEmpty()) {
            salOutEntryIds.add(row.getString("id"));
            Collection<Long> orderEntry = pushOrderData.get(Long.parseLong(poBillId));
            if (orderEntry != null) {
                orderEntry.add(Long.parseLong(poEntryId));
            } else {
                orderEntry = new HashSet<Long>(16);
                orderEntry.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), orderEntry);
            }
            List<Map<String, String>> salOutInfoS = rowSalOutInfoMap.get(poEntryId);
            Map<String, String> cosmicParam = this.assembleCosmicfParam(poEntryId, bill, row, autoExtEntryPro, isAccept);
            if (salOutInfoS != null) {
                salOutInfoS.add(cosmicParam);
            } else {
                salOutInfoS = new ArrayList<Map<String, String>>();
                salOutInfoS.add(cosmicParam);
                rowSalOutInfoMap.put(poEntryId, salOutInfoS);
            }
        }
    }

    private void executeAcceptService(DynamicObject[] dynamicObjects, Map<Long, Collection<Long>> pushOrderData, Map<String, String> salOutInfoMap, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Set<String> salOutEntryIds, String suffix) {
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(2);
        toStockParamMap.put("sourceEntity", PM_PURORDER);
        toStockParamMap.put("targetEntity", PM_PURACCEPTBILL);
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("rowSalOutInfoMap", rowSalOutInfoMap);
        toStockParamMap.put("salOutInfoMap", salOutInfoMap);
        toStockParamMap.put("salOutEntryIds", salOutEntryIds);
        toStockParamMap.put("isAmountCriterion", "false");
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scm");
        cosmicParamArgs.setAppId("pur");
        cosmicParamArgs.setServiceName("IPurAcceptApplyToPuracceptbillService");
        cosmicParamArgs.setMethodName("acceptApplyToPuracceptbill");
        cosmicParamArgs.setParamMap(toStockParamMap);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, suffix);
    }

    private void executeService(DynamicObject[] dynamicObjects, Map<Long, Collection<Long>> pushOrderData, Map<String, String> salOutInfoMap, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Set<String> salOutEntryIds, String suffix) {
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(2);
        toStockParamMap.put("sourceEntity", PM_PURORDER);
        toStockParamMap.put("targetEntity", IM_PURRECEIVEBILL);
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("rowSalOutInfoMap", rowSalOutInfoMap);
        toStockParamMap.put("salOutInfoMap", salOutInfoMap);
        toStockParamMap.put("salOutEntryIds", salOutEntryIds);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scm");
        cosmicParamArgs.setAppId("scp");
        cosmicParamArgs.setServiceName("IPurSalOutStockToReceive");
        cosmicParamArgs.setMethodName("salOutStockToReceive");
        cosmicParamArgs.setParamMap(toStockParamMap);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, suffix);
    }

    private Map<String, String> assembleCosmicfParam(String poEntryId, DynamicObject bill, DynamicObject row, Map<String, String> autoExtEntryPro, Boolean isAccept) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
        String billNo = bill.getString("billno");
        String billId = bill.getString("id");
        String entryId = row.getString("id");
        BigDecimal qty = row.getBigDecimal("qty");
        if (!isAccept.booleanValue()) {
            salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
            salOutInfoMap.put("saloutNo_" + poEntryId, billNo);
            salOutInfoMap.put("saloutId_" + poEntryId, billId);
            salOutInfoMap.put("saloutEntryId_" + poEntryId, entryId);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
            String suplot1 = row.getString("suplot");
            Date proddate1 = row.getDate("proddate");
            Date duedate1 = row.getDate("duedate");
            if (suplot1 != null) {
                salOutInfoMap.put("suplot_" + poEntryId, suplot1);
            }
            if (proddate1 != null) {
                salOutInfoMap.put("proddate_" + poEntryId, sf.format(proddate1));
            }
            if (duedate1 != null) {
                salOutInfoMap.put("duedate_" + poEntryId, sf.format(duedate1));
            }
        } else {
            String note = row.getString("note");
            salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
            salOutInfoMap.put("soubillnumber_" + poEntryId, billNo);
            salOutInfoMap.put("soubillid_" + poEntryId, billId);
            salOutInfoMap.put("soubillentryid_" + poEntryId, entryId);
            if (note != null) {
                salOutInfoMap.put("entrycomment_" + poEntryId, note);
            }
        }
        Map<String, String> autoExtStockBill = ScpAutoSalOutStockPlugin.assembleAutoExtStockBill(row, autoExtEntryPro);
        if (!autoExtStockBill.isEmpty()) {
            for (Map.Entry<String, String> entry : autoExtStockBill.entrySet()) {
                salOutInfoMap.put(entry.getKey() + "_" + poEntryId, entry.getValue());
            }
        }
        return salOutInfoMap;
    }

    public static Map<String, String> assembleAutoExtStockBill(DynamicObject bill, Map<String, String> sdkEntryMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, sdkEntryMap));
        return extStockData;
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        Boolean autoReceive = this.isAutoReceive(dynamicObjects);
        if (!autoReceive.booleanValue()) {
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>(3);
        customParam.put("srctype", "order");
        customParam.put("targetBillType", "receive");
        HashSet<String> entryIdSet = new HashSet<String>(dynamicObjects.length);
        HashSet<String> billIdSet = new HashSet<String>(dynamicObjects.length);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
        HashSet<String> recOrgIdSet = new HashSet<String>(1024);
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        for (DynamicObject bill : dynamicObjects) {
            String billNo = bill.getString("billno");
            String billIdStr = bill.getString("id");
            DynamicObject dynamicObject = bill.getDynamicObject("org");
            if (dynamicObject != null) {
                recOrgIdSet.add(dynamicObject.getString("id"));
                org_IdMap.put(dynamicObject.getString("number"), dynamicObject.getString("id"));
            }
            HashMap billMap = new HashMap(16);
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String entrystatus = row.getString("entrystatus");
                if ("B".equals(entrystatus)) continue;
                HashMap<String, Object> billInfoMap = new HashMap<String, Object>(16);
                String entryId = row.getString("id");
                String poBillId = row.getString("pobillid");
                String poEntryId = row.getString("poentryid");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                entryIdSet.add(poEntryId);
                billIdSet.add(poBillId);
                billInfoMap.put("lot", row.getString("lot"));
                billInfoMap.put("suplot", row.getString("suplot"));
                billInfoMap.put("srcEntryId", entryId);
                billInfoMap.put("qty", row.getBigDecimal("qty"));
                billInfoMap.put("billid", poBillId);
                billInfoMap.put("entryId", poEntryId);
                billInfoMap.put("srcBillNo", billNo);
                billInfoMap.put("srcBillId", billIdStr);
                billInfoMap.put("proddate", row.getDate("proddate"));
                billInfoMap.put("mfg", row.getDate("proddate"));
                billInfoMap.put("duedate", row.getDate("duedate"));
                billInfoMap.put("exp", row.getDate("duedate"));
                billInfoMap.put("unit", row.getDynamicObject("unit") == null ? "" : row.getDynamicObject("unit").getString("number"));
                billInfoMap.put("basicUnit", row.getDynamicObject("basicunit") == null ? "" : row.getDynamicObject("basicunit").getString("number"));
                billInfoMap.put("warehouse", row.getDynamicObject("warehouse") == null ? "" : row.getDynamicObject("warehouse").getString("number"));
                billInfoMap.put("location", "");
                billInfoMap.put("trace", row.getDynamicObject("trace") == null ? "" : row.getDynamicObject("trace").getString("number"));
                billInfoMap.put("supplierlot", row.getString("suplot"));
                if (billMap.isEmpty()) {
                    billMap.putAll(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)bill, (Map)autoExtEntryPro));
                    billInfoMap.putAll(billMap);
                } else {
                    billInfoMap.putAll(billMap);
                }
                billInfoMap.putAll(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)row, (Map)autoExtEntryPro));
                billInfoMap.put("extFieldSet", autoExtEntryPro.values());
                dataMap.put(entryId, billInfoMap);
            }
        }
        HashMap<String, Object> groupedData = new HashMap<String, Object>();
        dataMap.forEach((key, val) -> {
            Map data = (Map)val;
            String srcBillId = String.valueOf(data.get("srcBillId"));
            ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
            if (list == null) {
                list = new ArrayList<Map>();
            }
            list.add(data);
            groupedData.put(srcBillId, list);
        });
        String botpNumber = null;
        EasBotpServiceImpl botpService = new EasBotpServiceImpl();
        customParam.put("billId", billIdSet);
        customParam.put("entryId", entryIdSet);
        customParam.put("isclinknumber", this.getScHandleParamProxy().getMajorDataParamArgs().getIscDataLinkNumber());
        List ruleList = botpService.getRuleList("order", "receive", customParam);
        if (ruleList != null && !ruleList.isEmpty()) {
            Optional<BotpRule> first = ruleList.stream().filter(BotpRule::isDefRule).findFirst();
            if (first.isPresent()) {
                botpNumber = first.get().getId();
            }
            if (botpNumber == null || botpNumber.isEmpty()) {
                botpNumber = ((BotpRule)ruleList.get(0)).getId();
            }
        }
        if (botpNumber != null && !botpNumber.isEmpty()) {
            Map paramMap = ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus", recOrgIdSet);
            for (Map.Entry entry : org_IdMap.entrySet()) {
                org_IdMap.put((String)entry.getKey(), (String)paramMap.get(entry.getValue()));
            }
            if (ApiConfigUtil.hasEASScmConfig()) {
                ScmcUtil.putSplitStrategyMap(groupedData);
            }
            groupedData.put("billstatus1", org_IdMap);
            groupedData.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
            groupedData.put("botpNumber", botpNumber);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", groupedData);
            param.put("action", "receive");
            param.put("code", "200");
            ApiUtil.putUserNUmberData(param, (String)"scp_saloutstock", (DynamicObject[])dynamicObjects);
            EASParamArgs eASParamArgs = new EASParamArgs();
            eASParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
            eASParamArgs.setMethod("doIerp2Receive");
            eASParamArgs.setParamMap(param);
            eASParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
            this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)eASParamArgs);
        }
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_service_flow", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KD_SRM_SCP_Salout2CKReceive(CQ-XK)")});
        Boolean isExecute = Boolean.FALSE;
        isExecute = dynamicObject != null ? Boolean.valueOf(!dynamicObject.getBoolean("enable")) : Boolean.TRUE;
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        Boolean autoReceive = this.isAutoReceive(dynamicObjects);
        if (!autoReceive.booleanValue()) {
            return;
        }
        if (isExecute.booleanValue()) {
            HashMap<String, Object> customParam = new HashMap<String, Object>(3);
            customParam.put("srctype", "order");
            customParam.put("targetBillType", "receive");
            HashSet<String> entryIdSet = new HashSet<String>(dynamicObjects.length);
            HashSet<String> billIdSet = new HashSet<String>(dynamicObjects.length);
            HashMap dataMap = new HashMap(8);
            HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
            HashSet<String> recOrgIdSet = new HashSet<String>(1024);
            Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
            for (DynamicObject bill : dynamicObjects) {
                String billNo = bill.getString("billno");
                String billIdStr = bill.getString("id");
                DynamicObject org = bill.getDynamicObject("org");
                if (org != null) {
                    recOrgIdSet.add(org.getString("id"));
                    org_IdMap.put(org.getString("number"), org.getString("id"));
                }
                String extBillDataString = null;
                DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : dynamicObjectCollection) {
                    String entrystatus = row.getString("entrystatus");
                    if ("B".equals(entrystatus)) continue;
                    HashMap<String, Object> billInfoMap = new HashMap<String, Object>(16);
                    String entryId = row.getString("id");
                    String poBillId = row.getString("pobillid");
                    String poEntryId = row.getString("poentryid");
                    if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                    entryIdSet.add(poEntryId);
                    billIdSet.add(poBillId);
                    billInfoMap.put("lot", row.getString("lot"));
                    billInfoMap.put("suplot", row.getString("suplot"));
                    billInfoMap.put("srcEntryId", entryId);
                    billInfoMap.put("qty", row.getBigDecimal("qty"));
                    billInfoMap.put("billid", poBillId);
                    billInfoMap.put("entryId", poEntryId);
                    billInfoMap.put("srcBillNo", billNo);
                    billInfoMap.put("srcBillId", billIdStr);
                    billInfoMap.put("proddate", row.getDate("proddate"));
                    billInfoMap.put("mfg", row.getDate("proddate"));
                    billInfoMap.put("duedate", row.getDate("duedate"));
                    billInfoMap.put("exp", row.getDate("duedate"));
                    billInfoMap.put("unit", row.getDynamicObject("unit") == null ? "" : row.getDynamicObject("unit").getString("number"));
                    billInfoMap.put("basicUnit", row.getDynamicObject("basicunit") == null ? "" : row.getDynamicObject("basicunit").getString("number"));
                    billInfoMap.put("warehouse", row.getDynamicObject("warehouse") == null ? "" : row.getDynamicObject("warehouse").getString("number"));
                    billInfoMap.put("location", "");
                    billInfoMap.put("trace", row.getDynamicObject("trace") == null ? "" : row.getDynamicObject("trace").getString("number"));
                    billInfoMap.put("supplierlot", row.getString("suplot"));
                    if (extBillDataString == null) {
                        HashMap<String, String> billMap = new HashMap<String, String>(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)bill, (Map)autoExtEntryPro));
                        extBillDataString = this.assembleExtDataString(billMap);
                        billInfoMap.put("HOtherFields", extBillDataString);
                    } else {
                        billInfoMap.put("HOtherFields", extBillDataString);
                    }
                    billInfoMap.put("EOtherFields", this.assembleExtDataString(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)row, (Map)autoExtEntryPro)));
                    dataMap.put(entryId, billInfoMap);
                }
            }
            HashMap<String, Object> groupedData = new HashMap<String, Object>();
            ArrayList valueList = new ArrayList(dataMap.values());
            int num = 0;
            while (!valueList.isEmpty()) {
                ArrayList<Map> unDoData = new ArrayList<Map>();
                for (Object o : valueList) {
                    Map data = (Map)o;
                    String srcBillId = String.valueOf(data.get("srcBillId"));
                    String string = String.valueOf(data.get("entryId"));
                    String srcBillIdStr = (String)srcBillId + num;
                    ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillIdStr);
                    if (list == null) {
                        list = new ArrayList<Map>();
                        list.add(data);
                        groupedData.put(srcBillIdStr, list);
                        continue;
                    }
                    boolean present = list.stream().filter(l -> l.get("entryId").equals(entryId)).findAny().isPresent();
                    if (!present) {
                        list.add(data);
                        groupedData.put(srcBillIdStr, list);
                        continue;
                    }
                    unDoData.add(data);
                }
                valueList.clear();
                valueList.addAll(unDoData);
                ++num;
            }
            String botpNumber = null;
            XkBotpServiceImpl botpService = new XkBotpServiceImpl();
            customParam.put("billId", billIdSet);
            customParam.put("entryId", entryIdSet);
            customParam.put("isclinknumber", this.getScHandleParamProxy().getMajorDataParamArgs().getIscDataLinkNumber());
            List ruleList = botpService.getRuleList("order", "receive", customParam);
            if (ruleList != null && !ruleList.isEmpty()) {
                Optional<BotpRule> first = ruleList.stream().filter(BotpRule::isDefRule).findFirst();
                if (first.isPresent()) {
                    botpNumber = first.get().getId();
                }
                if (botpNumber == null || botpNumber.isEmpty()) {
                    botpNumber = ((BotpRule)ruleList.get(0)).getId();
                }
            }
            if (botpNumber != null && !botpNumber.isEmpty()) {
                Map paramMap = ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus", recOrgIdSet);
                for (Map.Entry entry : org_IdMap.entrySet()) {
                    org_IdMap.put((String)entry.getKey(), (String)paramMap.get(entry.getValue()));
                }
                groupedData.put("billstatus1", org_IdMap);
                groupedData.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
                groupedData.put("botpNumber", botpNumber);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("tobilltype", "receive");
                param.put("billtype", "pur_outstock");
                param.put("data", groupedData);
                param.put("action", "receive");
                param.put("code", "200");
                ApiUtil.putUserNUmberData(param, (String)"scp_saloutstock", (DynamicObject[])dynamicObjects);
                XkParamArgs xkParamArgs = new XkParamArgs();
                xkParamArgs.setFacade("");
                xkParamArgs.setMethod("doIerp2Receive");
                xkParamArgs.setParamMap(param);
                xkParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
                this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
            }
        } else {
            this.getScDataHandleResult().setMessage("execute isc_service_flow KD_SRM_SCP_Salout2CKReceive(CQ-XK)");
        }
    }

    private Boolean isAutoReceive(DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length > 0) {
            DynamicObject org = dynamicObjects[0].getDynamicObject("org");
            HashSet<Long> unitOrgIds = new HashSet<Long>(16);
            unitOrgIds.add((Long)org.getPkValue());
            Map autoReceiptNoticeBill = ScpAutoStockBillHelper.verifyAutoReceiptBill(unitOrgIds);
            Boolean isAutoReceive = autoReceiptNoticeBill.values().stream().allMatch(row -> row);
            return isAutoReceive;
        }
        return false;
    }

    public void easCallBack(ScDataHandleResult scDataHandleResult) {
        this.storeAutoTrdReceiveBillNo(scDataHandleResult);
    }

    public void xkCallBack(ScDataHandleResult scDataHandleResult) {
        this.storeAutoTrdReceiveBillNo(scDataHandleResult);
    }

    private void storeAutoTrdReceiveBillNo(ScDataHandleResult scDataHandleResult) {
        String message = scDataHandleResult.getMessage();
        if (message != null) {
            HashMap messageMap = new HashMap();
            try {
                messageMap.putAll((Map)JacksonJsonUtil.fromJson((String)message, Map.class));
                if (!messageMap.isEmpty()) {
                    ScpAutoStockBillHelper.updateSalOutStockReceiptBillNO(messageMap);
                }
            }
            catch (Throwable throwable) {
                this.logger.error(ExceptionUtil.getStackTrace((Throwable)throwable));
            }
        }
    }

    private String assembleExtDataString(Map<String, String> billMap) {
        StringBuilder extDataString = new StringBuilder();
        for (Map.Entry<String, String> entry : billMap.entrySet()) {
            extDataString.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        return extDataString.toString();
    }
}

