/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scpsaloutstock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpDeleteReceiveBillPlugin
extends AbstractDataHandlePlugin {
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        ArrayList<DynamicObject> listReceiveBills = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> listAcceptBills = new ArrayList<DynamicObject>(8);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            Iterator iterator = rows.iterator();
            if (!iterator.hasNext()) continue;
            DynamicObject row = (DynamicObject)iterator.next();
            boolean lineTypeacceptance = LineTypeUtil.isLineTypeacceptance((DynamicObject)row);
            if (!lineTypeacceptance) {
                listReceiveBills.add(bill);
                continue;
            }
            listAcceptBills.add(bill);
        }
        if (!CollectionUtils.isEmpty(listReceiveBills)) {
            this.salOutStockDeleteReceive(listReceiveBills.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(listAcceptBills)) {
            this.salOutStockDeleteAccept(listAcceptBills.toArray(new DynamicObject[0]));
        }
    }

    private void salOutStockDeleteAccept(DynamicObject[] dynamicObjects) {
        Set<Long> assembleStdSalOutDataMap = ScpDeleteReceiveBillPlugin.assembleStdCleanAutoReceive(dynamicObjects, PM_PURACCEPTBILL);
        Set<String> assembleStdAutoReceiveBillNo = ScpDeleteReceiveBillPlugin.assembleStdAutoReceiveBillNo(dynamicObjects);
        HashMap<String, Set<Object>> toStockParamMap = new HashMap<String, Set<Object>>(2);
        toStockParamMap.put("imReceiveBillIds", assembleStdSalOutDataMap);
        toStockParamMap.put("imReceiveBillNo", assembleStdAutoReceiveBillNo);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scm");
        cosmicParamArgs.setAppId("pur");
        cosmicParamArgs.setServiceName("IPurAcceptApplyToPuracceptbillService");
        cosmicParamArgs.setMethodName("acceptApplyDelPuracceptbill");
        cosmicParamArgs.setParamMap(toStockParamMap);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs);
    }

    public static Set<Long> assembleStdCleanAutoReceive(DynamicObject[] dynamicObjects, String targetEntity) {
        HashSet<Long> imReceiveBillIds = new HashSet<Long>(dynamicObjects.length);
        HashSet<Long> salOutBillIds = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            Long billId = bill.getLong("id");
            salOutBillIds.add(billId);
        }
        if (!salOutBillIds.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)targetEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.soubillid", "in", salOutBillIds)}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    imReceiveBillIds.add(row.getLong("id"));
                }
            }
        }
        return imReceiveBillIds;
    }

    public static Set<String> assembleStdAutoReceiveBillNo(DynamicObject[] dynamicObjects) {
        HashSet<String> imReceiveBillIds = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : dynamicObjectCollection) {
                String autorecbillno = row.getString("autorecbillno");
                if (autorecbillno.trim().isEmpty()) continue;
                imReceiveBillIds.add(autorecbillno);
            }
        }
        return imReceiveBillIds;
    }

    private void salOutStockDeleteReceive(DynamicObject[] dynamicObjects) {
        Set assembleStdSalOutDataMap = ScpSalOutStockBillHelper.assembleStdCleanAutoReceive((DynamicObject[])dynamicObjects);
        Set assembleStdAutoReceiveBillNo = ScpSalOutStockBillHelper.assembleStdAutoReceiveBillNo((DynamicObject[])dynamicObjects);
        HashMap<String, Set> toStockParamMap = new HashMap<String, Set>(2);
        toStockParamMap.put("imReceiveBillIds", assembleStdSalOutDataMap);
        toStockParamMap.put("imReceiveBillNo", assembleStdAutoReceiveBillNo);
        CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
        cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        cosmicParamArgs.setCloudId("scm");
        cosmicParamArgs.setAppId("scp");
        cosmicParamArgs.setServiceName("IPurSalOutStockToReceive");
        cosmicParamArgs.setMethodName("salOutStockDeleteReceive");
        cosmicParamArgs.setParamMap(toStockParamMap);
        cosmicParamArgs.setDynamicObjects(dynamicObjects);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        Map resultMap = ScpSalOutStockBillHelper.cleanAutoTrdStockBill((DynamicObject[])dynamicObjects, (String)"KD_SRM_PUR_SALOUTSTOCK_RECEIVE_DELETE(CQ-EAS)");
        if (!resultMap.isEmpty()) {
            this.getScDataHandleResult().setSuccess(((Boolean)resultMap.get("succed")).booleanValue());
            this.getScDataHandleResult().setMessage(String.valueOf(resultMap.get("message")));
        }
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = assembleHandleArgs.getDynamicObjects();
        Map resultMap = ScpSalOutStockBillHelper.cleanAutoTrdStockBill((DynamicObject[])dynamicObjects, (String)"KD_SRM_PUR_SALOUTSTOCK_RECEIVE_DELETE(CQ-XK)");
        if (!resultMap.isEmpty()) {
            this.getScDataHandleResult().setSuccess(((Boolean)resultMap.get("succed")).booleanValue());
            this.getScDataHandleResult().setMessage(String.valueOf(resultMap.get("message")));
        }
    }
}

