/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scpsaloutstock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.scp.common.enums.BillStatus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public final class ScpSalOutAuditAutoModuleConsumeService {
    private static Log log = LogFactory.getLog(ScpSalOutAuditAutoModuleConsumeService.class);

    public Map<String, Object> autoCreateModuleConsumeService(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("succed", Boolean.TRUE);
        String sourceEntity = map.get("sourceEntity").toString();
        String targetEntity = map.get("targetEntity").toString();
        Object botpNumberObj = map.get("botpNumber");
        Object billStatusObj = map.get("billStatus");
        String botpNumber = null;
        if (botpNumberObj != null) {
            botpNumber = botpNumberObj.toString();
        }
        String billStatus = BillStatus.AUDIT.getVal();
        if (billStatusObj != null) {
            billStatus = billStatusObj.toString();
        }
        Map paramMap = (Map)map.get("paramMap");
        Map pushOrderData = (Map)map.get("pushOrderData");
        this.pushModuleConsume(resultMap, sourceEntity, targetEntity, paramMap, pushOrderData, botpNumber, billStatus);
        return resultMap;
    }

    private void pushModuleConsume(Map<String, Object> resultMap, String sourceEntity, String targetEntity, Map<String, String> paramMap, Map<Long, Collection<Long>> pushOrderData, String ruleId, String billStatus) {
        ConvertRuleElement convertRuleElementParam = null;
        String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\u3002", (String)"ScpSalOutAuditAutoModuleConsumeService_0", (String)"scm-scp-mservice", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((String)ruleId)) {
            convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)ruleId);
        } else {
            List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (ruleList != null && !ruleList.isEmpty()) {
                convertRuleElementParam = new ConvertRuleElement();
                convertRuleElementParam.setSourceEntityNumber(sourceEntity);
                convertRuleElementParam.setTargetEntityNumber(targetEntity);
            } else {
                throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
            }
        }
        if (convertRuleElementParam == null) {
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        resultMap.putAll(ScpSalOutAuditAutoModuleConsumeService.pushStockBill(convertRuleElementParam, pushOrderData, paramMap, billStatus));
    }

    public static Map<String, Object> pushStockBill(ConvertRuleElement element, Map<Long, Collection<Long>> pushOrderData, Map<String, String> salOutInfoMap, String billStatus) {
        String srcEntity = element.getSourceEntityNumber();
        String tarEntity = element.getTargetEntityNumber();
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(tarEntity);
        pushArgs.setBuildConvReport(true);
        if (element.getId() != null) {
            pushArgs.setRuleId(element.getId());
        }
        for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
            Long entryKey = entry.getKey();
            for (Long next : entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setSubEntryEntityKey("subentryentity");
                listSelectedRow.setSubEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        for (Map.Entry<Object, Object> entry : salOutInfoMap.entrySet()) {
            pushArgs.addCustomParam((String)entry.getKey(), (String)entry.getValue());
        }
        return ScpSalOutAuditAutoModuleConsumeService.doPushBill(pushArgs, billStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> doPushBill(PushArgs pushArgs, String billStatus) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.FALSE);
        returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f\u3002", (String)"ScpSalOutAuditAutoModuleConsumeService_1", (String)"scm-scp-mservice", (Object[])new Object[0]));
        pushArgs.setBuildConvReport(true);
        pushArgs.addCustomParam("botp_outformula", String.valueOf(Boolean.TRUE));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess()) {
            OperationResult operationResult;
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            result.release(refDataProvider, mainType);
            StringBuilder errorMsg = new StringBuilder().append(result.getMessage());
            Set<Object> successIds = new HashSet(targetData.size());
            HashSet<Long> needDeleteIds = new HashSet<Long>();
            HashSet<Long> unSubmitIds = new HashSet<Long>();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            try {
                if (BillStatus.SAVE.getVal().equals(billStatus)) {
                    operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult != null) {
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, needDeleteIds, operationResult, "");
                    }
                } else if (BillStatus.SUBMIT.getVal().equals(billStatus)) {
                    operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult != null) {
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, needDeleteIds, operationResult, "addAll");
                    }
                    if (!successIds.isEmpty()) {
                        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)pushArgs.getTargetEntityNumber(), (Object[])successIds.toArray(new Long[0]), (OperateOption)operateOption);
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, needDeleteIds, operationResult, "removeAll");
                    }
                } else {
                    operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult != null) {
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, needDeleteIds, operationResult, "addAll");
                    }
                    if (!successIds.isEmpty()) {
                        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)pushArgs.getTargetEntityNumber(), (Object[])successIds.toArray(new Long[0]), (OperateOption)operateOption);
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, needDeleteIds, operationResult, "removeAll");
                    }
                    if (!successIds.isEmpty()) {
                        unSubmitIds.addAll(successIds);
                        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)pushArgs.getTargetEntityNumber(), (Object[])successIds.toArray(new Long[0]), (OperateOption)operateOption);
                        successIds = ScpSalOutAuditAutoModuleConsumeService.buildSuccessIdAndErrorMsg(errorMsg, unSubmitIds, operationResult, "removeAll");
                    }
                }
            }
            catch (Throwable throwable) {
                log.error(throwable);
                returnMap.put("succed", Boolean.FALSE);
                returnMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
            }
            finally {
                if (CollectionUtils.isNotEmpty(unSubmitIds)) {
                    operationResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)pushArgs.getTargetEntityNumber(), (Object[])unSubmitIds.toArray(new Long[0]), (OperateOption)operateOption);
                    needDeleteIds.addAll(operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet()));
                }
                if (CollectionUtils.isNotEmpty(needDeleteIds)) {
                    OperationServiceHelper.executeOperate((String)"delete", (String)pushArgs.getTargetEntityNumber(), (Object[])needDeleteIds.toArray(new Long[0]), (OperateOption)operateOption);
                }
            }
            returnMap.put("data", successIds);
            returnMap.put("targetData", targetData);
            returnMap.put("message", "ok");
            returnMap.put("succed", Boolean.TRUE);
        } else {
            returnMap.put("succed", Boolean.FALSE);
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\u3002", (String)"ScpSalOutAuditAutoModuleConsumeService_2", (String)"scm-scp-mservice", (Object[])new Object[0])).append("\t\n");
            message.append(result.getMessage());
            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
            returnMap.put("message", message.toString());
            log.info("@@@\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u7ec4\u4ef6\u6d88\u8017\u5f02\u5e38\uff1a" + result.getMessage());
        }
        return returnMap;
    }

    private static Set<Long> buildSuccessIdAndErrorMsg(StringBuilder errorMsg, Set<Long> needDeleteIds, OperationResult operationResult, String coloperator) {
        HashSet<Long> successIds = new HashSet(8);
        if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
            successIds = operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
            if ("addAll".equals(coloperator)) {
                needDeleteIds.addAll(successIds);
            } else {
                needDeleteIds.removeAll(successIds);
            }
            if (!operationResult.getAllErrorOrValidateInfo().isEmpty()) {
                String errMsg = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator()));
                errorMsg.append(';').append(errMsg);
            }
        } else {
            errorMsg.append(';').append(operationResult.getMessage()).append(System.lineSeparator());
            operationResult.getAllErrorOrValidateInfo().forEach(row -> errorMsg.append(row.getMessage()).append(System.lineSeparator()));
        }
        return successIds;
    }
}

