/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.staging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.business.ScpVMIPanelServiceHelper;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;

public final class ScpStagingListService {
    private Log logger = LogFactory.getLog(ScpStagingListService.class);

    public Map<String, Set<Long>> getVMITodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        QFilter invqFilter = ScpVMIPanelServiceHelper.getInitCommonQfilter();
        RequestContext rc = RequestContext.get();
        Set bizPartnerIds = BizPartnerUtil.getBizPartnerIds();
        HasPermOrgResult permission = PermissionServiceHelper.getAllPermOrgs((long)rc.getCurrUserId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (boolean)false, null, (String)"scp_vmipanel", (String)"47150e89000000ac");
        QFilter commonFilter = new QFilter("supplier.bizpartner", "in", (Object)bizPartnerIds);
        commonFilter.and(new QFilter("createorg", "in", (Object)permission.getHasPermOrgs()));
        commonFilter.and(new QFilter("status", "=", (Object)"C"));
        commonFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection pur_conmatreials = QueryServiceHelper.query((String)"pur_conmatreial", (String)"entryentity.material,entryentity.entryusestatus", (QFilter[])commonFilter.toArray());
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        if (pur_conmatreials.size() > 0) {
            for (DynamicObject row : pur_conmatreials) {
                if (!"1".equals(row.getString("entryentity.entryusestatus"))) continue;
                materialIdSet.add(row.getLong("entryentity.material"));
            }
        }
        DynamicObjectCollection pur_iminventorys = ScpVMIPanelServiceHelper.newinitImInventory((QFilter)invqFilter, (Boolean)false, materialIdSet, (List)permission.getHasPermOrgs(), (QFilter)commonFilter);
        ScpVMIPanelServiceHelper.doDealMinMaxQty((DynamicObjectCollection)pur_iminventorys, (boolean)false);
        ScpVMIPanelServiceHelper.doDealQtyFiled((DynamicObjectCollection)pur_iminventorys);
        ScpVMIPanelServiceHelper.doDealReqQty((DynamicObjectCollection)pur_iminventorys, null, null);
        ScpVMIPanelServiceHelper.doDealOrderQty((DynamicObjectCollection)pur_iminventorys, null, null);
        ScpVMIPanelServiceHelper.doDealInQty((DynamicObjectCollection)pur_iminventorys, null, null);
        ScpVMIPanelServiceHelper.doDealStatus((DynamicObjectCollection)pur_iminventorys);
        HashSet<Long> idSet = new HashSet<Long>(8);
        for (DynamicObject row : pur_iminventorys) {
            if (!"A".equals(row.getString("status"))) continue;
            idSet.add(row.getLong("id"));
        }
        map.put("ids", idSet);
        return map;
    }

    public Map<String, Set<Long>> getOrderTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getOrderFilter();
        QFilter beforeDateQfiter = this.getBeforeDateQfiter();
        qFilters.add(beforeDateQfiter);
        ArrayList<QFilter> unConfirmQFilters = new ArrayList<QFilter>(8);
        unConfirmQFilters.addAll(qFilters);
        unConfirmQFilters.add(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
        QFilter[] unConfirmQFilterArray = unConfirmQFilters.toArray(new QFilter[0]);
        this.logger.info("ScpStagingListService.queryUnConfirmOrderQfilter={}", (Object)SerializationUtils.toJsonString((Object)unConfirmQFilterArray));
        HashSet unConfirmOrderList = new HashSet(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ScpStagingListService.queryUnConfirmOrder", (String)"scp_order", (String)"id", (QFilter[])unConfirmQFilterArray, null);){
            ds.forEach(row -> unConfirmOrderList.add(row.getLong("id")));
        }
        map.put("unConfirm", unConfirmOrderList);
        ArrayList<QFilter> unSendQFilters = new ArrayList<QFilter>(8);
        unSendQFilters.addAll(qFilters);
        ArrayList<String> logStatus = new ArrayList<String>(8);
        logStatus.add("A");
        logStatus.add("B");
        unSendQFilters.add(new QFilter("logstatus", "in", logStatus));
        QFilter[] unSendQFilterArray = unSendQFilters.toArray(new QFilter[0]);
        this.logger.info("ScpStagingListService.queryUnSendOrder={}", (Object)SerializationUtils.toJsonString((Object)unSendQFilterArray));
        HashSet unSendOrderList = new HashSet(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ScpStagingListService.queryUnSendOrder", (String)"scp_order", (String)"id", (QFilter[])unSendQFilterArray, null);){
            ds.forEach(row -> unSendOrderList.add(row.getLong("id")));
        }
        map.put("unSend", unSendOrderList);
        return map;
    }

    public Map<String, Set<Long>> getCheckTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getCheckFilter();
        QFilter beforeDateQfiter = this.getBeforeDateQfiter();
        qFilters.add(beforeDateQfiter);
        ArrayList<QFilter> unConfirmQFilters = new ArrayList<QFilter>(8);
        unConfirmQFilters.addAll(qFilters);
        unConfirmQFilters.add(new QFilter("origin", "=", (Object)"2"));
        unConfirmQFilters.add(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
        QFilter[] unConfirmQFilterArray = unConfirmQFilters.toArray(new QFilter[0]);
        HashSet unConfirmCheckList = new HashSet(8);
        this.logger.info("ScpStagingListService.queryUnConfirmOrder={}", (Object)SerializationUtils.toJsonString((Object)unConfirmQFilterArray));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ScpStagingListService.queryUnConfirmOrder", (String)"scp_check", (String)"id", (QFilter[])unConfirmQFilterArray, null);){
            ds.forEach(row -> unConfirmCheckList.add(row.getLong("id")));
        }
        map.put("unConfirm", unConfirmCheckList);
        ArrayList<QFilter> unInvioceQFilters = new ArrayList<QFilter>(8);
        unInvioceQFilters.addAll(qFilters);
        unInvioceQFilters.add(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal()));
        unInvioceQFilters.add(new QFilter("invstatus", "=", (Object)"A"));
        QFilter[] unInvioceQFilterArray = unInvioceQFilters.toArray(new QFilter[0]);
        this.logger.info("ScpStagingListService.unInvioceQFilterArray={}", (Object)SerializationUtils.toJsonString((Object)unInvioceQFilterArray));
        HashSet unInvioceList = new HashSet(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ScpStagingListService.queryUnInvioceOrder", (String)"scp_check", (String)"id", (QFilter[])unInvioceQFilterArray, null);){
            ds.forEach(row -> unInvioceList.add(row.getLong("id")));
        }
        map.put("unInvioce", unInvioceList);
        return map;
    }

    public List<QFilter> getOrderFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        QFilter qFilter = this.commonFilter();
        qFilter.and(this.getPermissionFilter("scp_order", "02"));
        qFilters.add(qFilter);
        List orderFilter = ScpBillOfBizPersonFilter.orderFilter();
        qFilters.addAll(orderFilter);
        return qFilters;
    }

    private QFilter getPermissionFilter(String metaDataCode, String orgVievType) {
        HasPermOrgResult permOrgsResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgVievType, null, (String)metaDataCode, (String)"47150e89000000ac");
        List orgIdList = permOrgsResult.getHasPermOrgs();
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)orgIdList)) {
            qFilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdList));
        }
        return qFilter;
    }

    public List<QFilter> getCheckFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        List setCheckListFilter = ScpCoreListFilterHelper.setCheckListFilter(qFilters);
        QFilter qFilter = this.commonFilter();
        qFilter.and(this.getPermissionFilter("scp_check", "10"));
        qFilters.add(qFilter);
        qFilters.addAll(setCheckListFilter);
        return qFilters;
    }

    private QFilter getBeforeDateQfiter() {
        String date2str = DateUtil.date2strByLocalDateTime((Date)new Date(), (String)"yyyy-MM-dd");
        Date str2dateByLocalDateTime = DateUtil.string2date((String)date2str, (String)"yyyy-MM-dd");
        Date beginDate = DateUtil.getPreviousMonthDate((Date)str2dateByLocalDateTime, (int)3);
        QFilter qFilter = new QFilter("billdate", ">=", (Object)beginDate);
        return qFilter;
    }

    private QFilter commonFilter() {
        QFilter qFilter = BizPartnerUtil.assembleQFilterBizPartner();
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        return qFilter;
    }
}

