/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.business.ScpScDataHandleHelper;

public class ScpAcceptApplyAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScpAcceptApplyAuditOp.class);
    private static final String ENTRYENTITY = "materialentry";
    private static final String QTY = "qty";
    private static final String BASICQTY = "basicqty";
    private static final String POBILLID = "pobillid";
    private static final String POENTRYID = "poentryid";
    private static final String PERSON = "person";
    private final Boolean scconsistencyservice = ParamConfigUtil.getCacheBooleanParamConfig((String)"scconsistencyservice");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("materialentry.qty");
        filds.add("materialentry.basicqty");
        filds.add("materialentry.pobillid");
        filds.add("materialentry.poentryid");
        filds.add("materialentry.sumreceiptqty");
        filds.add("materialentry.suminstockqty");
        filds.add("materialentry.material");
        filds.add("materialentry.pobillno");
        filds.add("materialentry.unit");
        filds.add("materialentry.basicunit");
        filds.add("materialentry.warehouse");
        filds.add("materialentry.trace");
        filds.add("materialentry.suplot");
        filds.add("materialentry.sumcheckqty");
        filds.add("materialentry.linetype");
        filds.add(PERSON);
        filds.add("supplier");
        filds.add("billno");
        filds.add("cfmstatus");
        filds.add("logstatus");
        filds.add("rowlogstatus");
        filds.add("qcodeurl");
        filds.add("suplot");
        filds.add("lot");
        filds.add("org");
        filds.add("businesstype");
        filds.add(QTY);
        filds.add(BASICQTY);
        filds.add("tarbilltype");
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        if (!autoExtEntryPro.isEmpty()) {
            filds.addAll(autoExtEntryPro.keySet());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject bill : e.getDataEntities()) {
            bill.set("logstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject row : dynamicObjectCollection) {
                row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Map poEntryId_QtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])e.getDataEntities());
        HashSet poEntryPks = new HashSet(poEntryId_QtyMap.keySet());
        String seltcor = "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.pobillid, materialentry.poentryid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.sumrefundqty,materialentry.entrystatus,materialentry.rowlogstatus,materialentry.linetype,materialentry.taxamount,materialentry.sumapaccepttaxamount,materialentry.sumaccepttaxamount,materialentry.relateapaccepttaxamount";
        DynamicObject[] orders = OrderUtil.getOrdersByPoEntryIdS((String)seltcor, poEntryPks);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])orders, new ArrayList(poEntryPks));
        DynamicObject[] objs = e.getDataEntities();
        ScpScDataHandleHelper.execSalOutStockAudit((DynamicObject[])objs, (Boolean)this.scconsistencyservice);
        this.sendMsg(objs);
    }

    private void sendMsg(DynamicObject[] objs) {
        String domainContextUrl = UrlService.getDomainContextUrl();
        log.info(domainContextUrl);
        StringBuilder url = new StringBuilder();
        for (DynamicObject bill : objs) {
            url.setLength(0);
            Long id = bill.getLong("id");
            url.append(domainContextUrl);
            if (domainContextUrl.endsWith("/")) {
                url.append("mobile.html?form=pur_batreceive_m");
            } else {
                url.append("/mobile.html?form=pur_batreceive_m");
            }
            url.append('&').append("pkId=").append(id);
            String accountId = RequestContext.get().getAccountId();
            if (accountId != null) {
                url.append('&').append("accountId=").append(accountId);
            }
            bill.set("qcodeurl", (Object)url);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtoperson", (String)"scp_accept_apply", (DynamicObject[])objs, (OperateOption)option);
    }
}

