/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.OrderUtil;
import kd.scm.scp.business.ScpSalOutStockOffsetJointHelper;

public class ScpBillConfirmPlugin
extends AbstractOperationServicePlugIn {
    private static final String QTY = "qty";
    private static final String BASICQTY = "basicqty";
    private static final String POBILLID = "pobillid";
    private static final String POENTRYID = "poentryid";
    private static final String POBILLNO = "pobillno";
    private static final String PROMISEDAY = "promiseday";
    private static Log log = LogFactory.getLog(ScpBillConfirmPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("logstatus");
        filds.add("rowlogstatus");
        filds.add(QTY);
        filds.add(BASICQTY);
        filds.add(POBILLID);
        filds.add(POENTRYID);
        filds.add(POBILLNO);
        filds.add(PROMISEDAY);
        filds.add("billno");
        filds.add("supplier");
        filds.add("person");
        filds.add("srctype");
        filds.add("srcbillid");
        filds.add("srcentryid");
        filds.add("sumreceiptqty");
        filds.add("suminstockqty");
        filds.add("sumrecretqty");
        filds.add("suminstockretqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        log.info("@@@ScpBillConfirmPlugin");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject bill : objs = e.getDataEntities()) {
            if (bill.getString("logstatus") != null && !"".equals(bill.getString("logstatus").trim()) && !"null".equals(bill.getString("logstatus").trim())) continue;
            bill.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : dynamicObjectCollection) {
                row.set("rowlogstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ScpSalOutStockOffsetJointHelper.executeOrderConfirm((DynamicObject[])objs);
        OrderUtil.updateMalOrderByOrder((DynamicObject[])objs);
    }
}

