/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.text.MessageFormat;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.invcloud.enums.InvoiceTypeEnum;
import org.apache.commons.lang.StringUtils;

public final class ScpInvoiceInvCodeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set filds = super.preparePropertys();
        filds.add("billno");
        filds.add("entryentity");
        filds.add("entryentity.invserialnum");
        filds.add("entryentity.invsource");
        filds.add("entryentity.invcode");
        filds.add("entryentity.invoicetype");
        return filds;
    }

    public void validate() {
        ExtendedDataEntity[] rowDataEntity;
        for (ExtendedDataEntity dataEntity : rowDataEntity = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            String billno = data.getString("billno");
            DynamicObjectCollection rows = data.getDynamicObjectCollection("entryentity");
            int i = 1;
            for (DynamicObject entry : rows) {
                String invcode = entry.getString("invcode");
                DynamicObject invoiceTypeDy = entry.getDynamicObject("invoicetype");
                if (!this.isOverseasOrDigitalInvoices(invoiceTypeDy) && StringUtils.isBlank((String)invcode)) {
                    this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u7968\u5355{0}\u7b2c{1}\u884c\uff0c\u8bf7\u586b\u5199\u53d1\u7968\u4ee3\u7801\u3002", (String)"ScpInvoiceInvCodeValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0]), billno, i));
                }
                ++i;
            }
        }
    }

    private boolean isOverseasOrDigitalInvoices(DynamicObject invoiceTypeDy) {
        if (invoiceTypeDy == null) {
            return false;
        }
        String invoiceType = invoiceTypeDy.getString("number");
        return InvoiceTypeEnum.INVOICETYPE30.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE29.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE28.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE26.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE27.getVal().equals(invoiceType);
    }
}

