/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ScpProblemNoticeComfirmFeedbackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("supplier");
        filds.add("srctype");
        filds.add("materialentry.feedbackdesc");
        filds.add("materialentry.feedattachment");
        filds.add("materialentry.feedbackstatus");
        filds.add("materialentry.feedbacker");
        filds.add("materialentry.facebacktime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("materialentry");
                    Boolean isEffectiveFeedback = false;
                    for (DynamicObject row : entryCol) {
                        String feedbackstatus = row.getString("feedbackstatus");
                        String feedbackdesc = row.getString("feedbackdesc");
                        if (!StringUtils.isNotBlank((CharSequence)feedbackdesc) || !"A".equals(feedbackstatus)) continue;
                        isEffectiveFeedback = true;
                    }
                    if (isEffectiveFeedback.booleanValue()) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u672c\u6b21\u53cd\u9988\u8bf4\u660e\u3002", (String)"ScpProblemNoticeComfirmFeedbackOp_1", (String)"scm-scp-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection materialentry = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentry) {
                String feedbackdesc = entry.getString("feedbackdesc");
                if (!StringUtils.isNotBlank((CharSequence)feedbackdesc)) continue;
                entry.set("feedbackstatus", (Object)"B");
                entry.set("feedbacker", (Object)RequestContext.get().getCurrUserId());
                entry.set("facebacktime", (Object)TimeServiceHelper.now());
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

