/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.MessageUtil;
import kd.scm.common.util.PurBizPersonUtil;

public class ScpRequestRejectPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScpRequestRejectPlugin.class);
    private static final String POBILLNO = "pobillno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add(POBILLNO);
        filds.add("logstatus");
        filds.add("pobillid");
        filds.add("billno");
        filds.add("supplier");
        filds.add("person");
        filds.add("poentryid");
        filds.add("srcbilltype");
        filds.add("srcbillid");
        filds.add("materialentry");
        filds.add("qty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (ExtendedDataEntity extendedDataEntity : e.getValidExtDataEntities()) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            dynamicObjectCollection.add((Object)obj);
        }
        if ("reject".equalsIgnoreCase(key)) {
            String billType;
            switch (billType = this.billEntityType.getName()) {
                case "scp_request": {
                    AfterSaleUtil.writeBackMalOrderAndPurOrder((DynamicObjectCollection)dynamicObjectCollection);
                    if (!ApiConfigUtil.hasCQScmConfig()) break;
                    this.updatePmPurRefundApplyBillConfirmStatus(dynamicObjectCollection);
                    break;
                }
            }
        }
    }

    private void updatePmPurRefundApplyBillConfirmStatus(DynamicObjectCollection dynamicObjectCollection) {
        HashSet<Long> pmPurRefundApplyBillIdSet = new HashSet<Long>();
        for (DynamicObject dyn : dynamicObjectCollection) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryDyn : entryentity) {
                if (!"pm_purrefundapplybill".equals(entryDyn.get("srcbilltype"))) continue;
                pmPurRefundApplyBillIdSet.add(entryDyn.getLong("srcbillid"));
            }
        }
        if (pmPurRefundApplyBillIdSet.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", new ArrayList(pmPurRefundApplyBillIdSet));
            params.put("status", "C");
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upRefundConfirmStatus", (Object[])new Object[]{params});
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            DynamicObject bizPerson;
            DynamicObject person = bill.getDynamicObject("person");
            if (null == person || null == (bizPerson = PurBizPersonUtil.getPerson((Object)person.getPkValue())) || null == bizPerson.get("userId")) continue;
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTitle(ResManager.loadKDString((String)"\u8ba2\u5355\u88ab\u6253\u56de\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ScpBillRejectPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
            StringBuilder yzjMessage = new StringBuilder();
            yzjMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u534f\u540c\u8ba2\u5355\u201c{0}\u201d\u88ab\u4f9b\u5e94\u5546\u201c{1}\u201d\u6253\u56de\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ScpBillRejectPlugin_1", (String)"scm-scp-opplugin", (Object[])new Object[0]), bill.getString("billno"), MessageUtil.getDisplayName((DynamicObject)bill, (String)"supplier")));
            messageInfo.setContent(yzjMessage.toString());
            messageInfo.setPubaccNumber("systempubacc");
            messageInfo.setMessageType("message");
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(bizPerson.getLong("userId"));
            messageInfo.setUserIds(userIds);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }
}

