/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockOffsetJointHelper;

public class ScpSalOutAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ScpSalOutAuditOp.class);
    private static final String ENTRYENTITY = "materialentry";
    private static final String QTY = "qty";
    private static final String BASICQTY = "basicqty";
    private static final String POBILLID = "pobillid";
    private static final String POENTRYID = "poentryid";
    private static final String PERSON = "person";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("materialentry.qty");
        filds.add("materialentry.basicqty");
        filds.add("materialentry.pobillid");
        filds.add("materialentry.poentryid");
        filds.add("materialentry.sumreceiptqty");
        filds.add("materialentry.suminstockqty");
        filds.add("materialentry.material");
        filds.add("materialentry.pobillno");
        filds.add("materialentry.unit");
        filds.add("materialentry.basicunit");
        filds.add("materialentry.warehouse");
        filds.add("materialentry.trace");
        filds.add("materialentry.suplot");
        filds.add("materialentry.sumcheckqty");
        filds.add("materialentry.linetype");
        filds.add("materialentry.entrystatus");
        filds.add(PERSON);
        filds.add("supplier");
        filds.add("billno");
        filds.add("cfmstatus");
        filds.add("logstatus");
        filds.add("rowlogstatus");
        filds.add("qcodeurl");
        filds.add("suplot");
        filds.add("proddate");
        filds.add("duedate");
        filds.add("lot");
        filds.add("org");
        filds.add("businesstype");
        filds.add("dsentryid");
        filds.add(QTY);
        filds.add(BASICQTY);
        filds.add("tarbilltype");
        filds.add("materialentry.subentryentity.subsrcbillid");
        filds.add("materialentry.subentryentity.subsrcbillentryid");
        filds.add("materialentry.subentryentity.curconsumesubqty");
        filds.add("materialentry.subentryentity.curconsumesubbaseqty");
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        if (!autoExtEntryPro.isEmpty()) {
            filds.addAll(autoExtEntryPro.keySet());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject bill : e.getDataEntities()) {
            bill.set("logstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject row : dynamicObjectCollection) {
                row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Map poEntryBasicQtyMap = ScpSalOutStockBillHelper.getPoEntryIdBasicQtyMap((DynamicObject[])e.getDataEntities(), (BillStatusEnum)BillStatusEnum.AUDIT);
        ScpOrderBillHelper.updateSrcOrderData((Map)poEntryBasicQtyMap, (BillStatusEnum)BillStatusEnum.AUDIT);
        String consumeMoment = ScpSalOutStockBillHelper.getConsumeMoment();
        if ("saloutstock".equals(consumeMoment)) {
            ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(8);
            for (DynamicObject bill : e.getDataEntities()) {
                DynamicObject businesstype = bill.getDynamicObject("businesstype");
                if (!BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) continue;
                dys.add(bill);
            }
            if (!CollectionUtils.isEmpty(dys)) {
                HashMap customParam = new HashMap(1);
                ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualcreatemoduleconsume", dys, customParam);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ScpSalOutStockOffsetJointHelper.executeSalOutAudit((DynamicObject[])objs);
        ScpSalOutStockOffsetJointHelper.executeAuditAutoCreateBill((DynamicObject[])objs);
        DynamicObject obj = objs[0];
        String tarbilltype = obj.getString("tarbilltype");
        String domainContextUrl = UrlService.getDomainContextUrl();
        log.info(domainContextUrl);
        if (!"2".equals(tarbilltype)) {
            StringBuilder url = new StringBuilder();
            for (DynamicObject bill : objs) {
                url.setLength(0);
                Long id = bill.getLong("id");
                url.append(domainContextUrl);
                if (domainContextUrl.endsWith("/")) {
                    url.append("mobile.html?form=pur_batreceive_m");
                } else {
                    url.append("/mobile.html?form=pur_batreceive_m");
                }
                url.append('&').append("pkId=").append(id);
                String accountId = RequestContext.get().getAccountId();
                if (accountId != null) {
                    url.append('&').append("accountId=").append(accountId);
                }
                bill.set("qcodeurl", (Object)url);
            }
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtoperson", (String)"scp_saloutstock", (DynamicObject[])objs, (OperateOption)option);
    }
}

