/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class ScpSalOutStockInitImport
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(ScpSalOutStockInitImport.class);

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        boolean flag = true;
        data.put("isinitial", "true");
        data.put("origin", "1");
        data.put("billstatus", "C");
        Object supplier = data.get("supplier");
        String userId = RequestContext.get().getUserId();
        logger.info(userId);
        Map<String, Object> bizPar = null;
        if (supplier instanceof JSONObject) {
            bizPar = this.checkSupplier((JSONObject)supplier);
        }
        if (bizPar != null && !bizPar.isEmpty()) {
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(Long.valueOf(bizPar.get("id").toString()));
            List userIds = BizPartnerUtil.getSupUserIdsByBizPartner(idSet);
            logger.info(userIds.toString());
            if (!userIds.isEmpty() && userIds.contains(Long.valueOf(userId))) {
                data.put("bizpartner", bizPar);
                data.put("materialentry", this.checkMaterialEntry((JSONArray)data.get("materialentry")));
            } else {
                flag = false;
                ImportLogger.ImportLog importLog = new ImportLogger.ImportLog("supplier", ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u60a8\u81ea\u5df1\u516c\u53f8\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u9500\u552e\u516c\u53f8\u540d\u79f0\u662f\u5426\u6b63\u786e\u3002", (String)"PbdSupplierUserImport_0", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                importlogs.add(importLog);
            }
        } else {
            flag = false;
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog("supplier", ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u60a8\u81ea\u5df1\u516c\u53f8\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u9500\u552e\u516c\u53f8\u540d\u79f0\u662f\u5426\u6b63\u786e\u3002", (String)"PbdSupplierUserImport_0", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            importlogs.add(importLog);
        }
        return flag;
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"scp_saloutstock_initial", (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
        if (!submit.isSuccess()) {
            StringBuilder message = new StringBuilder();
            submit.getAllErrorOrValidateInfo().forEach(row -> message.append(row.getMessage()));
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog("supplier", message.toString());
            importlogs.add(importLog);
        }
    }

    private JSONArray checkMaterialEntry(JSONArray materialEntry) {
        if (materialEntry == null) {
            return new JSONArray();
        }
        Set<String> taxRateNumberList = materialEntry.stream().map(jsonObject -> {
            if (!((JSONObject)jsonObject).containsKey((Object)"taxrateid") || ((JSONObject)jsonObject).get((Object)"taxrateid") == null) {
                return null;
            }
            JSONObject taxRateNumber = (JSONObject)((JSONObject)jsonObject).get((Object)"taxrateid");
            return String.valueOf(taxRateNumber.get("number"));
        }).collect(Collectors.toSet());
        Map<String, BigDecimal> taxRateNumberMap = this.taxRateNumberMapBatch(taxRateNumberList);
        int j = materialEntry.size();
        for (int i = 0; i < j; ++i) {
            JSONObject jsonObject2 = (JSONObject)materialEntry.get(i);
            if (!jsonObject2.containsKey("taxrateid") || jsonObject2.get("taxrateid") == null) continue;
            JSONObject taxRateNumber = (JSONObject)jsonObject2.get("taxrateid");
            Object number = taxRateNumber.get("number");
            if (!taxRateNumberMap.containsKey(number) || taxRateNumberMap.get(number) == null) {
                return materialEntry;
            }
            jsonObject2.put("taxrate", taxRateNumberMap.get(number));
            materialEntry.set(i, (Object)jsonObject2);
        }
        return materialEntry;
    }

    private Map<String, BigDecimal> taxRateNumberMapBatch(Set<String> numberSet) {
        try {
            if (numberSet == null) {
                return new HashMap<String, BigDecimal>();
            }
            String selectFields = String.format("%s,%s", "taxrate", "number");
            HashMap<String, BigDecimal> taxRateNumberMap = new HashMap<String, BigDecimal>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bd_taxrate", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", numberSet)}, null);){
                dataSet.forEach(row -> taxRateNumberMap.put(row.getString("number"), row.getBigDecimal("taxrate")));
            }
            return taxRateNumberMap;
        }
        catch (Exception e) {
            logger.info("\u6279\u91cf\u83b7\u53d6\u7a0e\u7387\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e);
            return new HashMap<String, BigDecimal>();
        }
    }

    private Map<String, Object> checkSupplier(JSONObject supplier) {
        QFilter qFilter = null;
        if (supplier.containsKey((Object)"name")) {
            qFilter = new QFilter("name", "=", (Object)supplier.getString("name"));
        }
        if (supplier.containsKey((Object)"number")) {
            qFilter = new QFilter("number", "=", (Object)supplier.getString("number"));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.clear();
        if (qFilter != null) {
            logger.info("\u8fc7\u6ee4\u6761\u4ef6" + qFilter);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bd_supplier", (String)"name,number,bizpartner,bizpartner.name bname,bizpartner.number bnumber", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            int index = 0;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                resultMap.put("id", row.getLong("bizpartner"));
                resultMap.put("name", row.getString("bname"));
                resultMap.put("number", row.getString("bnumber"));
                ++index;
            }
        }
        logger.info("\u5546\u52a1\u4f19\u4f34\u6570\u636e" + resultMap);
        return resultMap;
    }
}

