/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.opplugin.ScpDuedateValidator;
import kd.scm.scp.opplugin.ScpOrderCfmStatusValidator;
import kd.scm.scp.opplugin.validator.ScpSalOutDeliDateValidator;
import kd.scm.scp.opplugin.validator.ShelfLifeDateValidator;

public class ScpSalOutSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("supplier");
        filds.add("billno");
        filds.add("billdate");
        filds.add("delidate");
        filds.add("person");
        filds.add("businesstype");
        filds.add("pobillno");
        filds.add("org");
        filds.add("materialentry.qty");
        filds.add("materialentry.pobillid");
        filds.add("materialentry.pobillno");
        filds.add("materialentry.poentryid");
        filds.add("materialentry.proddate");
        filds.add("materialentry.duedate");
        filds.add("materialentry.material");
        filds.add("materialentryentrystatus");
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        if (!autoExtEntryPro.isEmpty()) {
            filds.addAll(autoExtEntryPro.keySet());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ScpOrderCfmStatusValidator());
        e.addValidator((AbstractValidator)new ShelfLifeDateValidator());
        e.addValidator((AbstractValidator)new ScpDuedateValidator());
        e.addValidator((AbstractValidator)new ScpSalOutDeliDateValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List dataEntitys = e.getValidExtDataEntities();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject data = dataEntity.getDataEntity();
            String billNo = data.getString("billno");
            if (billNo == null) {
                data.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)data.getDynamicObjectType().getName(), (DynamicObject)data, (String)data.getString("org")));
            }
            data.set("modifier", (Object)RequestContext.get().getCurrUserId());
            data.set("modifytime", (Object)TimeServiceHelper.now());
        }
    }
}

