/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public final class ScpScheduleDeliveryConfirmOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ScpScheduleDeliveryConfirmOp.class);

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        this.getOption().setVariableValue("currbizappid", "scp");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("qty");
        fieldKeys.add("basicqty");
        fieldKeys.add("deliverydate");
        fieldKeys.add("promiseqty");
        fieldKeys.add("promisebasicqty");
        fieldKeys.add("promisedate");
        fieldKeys.add("promisestatus");
        fieldKeys.add("ismeets");
        fieldKeys.add("srcbillid");
        fieldKeys.add("srcentryid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String isOnlyValidator = this.getOption().getVariableValue("isOnlyValidator", "false");
        if ("false".equalsIgnoreCase(isOnlyValidator)) {
            HashSet<Object> needSendMsgIds = new HashSet<Object>(56);
            for (ExtendedDataEntity extendedDataEntity : e.getValidExtDataEntities()) {
                DynamicObject row = extendedDataEntity.getDataEntity();
                Date deliverydate = row.getDate("deliverydate");
                LocalDate deliveryLocalDate = deliverydate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                Date promisedate = row.getDate("promisedate");
                LocalDate promiseLocalDate = promisedate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                BigDecimal promiseqty = row.getBigDecimal("promiseqty");
                BigDecimal qty = row.getBigDecimal("qty");
                if (deliveryLocalDate.compareTo(promiseLocalDate) == 0 && qty.compareTo(promiseqty) == 0) {
                    row.set("ismeets", (Object)Boolean.TRUE);
                    continue;
                }
                row.set("ismeets", (Object)Boolean.FALSE);
                needSendMsgIds.add(extendedDataEntity.getBillPkId());
            }
            this.getOption().setVariableValue("needSendMsgIds", SerializationUtils.toJsonString(needSendMsgIds));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String isOnlyValidator = this.getOption().getVariableValue("isOnlyValidator", "false");
        if ("true".equalsIgnoreCase(isOnlyValidator)) {
            e.setCancelOperation(true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String isOnlyValidator = this.getOption().getVariableValue("isOnlyValidator", "false");
        if ("false".equalsIgnoreCase(isOnlyValidator)) {
            HashSet<Long> billIds = new HashSet<Long>(56);
            for (DynamicObject bill : e.getDataEntities()) {
                for (DynamicObject row : bill.getDynamicObjectCollection("materialentry")) {
                    String srcbillid = row.getString("srcbillid");
                    if (srcbillid == null || srcbillid.isEmpty()) continue;
                    billIds.add(Long.parseLong(srcbillid));
                }
            }
            if (!billIds.isEmpty()) {
                try {
                    OperationResult agreeorder = OperationServiceHelper.executeOperate((String)"agreeorder", (String)"scp_order", (Object[])billIds.toArray(), (OperateOption)OperateOption.create());
                    if (!agreeorder.isSuccess() && agreeorder.getSuccessPkIds().size() <= 0 && log.isInfoEnabled()) {
                        String errorTitle = agreeorder.getMessage() + "\r\n" + ExceptionUtil.getErrorInfoDetails((List)agreeorder.getAllErrorOrValidateInfo());
                        log.info(errorTitle);
                    }
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                    this.getOperationResult().setMessage(exception.getMessage() != null ? exception.getMessage() : "exception");
                    this.getOperationResult().setShowMessage(false);
                }
            }
        }
        String needSendMsgIdsStr = this.getOption().getVariableValue("needSendMsgIds");
        HashSet needSendMsgIds = new HashSet(8);
        if (!StringUtils.isEmpty((Object)needSendMsgIdsStr)) {
            List list = SerializationUtils.fromJsonStringToList((String)needSendMsgIdsStr, Object.class);
            needSendMsgIds.addAll(list);
        }
        if (!needSendMsgIds.isEmpty()) {
            try {
                OperationServiceHelper.executeOperate((String)"confirmsendmsg", (String)this.billEntityType.getName(), (DynamicObject[])BusinessDataServiceHelper.load((Object[])needSendMsgIds.toArray(), (DynamicObjectType)this.billEntityType), (OperateOption)OperateOption.create());
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String isOnlyValidator = this.getOption().getVariableValue("isOnlyValidator", "false");
        if ("false".equals(isOnlyValidator)) {
            String string = this.getOption().getVariableValue("bos_listselectedrowcollection", "");
        }
    }
}

