/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ScpXOrderRepulseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("cfm");
        fieldKeys.add("cfmdate");
        fieldKeys.add("rejecter");
        fieldKeys.add("rejectdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        for (DynamicObject xOrder : bills) {
            xOrder.set("cfm", (Object)RequestContext.get().getCurrUserId());
            xOrder.set("cfmdate", (Object)new Date(System.currentTimeMillis()));
            xOrder.set("rejecter", (Object)RequestContext.get().getCurrUserId());
            xOrder.set("rejectdate", (Object)new Date(System.currentTimeMillis()));
        }
        SaveServiceHelper.update((DynamicObject[])bills);
        Object[] purIds = Arrays.stream(bills).map(bill -> bill.getLong("sourcebillid")).toArray();
        DynamicObjectType purOrderType = BusinessDataServiceHelper.newDynamicObject((String)"pur_order").getDynamicObjectType();
        DynamicObject[] purOrders = BusinessDataServiceHelper.load((Object[])purIds, (DynamicObjectType)purOrderType);
        ScpXOrderRepulseOp.updatePurOrder(purOrders);
    }

    private static void updatePurOrder(DynamicObject[] purOrders) {
        for (DynamicObject purOrder : purOrders) {
            String logStatus = purOrder.getString("logstatus");
            Object cfmDate = purOrder.get("cfmdate");
            Object rejectDate = purOrder.get("rejectdate");
            if (cfmDate == null) {
                if (rejectDate != null) {
                    purOrder.set("cfmstatus", (Object)"C");
                } else if ("D".equals(logStatus) || "E".equals(logStatus) || "F".equals(logStatus) || "G".equals(logStatus)) {
                    purOrder.set("cfmstatus", (Object)"E");
                } else {
                    purOrder.set("cfmstatus", (Object)"A");
                }
            } else {
                purOrder.set("cfmstatus", (Object)"B");
            }
            purOrder.set("changestatus", (Object)"A");
        }
        SaveServiceHelper.update((DynamicObject[])purOrders);
    }
}

