/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.botp;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;

public class ScpOrderToAcceptApplyPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(ScpOrderToAcceptApplyPlugin.class);
    private ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5168\u90e8\u7533\u8bf7\u9a8c\u6536\u3002", (String)"ScpOrderToAcceptApplyPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression(" ( materialentry.ispresent=true or ( materialentry.iscontrolamountup=true and materialentry.amountup > ( materialentry.relateapaccepttaxamount ) ) or ( materialentry.iscontrolamountup=false and materialentry.taxamount > ( materialentry.relateapaccepttaxamount) ) ) ");
        QFilter qFilter = QFilter.of((String)"materialentry.iscontrolamountup=true and materialentry.amountup > ( materialentry.relateapaccepttaxamount)", (Object[])new Object[0]).or(QFilter.of((String)"materialentry.iscontrolamountup=false and materialentry.taxamount > ( materialentry.relateapaccepttaxamount)", (Object[])new Object[0])).or(QFilter.of((String)"materialentry.ispresent=true", (Object[])new Object[0]));
        e.getCustQFilters().add(qFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("scp_accept_apply");
        this.setDefualtTaxAmount(entitys);
        String splitStrategy = (String)paramMap.get("splitstrategy");
        Object currentContacter = this.setCurrentContacter();
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            this.setDefaultValue(bill, currentContacter);
            Long settleOrg = bill.getLong("settleorg_id");
            Date unionpromisedate = null;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            DynamicObjectType rowDynamicObjectType = rows.getDynamicObjectType();
            DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
            long seq = 1L;
            for (DynamicObject row : rows) {
                if (null != settleOrg) {
                    row.set("entrysettleorg", (Object)settleOrg);
                }
                String srcentryid = row.getString("srcentryid");
                if ("splitrow".equalsIgnoreCase(splitStrategy)) {
                    String entryParamStr = (String)paramMap.get(srcentryid);
                    List entryParamList = (List)SerializationUtils.fromJsonString((String)entryParamStr, List.class);
                    for (Map rowData : entryParamList) {
                        DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)row, (boolean)false, (boolean)true);
                        splitEntry.setParent(row.getParent());
                        this.setRowPro(rowData, rowDynamicObjectType, splitEntry);
                        unionpromisedate = splitEntry.getDate("promisedate");
                        splitEntry.set("seq", (Object)seq);
                        splitBillEntrys.add((Object)splitEntry);
                        ++seq;
                    }
                    continue;
                }
                if (!"splitbill".equalsIgnoreCase(splitStrategy)) continue;
                this.setRowPro(paramMap, rowDynamicObjectType, row);
                unionpromisedate = row.getDate("promisedate");
            }
            if ("splitrow".equalsIgnoreCase(splitStrategy) && !splitBillEntrys.isEmpty()) {
                bill.set("materialentry", (Object)splitBillEntrys);
            }
            if (unionpromisedate == null) continue;
            bill.set("delidate", unionpromisedate);
        }
    }

    private void setDefualtTaxAmount(ExtendedDataEntity[] entitys) {
        DynamicObject[] poDyns;
        String poentryid;
        HashMap<String, DynamicObject> poentryMap = new HashMap<String, DynamicObject>(16);
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : dynamicObjectCollection) {
                poentryid = entry.getString("poentryid");
                if (!StringUtils.isNotEmpty((String)poentryid)) continue;
                poentryMap.put(poentryid, entry);
            }
        }
        if (poentryMap.isEmpty()) {
            return;
        }
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,materialentry.pobillid,materialentry.poentryid,materialentry.id").append(",materialentry.taxamount,materialentry.sumapaccepttaxamount,materialentry.relateapaccepttaxamount,materialentry.amountup").append(",materialentry.iscontrolamountup");
        for (DynamicObject dynamicObject : poDyns = BusinessDataServiceHelper.load((String)"pur_order", (String)selectSb.toString(), (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryMap.keySet())})) {
            for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("materialentry")) {
                poentryid = entry.getString("poentryid");
                if (!StringUtils.isNotEmpty((String)poentryid) || !poentryMap.containsKey(poentryid)) continue;
                BigDecimal taxamount = entry.getBigDecimal("taxamount");
                BigDecimal sumapaccepttaxamount = entry.getBigDecimal("sumapaccepttaxamount");
                BigDecimal relateapaccepttaxamount = entry.getBigDecimal("relateapaccepttaxamount");
                BigDecimal newAmount = taxamount.subtract(relateapaccepttaxamount);
                BigDecimal acceptAmount = taxamount.subtract(sumapaccepttaxamount);
                if (newAmount.compareTo(taxamount) > 0) {
                    newAmount = taxamount;
                }
                if (newAmount.compareTo(acceptAmount) > 0) {
                    newAmount = acceptAmount;
                }
                if (newAmount.compareTo(BigDecimal.ZERO) < 0) {
                    newAmount = BigDecimal.ZERO;
                }
                ((DynamicObject)poentryMap.get(poentryid)).set("taxamount", (Object)newAmount);
            }
        }
        for (DynamicObject dynamicObject : entitys) {
            DynamicObject dynamicObject2 = dynamicObject.getDataEntity();
            DynamicObjectCollection dynentrys = dynamicObject2.getDynamicObjectCollection("materialentry");
            if (dynentrys == null || dynentrys.isEmpty()) continue;
            for (int i = 0; i < dynentrys.size(); ++i) {
                this.iCalDynamic.proChanged(dynamicObject2, "materialentry", "taxamount", i);
            }
            this.iCalDynamic.calSum(dynamicObject2, "materialentry");
        }
    }

    private void setDefaultValue(DynamicObject dynamicObject, Object currentContacter) {
        if (dynamicObject.get("org") == null) {
            dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        }
        if (dynamicObject.get("contacter") == null) {
            dynamicObject.set("contacter_id", currentContacter);
        }
    }

    private Object setCurrentContacter() {
        QFilter qFilter = new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId()).and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] operators = BusinessDataServiceHelper.load((String)"scp_bizperson", (String)"masterid,name,number", (QFilter[])new QFilter[]{qFilter});
        if (operators != null && operators.length > 0) {
            return operators[0].getPkValue();
        }
        return 0L;
    }

    private void setRowPro(Map<String, String> paramMap, DynamicObjectType dynamicObjectType, DynamicObject row) {
        String deliaddr;
        String warehouse;
        String deliverydate;
        String promisedateString;
        String promiseQty;
        String dsEntryId;
        String dsBillNo;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
        String srcentryid = row.getString("srcentryid");
        DynamicProperty qtyPro = dynamicObjectType.getProperty("qty");
        DynamicProperty basicqtyPro = dynamicObjectType.getProperty("basicqty");
        DynamicProperty entrydelidatePro = dynamicObjectType.getProperty("entrydelidate");
        DynamicProperty promisedatePro = dynamicObjectType.getProperty("promisedate");
        DynamicProperty warehousePro = dynamicObjectType.getProperty("warehouse_id");
        DynamicProperty deliaddrPro = dynamicObjectType.getProperty("deliaddr");
        DynamicProperty dsbillidPro = dynamicObjectType.getProperty("dsbillid");
        DynamicProperty dsentryidPro = dynamicObjectType.getProperty("dsentryid");
        DynamicProperty dsbillnoPro = dynamicObjectType.getProperty("dsbillno");
        String dsBillId = paramMap.get("billid_" + srcentryid);
        if (dsBillId != null && !dsBillId.isEmpty()) {
            dsbillidPro.setValue((Object)row, (Object)dsBillId);
        }
        if ((dsBillNo = paramMap.get("billno_" + srcentryid)) != null && !dsBillNo.isEmpty()) {
            dsbillnoPro.setValue((Object)row, (Object)dsBillNo);
        }
        if ((dsEntryId = paramMap.get("entryid_" + srcentryid)) != null && !dsEntryId.isEmpty()) {
            dsentryidPro.setValue((Object)row, (Object)dsEntryId);
        }
        if ((promiseQty = paramMap.get("qty_" + srcentryid)) != null) {
            qtyPro.setValue((Object)row, (Object)new BigDecimal(promiseQty));
        }
        String promiseBasicQty = paramMap.get("basicqty_" + srcentryid);
        if (promiseQty != null) {
            basicqtyPro.setValue((Object)row, (Object)new BigDecimal(promiseBasicQty));
        }
        if ((promisedateString = paramMap.get("promisedate_" + srcentryid)) != null && !promisedateString.trim().isEmpty()) {
            Date promisedate = DateUtil.string2date((String)promisedateString, (String)"yyyy-MM-dd HH:mm:ss");
            promisedatePro.setValue((Object)row, (Object)promisedate);
        }
        if ((deliverydate = paramMap.get("deliverydate_" + srcentryid)) != null && !deliverydate.trim().isEmpty()) {
            Date deliverydateD = DateUtil.string2date((String)deliverydate, (String)"yyyy-MM-dd HH:mm:ss");
            entrydelidatePro.setValue((Object)row, (Object)deliverydateD);
        }
        if ((warehouse = paramMap.get("warehouse_" + srcentryid)) != null && !warehouse.isEmpty()) {
            warehousePro.setValue((Object)row, (Object)Long.valueOf(warehouse));
        }
        if ((deliaddr = paramMap.get("deliaddr_" + srcentryid)) != null && !deliaddr.isEmpty()) {
            deliaddrPro.setValue((Object)row, (Object)deliaddr);
        }
    }
}

