/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.schedule.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.scp.business.ScpBillTypeHelper;

public class ScpDeliveryScheduleDeliverPromiseQtyValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("materialentry.seq");
        propertys.add("promiseqty");
        propertys.add("promisebasicqty");
        propertys.add("sumoutstockqty");
        propertys.add("sumoutstockbaseqty");
        propertys.add("relateoutstockqty");
        propertys.add("relateoutstockbasicqty");
        return propertys;
    }

    public void validate() {
        String value = this.getOption().getVariableValue("bos_listselectedrowcollection");
        Set selectRowIds = ScpBillTypeHelper.assembleSelectRowIds((String)value);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String errorMessage = ResManager.loadKDString((String)"\u5df2\u53d1\u8d27\u6570\u91cf\u5c0f\u4e8e\u786e\u8ba4\u6570\u91cf\u65f6\u624d\u80fd\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleDeliverPromiseQtyValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject row = extendedDataEntity.getDataEntity();
            Long entryId = row.getLong("id");
            if (!selectRowIds.contains(entryId)) continue;
            BigDecimal promiseqty = row.getBigDecimal("promiseqty");
            BigDecimal sumoutstockqty = row.getBigDecimal("sumoutstockqty");
            if (promiseqty.compareTo(BigDecimal.ZERO) <= 0 || sumoutstockqty.compareTo(promiseqty) <= 0) continue;
            this.addMessage(extendedDataEntity, errorMessage);
        }
    }

    public String getEntityKey() {
        return "materialentry";
    }
}

