/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.schedule.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public final class ScpScheduleDeliverPromiseQtyValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("srcentryid");
        propertys.add("qty");
        propertys.add("promiseqty");
        return propertys;
    }

    public void validate() {
        BigDecimal qty;
        ExtendedDataEntity[] rowDataEntity = this.getDataEntities();
        HashMap<Long, BigDecimal> scheduleQtyMap = new HashMap<Long, BigDecimal>(1024);
        for (ExtendedDataEntity dataEntity : rowDataEntity) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection rows = data.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String srcEntryIdString = row.getString("srcentryid");
                if (srcEntryIdString == null || srcEntryIdString.trim().isEmpty() || "0".equals(srcEntryIdString.trim())) continue;
                Long srcEntryId = Long.parseLong(srcEntryIdString);
                BigDecimal stepQty = (BigDecimal)scheduleQtyMap.get(srcEntryId);
                qty = row.getBigDecimal("qty");
                stepQty = stepQty != null ? stepQty.add(qty) : qty;
                scheduleQtyMap.put(srcEntryId, stepQty);
            }
        }
        if (!scheduleQtyMap.isEmpty()) {
            HashMap<Long, BigDecimal> orderQtyMap = new HashMap<Long, BigDecimal>(1024);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_order", (String)"materialentry.id entryid,( materialentry.qty + materialentry.sumrefundqty ) orderqty,materialentry.scheduleqty scheduleqty", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", scheduleQtyMap.keySet())}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long entryid = row.getLong("entryid");
                    BigDecimal qty2 = (BigDecimal)scheduleQtyMap.get(entryid);
                    BigDecimal orderqty = row.getBigDecimal("orderqty");
                    BigDecimal scheduleqty = row.getBigDecimal("scheduleqty");
                    BigDecimal availableQty = orderqty.subtract(scheduleqty.subtract(qty2));
                    orderQtyMap.put(entryid, availableQty);
                }
            }
            for (ExtendedDataEntity dataEntity : rowDataEntity) {
                DynamicObject data = dataEntity.getDataEntity();
                DynamicObjectCollection rows = data.getDynamicObjectCollection("materialentry");
                int i = 1;
                for (DynamicObject row : rows) {
                    BigDecimal promiseqty = row.getBigDecimal("promiseqty");
                    qty = row.getBigDecimal("qty");
                    String srcEntryIdString = row.getString("srcentryid");
                    Long srcEntryId = Long.parseLong(srcEntryIdString);
                    BigDecimal scheduleqty = (BigDecimal)scheduleQtyMap.get(srcEntryId);
                    BigDecimal ordereqty = (BigDecimal)orderQtyMap.get(srcEntryId);
                    if (promiseqty.compareTo(ordereqty.subtract(scheduleqty.subtract(qty))) > 0) {
                        this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u786e\u8ba4\u6570\u91cf\u6216\u8005\u540c\u4e00\u8ba2\u5355\u884c\u6c47\u603b\u786e\u8ba4\u6570\u91cf\u8d85\u8fc7\u8ba2\u5355\u6700\u5927\u53ef\u4ea4\u8d27\u6570\u91cf\u3002", (String)"ScpScheduleDeliverPromiseQtyValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0]), i));
                    }
                    ++i;
                }
            }
        }
    }
}

