/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ParamUtil;

public class ScpBillUnauditValidator
extends AbstractValidator {
    private final Boolean isAutoReceive = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"isautoreceive");

    public void validate() {
        HashSet<String> autoRecBillnoSet = new HashSet<String>(1024);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            String logstatus = bill.getString("logstatus");
            if ("D".equals(logstatus) || "E".equals(logstatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u6536\u8d27\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"ScpBillUnauditValidator_1", (String)"scm-scp-opplugin", (Object[])new Object[0]));
            }
            if ("F".equals(logstatus) || "G".equals(logstatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5165\u5e93\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"ScpBillUnauditValidator_2", (String)"scm-scp-opplugin", (Object[])new Object[0]));
            }
            if ("H".equals(logstatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u62d2\u6536\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"ScpBillUnauditValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                if (StringUtils.isEmpty((CharSequence)row.getString("autorecbillno"))) continue;
                autoRecBillnoSet.add(row.getString("autorecbillno"));
            }
        }
        if (ApiConfigUtil.hasCQScmConfig() && this.isAutoReceive.booleanValue()) {
            QFilter qFilter = new QFilter("billno", "in", autoRecBillnoSet);
            DynamicObjectCollection receives = QueryServiceHelper.query((String)"im_purreceivebill", (String)"billstatus,billno", (QFilter[])qFilter.toArray());
            HashSet<String> deleteRECBillSet = new HashSet<String>(1024);
            for (DynamicObject recbill : receives) {
                if ("A".equals(recbill.getString("billstatus"))) continue;
                deleteRECBillSet.add(recbill.getString("billno"));
            }
            if (deleteRECBillSet.size() == 0) {
                return;
            }
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                String billno = bill.getString("billno");
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                StringBuilder strBuffer = new StringBuilder();
                HashSet<String> recBillnoSet = new HashSet<String>(1024);
                for (DynamicObject row : rows) {
                    if (!deleteRECBillSet.contains(row.getString("autorecbillno"))) continue;
                    recBillnoSet.add(row.getString("autorecbillno"));
                }
                if (recBillnoSet.size() <= 0) continue;
                for (String recbillno : recBillnoSet) {
                    strBuffer.append(recbillno).append(',');
                }
                if (strBuffer.length() <= 0) continue;
                String msg = strBuffer.toString();
                msg = msg.substring(0, msg.length() - 1);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u8d27\u5355\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u65e0\u6cd5\u64a4\u9500\u53d1\u8d27\u3002\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u5220\u9664\u5bf9\u5e94\u6536\u8d27\u5355\u3002\u53d1\u8d27\u5355\u53f7\u201c{0}\u201d\u5bf9\u5e94\u6536\u8d27\u5355\u201c{1}\u201d\u6536\u8d27\u5355\u53f7\u3002", (String)"ScpBillUnauditValidator_3", (String)"scm-scp-opplugin", (Object[])new Object[]{billno, msg}));
            }
        }
    }
}

