/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CheckUtils;
import kd.scm.scp.business.ScpAvailableStockBasicQtyHelper;

public final class ScpCheckMatchQtyValidator
extends AbstractValidator {
    public void validate() {
        String srcEntryId;
        String operateType = this.getOperateType();
        String operateKey = this.getOperateKey();
        HashSet<String> operateKeys = new HashSet<String>(16);
        operateKeys.add("agreecheck");
        operateKeys.add("confirm");
        operateKeys.add("submit");
        HashSet<String> operateTypes = new HashSet<String>(16);
        operateTypes.add("submit");
        operateTypes.add("statusconvert");
        operateTypes.add("audit");
        if (!operateKeys.contains(operateKey) && !operateTypes.contains(operateType)) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap checkData = new HashMap(1024);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            HashSet<Long> stepSrcEntryIds;
            DynamicObject row = extendedDataEntity.getDataEntity();
            String srcBillType = row.getString("srcbilltype1");
            DynamicObject businesstype = row.getDynamicObject("businesstype_in1");
            if (CheckUtils.isPurInstock((String)srcBillType) && BussinessTypeUtils.checkIsPmOmBussinessType((DynamicObject)businesstype)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            if ((srcEntryId = row.getString("srcentryid1")).isEmpty()) continue;
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap matchAvailableBasicQty = new HashMap(1024);
        matchAvailableBasicQty.putAll(ScpAvailableStockBasicQtyHelper.assembleAvailableMatchQty(checkData));
        BigDecimal availableQty = null;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject row = extendedDataEntity.getDataEntity();
            BigDecimal unMatchQty = row.getBigDecimal("unmatchqty1");
            srcEntryId = row.getString("srcentryid1");
            String seq = row.getString("seq");
            availableQty = matchAvailableBasicQty.getOrDefault(srcEntryId, unMatchQty);
            if (availableQty.compareTo(unMatchQty) == 0) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u53ef\u5f00\u7968\u6570\u91cf\u5df2\u4ece{1}\u53d8\u6210{2}\u3002", (String)"ScpCheckMatchQtyValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[]{seq, unMatchQty.toPlainString(), availableQty.toPlainString()}));
        }
    }

    public String getEntityKey() {
        return "entryentity1";
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add(this.getEntityKey() + ".seq");
        propertys.add("linetype1");
        propertys.add("jointdatachannelid1");
        propertys.add("srcbilltype1");
        propertys.add("srcentryid1");
        propertys.add("unmatchqty1");
        propertys.add("businesstype_in1");
        return propertys;
    }
}

