/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ScpOrderUnConfirmValidator
extends AbstractValidator {
    public void validate() {
        HashSet<String> poEntryPkIds = new HashSet<String>(this.getDataEntities().length);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection materialCol = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialCol) {
                String poEntryId = row.getString("poentryid");
                if (poEntryId.isEmpty()) continue;
                poEntryPkIds.add(poEntryId);
            }
        }
        this.checkDownstream(poEntryPkIds, "1", "scp_saloutstock");
        this.checkDownstream(poEntryPkIds, "2", "scp_accept_apply");
    }

    private void checkDownstream(HashSet<String> poEntryPkIds, String tarbilltype, String billName) {
        QFilter qFilter = new QFilter("materialentry.poentryid", "in", poEntryPkIds);
        qFilter.and("tarbilltype", "=", (Object)tarbilltype);
        HashMap poOfSalOut = new HashMap(poEntryPkIds.size());
        ExtendedDataEntity[] extendedDataEntityArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_saloutstock", (String)"billno,materialentry.srcbillid srcbillid", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billNo = row.getString("billno");
                String srcbillid = row.getString("srcbillid");
                if (!srcbillid.isEmpty() && poOfSalOut.containsKey(srcbillid)) {
                    ((HashSet)poOfSalOut.get(srcbillid)).add(billNo);
                    continue;
                }
                if (srcbillid.isEmpty() || poOfSalOut.containsKey(srcbillid)) continue;
                HashSet<String> salOutNos = new HashSet<String>();
                salOutNos.add(billNo);
                poOfSalOut.put(srcbillid, salOutNos);
            }
        }
        catch (Throwable object) {
            extendedDataEntityArray = object;
            throw object;
        }
        if (!poOfSalOut.isEmpty()) {
            MainEntityType saloutstock = EntityMetadataCache.getDataEntityType((String)billName);
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                String id = bill.getString("id");
                if (!poOfSalOut.containsKey(id)) continue;
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1a", (String)"ScpOrderUnConfirmValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[0])).append(saloutstock.getDisplayName().getLocaleValue());
                Iterator salOutBillNos = ((HashSet)poOfSalOut.get(id)).iterator();
                while (salOutBillNos.hasNext()) {
                    errorMessage.append((String)salOutBillNos.next()).append('\u3001');
                }
                this.addErrorMessage(extendedDataEntity, errorMessage.subSequence(0, errorMessage.length() - 1).toString());
            }
        }
    }
}

