/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SupModuleConsumeRevokeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("consumetype");
        fields.add("materialentry");
        fields.add("materialentry.subentryentity.subsrcbillentryid");
        fields.add("materialentry.subentryentity.id");
        fields.add("materialentry.subentryentity");
        return fields;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities2 = this.getDataEntities();
        try (TraceSpan span = Tracer.create((String)"SupModuleConsumeRevokeValidator", (String)"validate");){
            ArrayList<Long> billIds = new ArrayList<Long>(8);
            for (ExtendedDataEntity entity : dataEntities2) {
                DynamicObject dataEntity = entity.getDataEntity();
                Long pkid = (Long)dataEntity.getPkValue();
                billIds.add(pkid);
            }
            QFilter qf = new QFilter("id", "in", billIds);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"scp_moduleconsume", (String)"id,consumetype,materialentry.subentryentity.id subentryid,materialentry.subentryentity.subsrcbillentryid subsrcbillentryid", (QFilter[])new QFilter[]{qf});
            HashSet<String> subsrcbillentryids = new HashSet<String>(8);
            HashMap<Long, String> subsrcbillentryidSubIdMap = new HashMap<Long, String>(8);
            for (DynamicObject dataEntity : dys) {
                String consumetype = dataEntity.getString("consumetype");
                if (!"0".equals(consumetype)) continue;
                String subsrcbillentryid = dataEntity.getString("subsrcbillentryid");
                subsrcbillentryids.add(subsrcbillentryid);
                Long subId = dataEntity.getLong("subentryid");
                subsrcbillentryidSubIdMap.put(subId, subsrcbillentryid);
            }
            if (CollectionUtils.isEmpty(subsrcbillentryids)) {
                return;
            }
            QFilter subqf = new QFilter("materialentry.subentryentity.subsrcbillentryid", "in", subsrcbillentryids);
            subqf.and("consumetype", "=", (Object)"1");
            HashMap subsrcbillentryidBillNoMap = new HashMap(8);
            DynamicObjectCollection result = QueryServiceHelper.query((String)"scp_moduleconsume", (String)"id,billno,materialentry.subentryentity.subsrcbillentryid subsrcbillentryid", (QFilter[])new QFilter[]{subqf});
            for (DynamicObject dy : result) {
                String subsrcbillentryid = dy.getString("subsrcbillentryid");
                HashSet<String> billNos = (HashSet<String>)subsrcbillentryidBillNoMap.get(subsrcbillentryid);
                if (billNos == null) {
                    billNos = new HashSet<String>(8);
                }
                String billno = dy.getString("billno");
                billNos.add(billno);
                subsrcbillentryidBillNoMap.put(subsrcbillentryid, billNos);
            }
            for (ExtendedDataEntity entity : dataEntities2) {
                HashSet billNos = new HashSet(8);
                DynamicObject dataEntity = entity.getDataEntity();
                DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection("materialentry");
                for (DynamicObject col : cols) {
                    DynamicObjectCollection subcols = col.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subentryentity : subcols) {
                        Long id = subentryentity.getLong("id");
                        String subsrcbillentryid = (String)subsrcbillentryidSubIdMap.get(id);
                        if (subsrcbillentryid == null || !subsrcbillentryidBillNoMap.containsKey(subsrcbillentryid)) continue;
                        billNos.addAll((Collection)subsrcbillentryidBillNoMap.get(subsrcbillentryid));
                    }
                }
                if (CollectionUtils.isEmpty(billNos)) continue;
                String billNoStr = billNos.stream().map(String::valueOf).collect(Collectors.joining(","));
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u6d88\u8017\u7c7b\u578b\u4e3a\u8d85\u8017\u7684\u5355\uff0c\u9700\u8981\u5148\u64a4\u9500\u8d85\u8017\u7684\u5355\u636e:{0},\u624d\u80fd\u64a4\u9500\u6d88\u8017\u7684\u5355\u636e\u3002", (String)"SupModuleConsumeRevokeValidator_0", (String)"scm-scp-opplugin", (Object[])new Object[]{billNoStr});
                this.addMessage(entity, msg, ErrorLevel.Error);
            }
        }
    }
}

