/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquirySupParticipateUtils;

public class InquiryBizHandleHelper {
    private static final String BIZSTATUS_QUOTING = "A";
    private static final String TURNS = "turns";
    private static final String TURNS_FIRST = "1";
    private static final String SUPPLIER_PROSTATUS = "supplierprostatus";
    private static final String SUPPLIERSTATUS_PENDQUOTE = "Y";
    private static final String SUPPLIERSTATUS_NOTINVOLVED = "Z";
    private static final String DEADLINE = "deadline";
    private static final String SUPENTRY_STATUS = "supentrystatus";
    private static final String SUPPLIER_BIZSTATUS = "supplierbizstatus";
    private static final String SUPPLIER_ID = "supplierId";
    private static final String ENTRY_COUNT = "entrycount";

    public static void setInquiryStatus(DynamicObjectCollection rows) {
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject row2 : rows) {
            billIds.add(row2.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", billIds).and("entryentity.supplier", "in", (Object)supplierIds);
        HashMap<String, Map<String, Object>> supplierInfoMap = new HashMap<String, Map<String, Object>>(billIds.size());
        Map<String, Date> turnsLogMap = null;
        ArrayList<String> supstatus = new ArrayList<String>();
        supstatus.add("C");
        supstatus.add("D");
        supstatus.add("E");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entryentity.supplier,entryentity.supentrystatus,entryentity.entryturns,entryentity.entrycount,entryentity.deadline,entryentity.supplierbizstatus", (QFilter[])new QFilter[]{filter}, (String)"entryentity.deadline desc");){
            dataSet.forEach(row -> {
                HashMap<String, Object> infoMap = (HashMap<String, Object>)supplierInfoMap.get(row.getString("id"));
                String supentrystatus = row.getString("entryentity.supentrystatus");
                if (infoMap == null) {
                    infoMap = new HashMap<String, Object>();
                    infoMap.put(SUPPLIER_BIZSTATUS, row.getString("entryentity.supplierbizstatus"));
                    infoMap.put(ENTRY_COUNT, row.getString("entryentity.entrycount"));
                    infoMap.put(DEADLINE, row.getDate("entryentity.deadline"));
                    infoMap.put(SUPENTRY_STATUS, supentrystatus);
                    infoMap.put(SUPPLIER_ID, row.getString("entryentity.supplier"));
                    supplierInfoMap.put(row.getString("id"), infoMap);
                }
                if (supstatus.contains(supentrystatus) && infoMap != null) {
                    infoMap.put(SUPENTRY_STATUS, supentrystatus);
                }
            });
        }
        turnsLogMap = InquiryBizHandleHelper.getTurnsInfo(billIds);
        for (DynamicObject row3 : rows) {
            InquiryBizHandleHelper.setSupplierExtendInfo(supplierInfoMap, turnsLogMap, row3);
        }
    }

    private static Map<String, Date> getTurnsInfo(List<Long> billIds) {
        HashMap<String, Date> turnsLogMap = new HashMap<String, Date>(billIds.size());
        QFilter filter = new QFilter("id", "in", billIds).and("entrylog.turns_log", "=", (Object)TURNS_FIRST);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entrylog.logdeadline", (QFilter[])new QFilter[]{filter}, null);){
            dataSet.forEach(row -> turnsLogMap.put(row.getString("id"), row.getDate("entrylog.logdeadline")));
        }
        return turnsLogMap;
    }

    private static void setSupplierExtendInfo(Map<String, Map<String, Object>> supplierInfoMap, Map<String, Date> turnsLogMap, DynamicObject row) {
        Map<String, Object> supplierInfo = supplierInfoMap.get(row.getString("id"));
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("supplierProStatus", SUPPLIER_PROSTATUS);
        paramMap.put("supplierstatus", "supplierstatus");
        paramMap.put("bizstatus", row.getString("bizstatus"));
        if (supplierInfo != null && supplierInfo.get(SUPPLIER_ID) != null) {
            String supplierbizstatus = (String)supplierInfo.get(SUPPLIER_BIZSTATUS);
            String status = (String)supplierInfo.get(SUPENTRY_STATUS);
            paramMap.put(SUPPLIER_BIZSTATUS, supplierbizstatus);
            paramMap.put("status", status);
            Date deadLine = (Date)supplierInfo.get(DEADLINE);
            InquiryBizHandleHelper.setInquirySupplierProStatus(paramMap, deadLine, row);
            row.set(TURNS, StringUtils.isBlank((Object)supplierInfo.get(ENTRY_COUNT)) ? TURNS_FIRST : supplierInfo.get(ENTRY_COUNT));
            if (deadLine != null) {
                row.set("enddate", (Object)deadLine);
            }
        } else {
            Date date = null;
            if (turnsLogMap != null && turnsLogMap.size() > 0 && turnsLogMap.get(row.getString("id")) != null) {
                date = turnsLogMap.get(row.getString("id"));
                row.set("enddate", (Object)date);
            } else {
                date = row.getDate("enddate");
            }
            InquiryBizHandleHelper.setInquirySupplierProStatus(paramMap, date, row);
            if (!TURNS_FIRST.equals(row.getString(TURNS))) {
                row.set(SUPPLIER_PROSTATUS, (Object)SupInquiryStatusEnum.PARTICALADOPTION.getVal());
                row.set("supplierstatus", (Object)SUPPLIERSTATUS_NOTINVOLVED);
            }
            if (BizStatusEnum.END.getVal().equals(row.getString("bizstatus"))) {
                row.set("supplierProStatus", (Object)BizStatusEnum.END.getVal());
            }
            row.set(TURNS, (Object)TURNS_FIRST);
        }
    }

    public static void setInquirySupplierProStatus(Map<String, String> paramMap, Date deadLine, DynamicObject row) {
        if (paramMap == null) {
            return;
        }
        String supplierbizstatus = paramMap.get(SUPPLIER_BIZSTATUS);
        String bizstatus = paramMap.get("bizstatus");
        String status = paramMap.get("status");
        String supplierProStatus = paramMap.get("supplierProStatus");
        String supplierstatus = paramMap.get("supplierstatus");
        InquirySupParticipateUtils.setSupProStatus((DynamicObject)row, (Date)deadLine, (String)supplierProStatus, (String)supplierbizstatus);
        if (status == null || status.trim().equals("")) {
            if (BIZSTATUS_QUOTING.equals(bizstatus)) {
                if (deadLine != null && deadLine.before(TimeServiceHelper.now())) {
                    row.set(supplierstatus, (Object)SUPPLIERSTATUS_NOTINVOLVED);
                } else {
                    row.set(supplierstatus, (Object)SUPPLIERSTATUS_PENDQUOTE);
                }
            } else {
                row.set(supplierstatus, (Object)SUPPLIERSTATUS_NOTINVOLVED);
            }
        } else {
            row.set(supplierstatus, (Object)status);
        }
    }
}

