/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiChannelDispatchHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.ExceptionUtil;

public class ScpIminventorySyncTaskUtil {
    public static final String IM_INV_REALBALANCE = "im_inv_realbalance";
    public static final String PUR_IMINVENTORY = "pur_iminventory";
    private static final Log log = LogFactory.getLog(ScpIminventorySyncTaskUtil.class);

    public Map<String, String> doTaskStart(long supplierID) {
        boolean isXKCloudJoint;
        boolean isEASJoint;
        Object orgIdsList;
        HashMap<String, String> msgMap = new HashMap<String, String>(1024);
        msgMap.put("code", "200");
        msgMap.put("error", "");
        log.info("supplierID=" + supplierID);
        if (supplierID < 0L) {
            msgMap.put("error", "supplierID is null");
            return msgMap;
        }
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierID, (String)"bd_supplier");
        DynamicObject jointChannelData = SystemJointChannelHelper.getDefaultJointChannelData();
        boolean isCosmicJoint = MultiChannelDispatchHelper.hasDefaultJointChannel((DynamicObject)jointChannelData, (String)"self");
        if (isCosmicJoint) {
            QFilter qFilter = new QFilter("id", "!=", (Object)0L);
            ArrayList<Long> orgIds = new ArrayList<Long>(1024);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bos_org", (String)"id", (QFilter[])qFilter.toArray(), (String)"id");
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    orgIds.add(row.getLong("id"));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            orgIdsList = this.getIdsListGroup(200, orgIds);
            object = orgIdsList.iterator();
            while (object.hasNext()) {
                Set orgIdsSet = (Set)object.next();
                List<Long> deleteIminvetoryIds = this.getDeleteIminvetoryIds(supplierID, orgIdsSet);
                this.doSyncIminvetory(supplierID, orgIdsSet);
                if (deleteIminvetoryIds.size() <= 0) continue;
                this.doClearIminvetory(deleteIminvetoryIds);
            }
        }
        if (isEASJoint = MultiChannelDispatchHelper.hasDefaultJointChannel((DynamicObject)jointChannelData, (String)"eas")) {
            try {
                ArrayList<Long> paramList = new ArrayList<Long>(1024);
                paramList.add(supplierID);
                orgIdsList = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{"KD_SRM_IMIventorySync(EAS-IERP)", paramList});
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
                msgMap.put("code", "500");
                msgMap.put("error", ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u96c6\u6210\u7ba1\u7406>\u670d\u52a1\u6d41\u7a0b\u201d\u67e5\u770b\u5bf9\u5e94\u5b9e\u4f8b\u65e5\u5fd7\u3002", (String)"IminventorySyncTaskUtil_0", (String)"scm-scp-common", (Object[])new Object[0]));
            }
        }
        if (isXKCloudJoint = MultiChannelDispatchHelper.hasDefaultJointChannel((DynamicObject)jointChannelData, (String)"xkcloud")) {
            try {
                HashMap params = new HashMap(3);
                HashSet<String> supplierNumbers = new HashSet<String>(16);
                if (supplier != null) {
                    supplierNumbers.add(supplier.getString("number"));
                }
                params.put("suppliernumber", supplierNumbers);
                Map map = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{"KD_SRM_Inventory_ManualSync(XK-IERP)", params, null});
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
                msgMap.put("code", "500");
                msgMap.put("error", ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u96c6\u6210\u7ba1\u7406>\u670d\u52a1\u6d41\u7a0b\u201d\u67e5\u770b\u5bf9\u5e94\u5b9e\u4f8b\u65e5\u5fd7\u3002", (String)"IminventorySyncTaskUtil_0", (String)"scm-scp-common", (Object[])new Object[0]));
            }
        }
        return msgMap;
    }

    private List<Set<Long>> getIdsListGroup(int pageSize, List<Long> orgIds) {
        log.info("insertdata=" + orgIds.size());
        ArrayList<Set<Long>> orgIdsList = new ArrayList<Set<Long>>(1024);
        if (orgIds.size() == 0) {
            return orgIdsList;
        }
        int countSize = this.getCountSize(orgIds.size(), pageSize);
        for (int i = 0; i < countSize; ++i) {
            HashSet<Long> orgIdSet = new HashSet<Long>(1024);
            for (int j = i * pageSize; j < (i + 1) * pageSize; ++j) {
                orgIdSet.add(orgIds.get(j));
                if (j == orgIds.size() - 1) break;
            }
            orgIdsList.add(orgIdSet);
        }
        return orgIdsList;
    }

    private int getCountSize(int count, int pageSize) {
        int countSize = count / pageSize + 1;
        return countSize;
    }

    private List<Long> getDeleteIminvetoryIds(long supplierID, Set<Long> orgIdsSet) {
        QFilter qFilter = new QFilter("recorg", "in", orgIdsSet);
        if (0L != supplierID) {
            qFilter.and(new QFilter("supplier", "=", (Object)supplierID));
        }
        ArrayList<Long> pkList = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PurIminventorySyncTask", (String)PUR_IMINVENTORY, (String)"id", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> pkList.add(row.getLong("id")));
        }
        return pkList;
    }

    public void doClearIminvetory(List<Long> deleteIminvetoryIds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)PUR_IMINVENTORY);
        List<Set<Long>> pkIdsList = this.getIdsListGroup(10000, deleteIminvetoryIds);
        for (Set<Long> pkSet : pkIdsList) {
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])pkSet.toArray());
        }
    }

    public void doSyncIminvetory(long supQFilter, Set<Long> idsLong) {
        QFilter qFilter = new QFilter("ownertype", "=", (Object)"bd_supplier");
        qFilter.and(QFilter.isNotNull((String)"material"));
        qFilter.and(new QFilter("org", "in", idsLong));
        qFilter.and(new QFilter("owner", ">", (Object)0L));
        qFilter.and(new QFilter("invtype.number", "=", (Object)"113"));
        if (0L != supQFilter) {
            qFilter.and(new QFilter("owner", "=", (Object)supQFilter));
        }
        ArrayList<Long> pkList = new ArrayList<Long>();
        String selectors = "material.group,material.id,org,warehouse,qty,id,unit,owner,auxpty,baseqty,baseunit";
        HashMap<Long, DynamicObject> iminvRealbalanceMap = new HashMap<Long, DynamicObject>();
        HashSet<Long> supIds = new HashSet<Long>();
        DynamicObjectCollection realBalances = QueryServiceHelper.query((String)IM_INV_REALBALANCE, (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject row : realBalances) {
            pkList.add(row.getLong("id"));
            iminvRealbalanceMap.put(row.getLong("id"), row);
            supIds.add(row.getLong("owner"));
        }
        HashMap<Long, Long> supplier_bizpartner = new HashMap<Long, Long>(1024);
        if (supIds.size() > 0) {
            QFilter qFilter1 = new QFilter("id", "in", supIds);
            DynamicObjectCollection supplierCol = QueryServiceHelper.query((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])qFilter1.toArray());
            for (DynamicObject sup : supplierCol) {
                supplier_bizpartner.put(sup.getLong("id"), sup.getLong("bizpartner"));
            }
        }
        if (pkList.size() > 0) {
            List<Set<Long>> pkIdsList = this.getIdsListGroup(2000, pkList);
            for (Set<Long> pkSet : pkIdsList) {
                ArrayList<DynamicObject> balanceData = new ArrayList<DynamicObject>(1024);
                for (Long pk : pkSet) {
                    this.setImInventoryValue((DynamicObject)iminvRealbalanceMap.get(pk), balanceData, supplier_bizpartner);
                }
                if (balanceData.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])balanceData.toArray(new DynamicObject[0]));
            }
        }
    }

    private void setImInventoryValue(DynamicObject balance, List<DynamicObject> balanceData, Map<Long, Long> supplier_bizpartner) {
        DynamicObject purBalacne = BusinessDataServiceHelper.newDynamicObject((String)PUR_IMINVENTORY);
        if (balance.getLong("material.id") != 0L) {
            purBalacne.set("material_id", (Object)balance.getLong("material.id"));
            purBalacne.set("materialgroup", (Object)balance.getLong("material.group"));
        }
        purBalacne.set("recorg", (Object)balance.getLong("org"));
        purBalacne.set("warehouse", (Object)balance.getLong("warehouse"));
        purBalacne.set("qty", (Object)balance.getBigDecimal("qty"));
        purBalacne.set("basicqty", (Object)balance.getBigDecimal("baseqty"));
        purBalacne.set("sourceid", balance.get("id"));
        purBalacne.set("unit", (Object)balance.getLong("unit"));
        purBalacne.set("basicunit", (Object)balance.getLong("baseunit"));
        purBalacne.set("updatetime", (Object)TimeServiceHelper.now());
        if (0L != balance.getLong("owner")) {
            purBalacne.set("supplier", (Object)balance.getLong("owner"));
            purBalacne.set("bizpartner", (Object)supplier_bizpartner.get(balance.getLong("owner")));
        }
        purBalacne.set("auxpty", balance.get("auxpty"));
        balanceData.add(purBalacne);
    }
}

