/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.common.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.AttachmentUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrderUtil;
import kd.sdk.scm.scp.extpoint.IScpOrderChangeSupport;

public class ScpOrderChangeUtil {
    private static Log log = LogFactory.getLog(ScpOrderChangeUtil.class);
    private static final String POBILLNO = "pobillno";
    private static final String ENTRY_POENTRYID = "poentryid";
    private static Map<String, String> logStatusMap = new HashMap<String, String>();
    private static final String[] UN_CONTAIN_PROS = new String[]{"id", "billno", "seq"};
    private static final List<String> CONTROL_SET = Arrays.asList("iscontrolqty", "saloutratedown", "saloutrateup", "saloutqtydown", "saloutbaseqtydown", "saloutqtyup", "saloutbaseqtyup", "basicunit");
    private static final List<String> SALOUT_QTY = Arrays.asList("saloutqtydown", "saloutbaseqtydown", "saloutqtyup", "saloutbaseqtyup");

    @Deprecated
    public static void writeBackPurOrderInfo(DynamicObject[] orderChangeObjs, DynamicObjectCollection orderChangeCollection) {
        DynamicObject[] purOderObjs = ScpOrderChangeUtil.getPurOrderInfo(orderChangeObjs);
        DynamicObjectCollection entryCol = null;
        DynamicObject entry = null;
        int entryCount = 0;
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        for (DynamicObject order : orderChangeCollection) {
            materialIds.add(order.getLong("material"));
            unitIds.add(order.getLong("unit"));
            unitIds.add(order.getLong("basicunit"));
        }
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        List extendPlugins = PluginProxy.create(IScpOrderChangeSupport.class, (String)"SCM_SCP_ORDCHANGE_SUPPORT").getPlugins();
        for (DynamicObject purOrder : purOderObjs) {
            if (purOrder.getString("logstatus") == null || "".equals(purOrder.getString("logstatus").trim()) || "null".equals(purOrder.getString("logstatus").trim())) {
                purOrder.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
            }
            ScpOrderChangeUtil.updatePurOrderByOrdChange(purOrder, orderChangeCollection, logStatusMap, extendPlugins, materialCaches, measureunitsCache);
            entryCount = 0;
            entryCol = purOrder.getDynamicObjectCollection("materialentry");
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal instockQty = BigDecimal.ZERO;
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                qty = entry.getBigDecimal("qty");
                instockQty = entry.getBigDecimal("suminstockqty");
                if (null != qty && qty.compareTo(BigDecimal.ZERO) != 0 && qty.subtract(instockQty).compareTo(BigDecimal.ZERO) != 0) continue;
                entry.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
                ++entryCount;
            }
            if (entryCount != entryCol.size()) continue;
            purOrder.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
        }
        ScpOrderChangeUtil.writeAttach2Order(orderChangeObjs, purOderObjs);
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + purOderObjs.length);
        if (purOderObjs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOderObjs);
        }
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + purOderObjs.length);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])purOderObjs, (boolean)false);
        if (purOderObjs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOderObjs);
        }
        DynamicObject[] newPurOderObjs = ScpOrderChangeUtil.getPurOrderInfo(orderChangeObjs);
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + newPurOderObjs.length);
        for (DynamicObject purOrder : newPurOderObjs) {
            List allPros = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)purOrder);
            ScpOrderChangeUtil.setLogStatusMap(allPros, purOrder, orderChangeCollection, logStatusMap);
        }
    }

    public static void writeBackPurOrderInfo(DynamicObject[] orderChangeObjs, DynamicObjectCollection orderChangeCollection, Map<String, String> logStatusMap) {
        DynamicObject[] purOderObjs = ScpOrderChangeUtil.getPurOrderInfo(orderChangeObjs);
        DynamicObjectCollection entryCol = null;
        DynamicObject entry = null;
        int entryCount = 0;
        ArrayList<String> poEntryPks = new ArrayList<String>();
        List extendPlugins = PluginProxy.create(IScpOrderChangeSupport.class, (String)"SCM_SCP_ORDCHANGE_SUPPORT").getPlugins();
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        for (DynamicObject order : orderChangeCollection) {
            materialIds.add(order.getLong("material"));
            unitIds.add(order.getLong("unit"));
            unitIds.add(order.getLong("basicunit"));
        }
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        for (DynamicObject purOrder : purOderObjs) {
            if (purOrder.getString("logstatus") == null || "".equals(purOrder.getString("logstatus").trim()) || "null".equals(purOrder.getString("logstatus").trim())) {
                purOrder.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
            }
            ScpOrderChangeUtil.updatePurOrderByOrdChange(purOrder, orderChangeCollection, logStatusMap, extendPlugins, materialCaches, measureunitsCache);
            entryCount = 0;
            entryCol = purOrder.getDynamicObjectCollection("materialentry");
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal instockQty = BigDecimal.ZERO;
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                String poEntryId = entry.getString(ENTRY_POENTRYID);
                if (poEntryId != null && !poEntryId.isEmpty()) {
                    poEntryPks.add(poEntryId);
                }
                qty = entry.getBigDecimal("qty");
                instockQty = entry.getBigDecimal("suminstockqty");
                if (null != qty && qty.compareTo(BigDecimal.ZERO) != 0 && qty.subtract(instockQty).compareTo(BigDecimal.ZERO) != 0) continue;
                entry.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
                ++entryCount;
            }
            if (entryCount != entryCol.size()) continue;
            purOrder.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
        }
        ScpOrderChangeUtil.writeAttach2Order(orderChangeObjs, purOderObjs);
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + purOderObjs.length);
        if (purOderObjs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOderObjs);
        }
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + purOderObjs.length);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])purOderObjs, poEntryPks, (Boolean)false);
        if (purOderObjs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOderObjs);
        }
        DynamicObject[] newPurOderObjs = ScpOrderChangeUtil.getPurOrderInfo(orderChangeObjs);
        log.info("\u6570\u636e\u5305\u5927\u5c0f" + newPurOderObjs.length);
        for (DynamicObject purOrder : newPurOderObjs) {
            List allPros = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)purOrder);
            ScpOrderChangeUtil.setLogStatusMap(allPros, purOrder, orderChangeCollection, logStatusMap);
        }
    }

    public static void writeAttach2Order(DynamicObject[] orderChangeObjs, DynamicObject[] purOderObjs) {
        HashMap<String, Long> orderNum_chnageIDSet = new HashMap<String, Long>(1024);
        HashSet<String> orderChangeSet = new HashSet<String>(1024);
        HashMap orderChangeID_attach = new HashMap(1024);
        HashMap<String, String> orderId_NumMap = new HashMap<String, String>(1024);
        HashSet<Long> orderIdSet = new HashSet<Long>(1024);
        for (DynamicObject order : purOderObjs) {
            orderId_NumMap.put(order.getString("id"), order.getString("billno"));
            orderIdSet.add(order.getLong("id"));
        }
        for (DynamicObject change : orderChangeObjs) {
            orderNum_chnageIDSet.put(change.getString(POBILLNO), change.getLong("id"));
            orderChangeSet.add(change.getString("id"));
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"bos_attachment", (boolean)false);
        DynamicObjectCollection attachmentCol = AttachmentUtil.getAttachements((String)"pur_ordchange", orderChangeSet, (String)"attachmentpanel", (String)selectFields);
        List<Object> attachmentList = new ArrayList<Object>(1024);
        for (Object att : attachmentCol) {
            if (null != orderChangeID_attach.get(att.getString("FInterID"))) {
                attachmentList = (List)orderChangeID_attach.get(att.getString("FInterID"));
                attachmentList.add(att);
                orderChangeID_attach.put(att.getString("FInterID"), attachmentList);
                continue;
            }
            attachmentList = new ArrayList(1024);
            attachmentList.add(att);
            orderChangeID_attach.put(att.getString("FInterID"), attachmentList);
        }
        HashMap orderNumber_attach = new HashMap(1024);
        for (Map.Entry entry : orderNum_chnageIDSet.entrySet()) {
            String string = (String)entry.getKey();
            String changeID = ((Long)entry.getValue()).toString();
            attachmentList = (List)orderChangeID_attach.get(changeID);
            if (null == attachmentList || attachmentList.size() <= 0) continue;
            orderNumber_attach.put(string, attachmentList);
        }
        HashMap orderId_attach = new HashMap(1024);
        for (Map.Entry entry : orderId_NumMap.entrySet()) {
            String orderID = (String)entry.getKey();
            String orderNum = (String)entry.getValue();
            attachmentList = (List)orderNumber_attach.get(orderNum);
            if (null == attachmentList || attachmentList.size() <= 0) continue;
            orderId_attach.put(orderID, attachmentList);
        }
        AttachmentUtil.deleteAttachements((String)purOderObjs[0].getDataEntityType().getName(), new ArrayList(orderIdSet), (String)"attachmentpanel");
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
        for (DynamicObject order : purOderObjs) {
            String orderId = order.getString("id");
            attachmentList = (List)orderId_attach.get(orderId);
            if (null == attachmentList || attachmentList.size() <= 0) continue;
            for (DynamicObject dynamicObject : attachmentList) {
                arrayList.add(AttachmentUtil.createAttachmentData((DynamicObject)order, (DynamicObject)dynamicObject));
            }
        }
        if (arrayList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject[] getPurOrderInfo(DynamicObject[] orderChangeObjs) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pur_order", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pur_order", (String)"materialentry", (boolean)false);
        HashSet<String> poBillPks = new HashSet<String>(orderChangeObjs.length);
        for (DynamicObject bill : orderChangeObjs) {
            String poBillId = bill.getString("pobillid");
            if (poBillId.isEmpty()) continue;
            poBillPks.add(poBillId);
        }
        return OrderUtil.getOrdersByPoBillIdS((String)selectFields, poBillPks);
    }

    private static void updatePurOrderByOrdChange(DynamicObject purOrder, DynamicObjectCollection orderChangeCollection, Map<String, String> logStatusMap, List<IScpOrderChangeSupport> extendPlugins, Map<Object, DynamicObject> materialCaches, Map<Object, DynamicObject> measureunitsCache) {
        List allPros = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)purOrder);
        ScpOrderChangeUtil.updatePurOderHead(allPros, purOrder, orderChangeCollection, logStatusMap, extendPlugins);
        ScpOrderChangeUtil.updatePurOderEntry(allPros, purOrder, orderChangeCollection, extendPlugins, materialCaches, measureunitsCache);
    }

    private static void updatePurOderHead(List<String> allPros, DynamicObject purOrder, DynamicObjectCollection orderChangeCollection, Map<String, String> logStatusMap, List<IScpOrderChangeSupport> extendPlugins) {
        DynamicObjectCollection cols = purOrder.getDynamicObjectCollection("materialentry");
        if (cols.size() == 0) {
            return;
        }
        String purOrderSrcBillId = ((DynamicObject)cols.get(0)).getString("pobillid");
        for (DynamicObject orderChange : orderChangeCollection) {
            String poBillno = orderChange.getString(POBILLNO);
            String poBillId = orderChange.getString("pobillid");
            if (!purOrderSrcBillId.equals(poBillId)) continue;
            Map orderChangeMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)orderChange);
            for (Map.Entry entry : orderChangeMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!allPros.contains(key) || !ScpOrderChangeUtil.isUnContains(UN_CONTAIN_PROS, key)) continue;
                purOrder.set(key, entry.getValue());
            }
            if (extendPlugins != null && !extendPlugins.isEmpty()) {
                for (IScpOrderChangeSupport support : extendPlugins) {
                    support.setOrderHeadFields(purOrder, orderChange);
                }
            }
            purOrder.set("billno", (Object)poBillno);
            purOrder.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            purOrder.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
            logStatusMap.put(purOrderSrcBillId, purOrder.getString("logstatus"));
            return;
        }
    }

    private static void setLogStatusMap(List<String> allPros, DynamicObject purOrder, DynamicObjectCollection orderChangeCollection, Map<String, String> logStatusMap) {
        DynamicObjectCollection cols = purOrder.getDynamicObjectCollection("materialentry");
        if (cols.size() == 0) {
            return;
        }
        String purOrderSrcBillId = ((DynamicObject)cols.get(0)).getString("pobillid");
        for (DynamicObject orderChange : orderChangeCollection) {
            String poBillId = orderChange.getString("pobillid");
            if (!purOrderSrcBillId.equals(poBillId)) continue;
            logStatusMap.put(purOrderSrcBillId, purOrder.getString("logstatus"));
            return;
        }
    }

    private static boolean isUnContains(String[] unContainPros, String pro) {
        boolean isUnContain = true;
        for (String unContainPro : unContainPros) {
            if (!unContainPro.equals(pro)) continue;
            isUnContain = false;
            return isUnContain;
        }
        return isUnContain;
    }

    private static void updatePurOderEntry(List<String> allPros, DynamicObject purOrder, DynamicObjectCollection orderChangeCollection, List<IScpOrderChangeSupport> extendPlugins, Map<Object, DynamicObject> materialCaches, Map<Object, DynamicObject> measureunitsCache) {
        DynamicObjectCollection entryCols = purOrder.getDynamicObjectCollection("materialentry");
        if (entryCols.size() == 0) {
            return;
        }
        String purOrderSrcBillId = ((DynamicObject)entryCols.get(0)).getString("pobillid");
        ArrayList<DynamicObject> newEntryList = new ArrayList<DynamicObject>(1024);
        DynamicObject newEntry = ORMUtil.newDynamicObject((String)"pur_order.materialentry");
        ArrayList<DynamicObject> removeEntryList = new ArrayList<DynamicObject>(1024);
        List entryAllPros = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newEntry);
        HashSet<String> src_poentryIdSet = new HashSet<String>(1024);
        for (DynamicObject entry : entryCols) {
            src_poentryIdSet.add(entry.getString(ENTRY_POENTRYID));
        }
        boolean easFlag = "eas".equals(ApiConfigUtil.getConnectErp());
        for (DynamicObject orderChange : orderChangeCollection) {
            String poBillId = orderChange.getString("pobillid");
            if (!purOrderSrcBillId.equals(poBillId)) continue;
            String poEntryId = orderChange.getString(ENTRY_POENTRYID);
            boolean matched = false;
            Map orderChangeMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)orderChange);
            Long materialId = orderChange.getLong("material");
            Long unitId = orderChange.getLong("unit");
            Long basicunitId = orderChange.getLong("basicunit");
            BigDecimal qty = orderChange.getBigDecimal("qty");
            BigDecimal basicqty = BigDecimal.ZERO;
            if (basicunitId.equals(0L)) {
                DynamicObject material = materialCaches.get(materialId);
                if (material != null) {
                    basicqty = CommonUtil.getDesQtyConv((DynamicObject)materialCaches.get(materialId), (DynamicObject)measureunitsCache.get(unitId), (BigDecimal)qty, (DynamicObject)material.getDynamicObject("baseunit"));
                }
            } else {
                basicqty = CommonUtil.getDesQtyConv((DynamicObject)materialCaches.get(materialId), (DynamicObject)measureunitsCache.get(unitId), (BigDecimal)qty, (DynamicObject)measureunitsCache.get(basicunitId));
            }
            orderChangeMap.put("basicqty", basicqty);
            BigDecimal saloutqtydown = orderChange.getBigDecimal("saloutqtydown");
            boolean iscontrolqty = orderChange.getBoolean("iscontrolqty");
            boolean isHistory = saloutqtydown == null || saloutqtydown.compareTo(BigDecimal.ZERO) == 0;
            for (DynamicObject entry : entryCols) {
                if (!poEntryId.equals(entry.getString(ENTRY_POENTRYID))) continue;
                for (Map.Entry mapEntry : orderChangeMap.entrySet()) {
                    String fiedKey = (String)mapEntry.getKey();
                    if (!(!entryAllPros.contains(fiedKey) || "entrystatus".equals(fiedKey) || isHistory && CONTROL_SET.contains(fiedKey))) {
                        if (easFlag && !iscontrolqty && SALOUT_QTY.contains(fiedKey)) {
                            entry.set(fiedKey, (Object)BigDecimal.ZERO);
                        } else {
                            if ("attachmentfield".equals(fiedKey)) continue;
                            entry.set(fiedKey, mapEntry.getValue());
                        }
                    }
                    if (extendPlugins == null || extendPlugins.isEmpty()) continue;
                    for (IScpOrderChangeSupport support : extendPlugins) {
                        support.putOrderEntryFields(entry, orderChange);
                    }
                }
                matched = true;
            }
            src_poentryIdSet.remove(poEntryId);
            if (matched) continue;
            newEntry = new DynamicObject(((DynamicObject)entryCols.get(0)).getDynamicObjectType());
            for (Map.Entry mapEntry : orderChangeMap.entrySet()) {
                if (!entryAllPros.contains(mapEntry.getKey()) || "attachmentfield".equals(mapEntry.getKey())) continue;
                newEntry.set((String)mapEntry.getKey(), mapEntry.getValue());
            }
            newEntryList.add(newEntry);
        }
        if (src_poentryIdSet.size() > 0 && orderChangeCollection.size() > 0) {
            for (DynamicObject entry : entryCols) {
                if (!src_poentryIdSet.contains(entry.getString(ENTRY_POENTRYID))) continue;
                removeEntryList.add(entry);
            }
        }
        entryCols.addAll(newEntryList);
        entryCols.removeAll(removeEntryList);
    }

    @Deprecated
    public static String poChangeConfirm2EAS(DynamicObject[] orderChangeObjs, String entityType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String msg = null;
        Map<String, Object> billdata = ScpOrderChangeUtil.getBillData(orderChangeObjs);
        if (billdata.size() > 0) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billno", billdata);
            dataMap.put("cmfstatus", "3");
            dataMap.put("logstatus", logStatusMap);
            param.put("data", dataMap);
            msg = ScpOrderChangeUtil.sendData(param, entityType);
            ScpOrderChangeUtil.clearLogStatusMap();
        }
        return msg;
    }

    public static String poChangeConfirm2EAS(DynamicObject[] orderChangeObjs, String entityType, Map<String, String> logStatusMap) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String msg = null;
        Map<String, Object> billdata = ScpOrderChangeUtil.getBillData(orderChangeObjs);
        if (billdata.size() > 0) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billno", billdata);
            dataMap.put("cmfstatus", "3");
            dataMap.put("logstatus", logStatusMap);
            param.put("data", dataMap);
            msg = ScpOrderChangeUtil.sendData(param, entityType);
        }
        return msg;
    }

    private static Map<String, Object> getBillData(DynamicObject[] objs) {
        HashMap<String, Object> billData = new HashMap<String, Object>((int)((double)objs.length / 0.75));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject dynamicObject : objs) {
            String billno = dynamicObject.getString(POBILLNO);
            HashMap entryMap = new HashMap();
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                Date entrydelidate = entry.getDate("entrydelidate");
                BigDecimal qty = entry.getBigDecimal("qty");
                String srcentryid = entry.getString(ENTRY_POENTRYID);
                if (billno.trim().length() <= 0 || !dynamicObject.getString("cfmstatus").equals(ConfirmStatusEnum.UNCONFIRM.getVal())) continue;
                HashMap<String, Object> entryDataMap = new HashMap<String, Object>();
                entryDataMap.put("entrydelidate", sdf.format(entrydelidate));
                entryDataMap.put("qty", qty);
                entryMap.put(srcentryid, entryDataMap);
            }
            billData.put(billno, entryMap);
        }
        return billData;
    }

    private static String sendData(Map<String, Object> param, String entityType) {
        if (param.isEmpty()) {
            return null;
        }
        param.put("billtype", entityType);
        param.put("action", "confirm");
        param.put("code", "200");
        return ApiUtil.purOrderChangeConfirm(param);
    }

    public static void clearLogStatusMap() {
        logStatusMap.clear();
    }
}

