/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.helper.pmapply.BidBillFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.opplugin.validator.SouBidAuditValidator;

public class SouBidAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SouBidAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bidstatus");
        fieldKeys.add("biztype");
        fieldKeys.add("billno");
        fieldKeys.add("billdate");
        fieldKeys.add("org");
        fieldKeys.add("bidnumber");
        fieldKeys.add("delidate1");
        fieldKeys.add("srcbilltype");
        fieldKeys.add("srcbillid");
        fieldKeys.add("srcentryid");
        fieldKeys.add("prbillid");
        fieldKeys.add("prentryid");
        fieldKeys.add("resultdate");
        fieldKeys.add("enrolldate");
        fieldKeys.add("supquoentry.entrysupplier");
        fieldKeys.add("person");
        fieldKeys.add("creator");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            dynamicObject.set("billdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("bidstatus", (Object)BidStatusEnum.ENROLMENT.getVal());
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                String srcBillId = row.getString("srcbillid");
                String srcEntryId = row.getString("srcentryid");
                if (!row.getString("prbillid").isEmpty() && !row.getString("prentryid").isEmpty()) continue;
                row.set("prbillid", (Object)srcBillId);
                row.set("prentryid", (Object)srcEntryId);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equalsIgnoreCase(operationKey)) {
            List selectedRows = e.getSelectedRows();
            for (ExtendedDataEntity extendedDataEntity : selectedRows) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String supscope = dataEntity.getString("biztype");
                if (!"2".equalsIgnoreCase(supscope)) continue;
                DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("supquoentry");
                HashSet<Long> bizPartnerPks = new HashSet<Long>();
                for (DynamicObject row : entryCol) {
                    bizPartnerPks.add(row.getDynamicObject("entrysupplier").getLong("bizpartner_id"));
                }
                this.beforeSendMessage(bizPartnerPks, dataEntity);
            }
            if (ApiConfigUtil.hasCQScmConfig()) {
                BidBillFactory pmApplyStatusUpdateFactory = new BidBillFactory();
                PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create(this.billEntityType.getName(), operationKey, "A", e.getDataEntities());
                pmApplyStatusUpdate.execute();
            }
        }
    }

    private void beforeSendMessage(Set<Long> bizPartnerPks, DynamicObject dataEntity) {
        List userPks = BizPartnerUtil.getSupUserIdsByBizPartner(bizPartnerPks);
        if (!userPks.isEmpty()) {
            StringBuilder content = new StringBuilder();
            content.append(dataEntity.getDynamicObject("org").getString("name")).append(ResManager.loadKDString((String)"\u901a\u77e5\uff1a\u4f60\u6709\u7ade\u4ef7\u5355", (String)"SouBidAuditOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append(dataEntity.getString("billno")).append(ResManager.loadKDString((String)"\u5f85\u7ade\u4ef7\uff0c\u8bf7\u5904\u7406\u3002", (String)"SouBidAuditOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            Long id = dataEntity.getLong("id");
            String domainContextUrl = UrlService.getDomainContextUrl();
            StringBuilder mobUrl = new StringBuilder();
            String accountId = RequestContext.get().getAccountId();
            mobUrl.append(domainContextUrl);
            mobUrl.append("/index.html?formId=quo_bidbill&pkId=").append(dataEntity.getPkValue()).append("&type=report");
            if (accountId != null) {
                mobUrl.append('&').append("accountId=").append(accountId);
            }
            HashMap<String, String> msgParams = new HashMap<String, String>();
            DynamicObject person = dataEntity.getDynamicObject("person");
            if (person != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject creator = dataEntity.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(creator.getPkValue()));
                msgParams.put("senderName", creator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u5df2\u751f\u6548\uff0c\u8bf7\u53ca\u65f6\u7ade\u4ef7\u3002", (String)"SouBidAuditOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            msgParams.put("content", content.toString());
            msgParams.put("toMob", "true");
            msgParams.put("hasBizDataId", "false");
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_bidbill" + "&pkId=" + id);
            msgParams.put("mobContentUrl", mobUrl.toString());
            SouSendMessageUtil.sendMessage(bizPartnerPks, (List)userPks, msgParams);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouBidAuditValidator());
    }
}

