/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.sou.opplugin.validator.SouBidStartValidator;

public class SouBidStartOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bidstatus");
        e.getFieldKeys().add("checktype");
        e.getFieldKeys().add("cashdeposit");
        e.getFieldKeys().add("opendate");
        e.getFieldKeys().add("bidnumber");
        e.getFieldKeys().add("enrollnum");
        e.getFieldKeys().add("pausetime");
        e.getFieldKeys().add("pausestarttime");
        e.getFieldKeys().add("supquoentry.entrysupplier");
        e.getFieldKeys().add("supquoentry.supentrystatus");
        e.getFieldKeys().add("supquoentry.suppaydate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouBidStartValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List dataEntity = e.getValidExtDataEntities();
        for (ExtendedDataEntity extDataEntity : dataEntity) {
            DynamicObject obj = extDataEntity.getDataEntity();
            String bidStatus = obj.getString("bidstatus");
            int bidNum = obj.getInt("bidnumber");
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.END.getVal())) {
                e.cancel = true;
            } else if (bidStatus != null && bidStatus.equals(BidStatusEnum.CONFIRMED.getVal())) {
                e.cancel = true;
            } else if (bidStatus != null && bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
                e.cancel = true;
            } else if (bidStatus != null && bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) {
                e.cancel = true;
            } else if (bidStatus != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
                if (!obj.getString("checktype").equals("3") && bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal())) {
                    e.cancel = true;
                }
            } else if (obj.getDate("opendate").after(new Date())) {
                e.cancel = true;
            } else {
                StringBuffer strBuffer = new StringBuffer();
                int supplierCount = this.countEnrollSuppler(obj, strBuffer);
                if (supplierCount < bidNum) {
                    e.cancel = true;
                }
            }
            if (e.cancel) {
                return;
            }
            if (bidStatus != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
                obj.set("pausestarttime", (Object)TimeServiceHelper.now());
            } else {
                obj.set("opendate", (Object)TimeServiceHelper.now());
            }
            DynamicObjectCollection supQuoEntryCol = obj.getDynamicObjectCollection("supquoentry");
            BigDecimal cashdeposit = obj.getBigDecimal("cashdeposit");
            for (DynamicObject supQuoEntry : supQuoEntryCol) {
                Date suppaydate;
                if (!SupBidStatusEnum.BEENEXAMINED.getVal().equals(supQuoEntry.getString("supentrystatus")) || null != (suppaydate = supQuoEntry.getDate("suppaydate")) || BigDecimal.ZERO.compareTo(cashdeposit) >= 0) continue;
                supQuoEntry.set("supentrystatus", (Object)SupBidStatusEnum.REFUSEDEPOSIT.getVal());
            }
        }
    }

    private int countEnrollSuppler(DynamicObject bidObj, StringBuffer strBuffer) {
        int supplierCount = 0;
        String supentrystatus = "";
        Date suppaydate = null;
        DynamicObjectCollection supquoentryCol = bidObj.getDynamicObjectCollection("supquoentry");
        String checktype = bidObj.getString("checktype");
        BigDecimal cashdeposit = bidObj.getBigDecimal("cashdeposit");
        for (DynamicObject dynamicObject : supquoentryCol) {
            supentrystatus = dynamicObject.getString("supentrystatus");
            suppaydate = dynamicObject.getDate("suppaydate");
            if ("1".equals(checktype)) {
                if (cashdeposit.compareTo(BigDecimal.ZERO) == 0) {
                    if (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                        ++supplierCount;
                        continue;
                    }
                    if (SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) {
                        strBuffer.append(ResManager.loadKDString((String)"\u8d44\u5ba1\u672a\u901a\u8fc7", (String)"SouBidStartOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                        continue;
                    }
                    strBuffer.append(ResManager.loadKDString((String)"\u672a\u8d44\u5ba1", (String)"SouBidStartOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                    strBuffer.append(ResManager.loadKDString((String)"\u672a\u4ea4\u4fdd\u8bc1\u91d1", (String)"SouBidStartOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                if (SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) {
                    strBuffer.append(ResManager.loadKDString((String)"\u8d44\u5ba1\u672a\u901a\u8fc7", (String)"SouBidStartOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                strBuffer.append(ResManager.loadKDString((String)"\u672a\u8d44\u5ba1", (String)"SouBidStartOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                continue;
            }
            if (cashdeposit.compareTo(BigDecimal.ZERO) == 0) {
                if ("3".equals(checktype)) {
                    if (!SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
                    ++supplierCount;
                    continue;
                }
                if (SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (!SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) continue;
                strBuffer.append(ResManager.loadKDString((String)"\u672a\u8d44\u5ba1", (String)"SouBidStartOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                continue;
            }
            if ("3".equals(checktype)) {
                if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus)) {
                    ++supplierCount;
                    continue;
                }
                if (!SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) && !SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus)) continue;
                strBuffer.append(ResManager.loadKDString((String)"\u672a\u4ea4\u4fdd\u8bc1\u91d1", (String)"SouBidStartOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                continue;
            }
            if (SupBidStatusEnum.RECEIPTDEPOSIT.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus) && suppaydate != null) {
                ++supplierCount;
                continue;
            }
            if (SupBidStatusEnum.BEEXAMINING.getVal().equals(supentrystatus) || SupBidStatusEnum.BEENEXAMINED.getVal().equals(supentrystatus) && suppaydate == null) {
                strBuffer.append(ResManager.loadKDString((String)"\u672a\u4ea4\u4fdd\u8bc1\u91d1", (String)"SouBidStartOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
                continue;
            }
            if (!SupBidStatusEnum.HAVEREFUSED.getVal().equals(supentrystatus)) continue;
            strBuffer.append(ResManager.loadKDString((String)"\u672a\u8d44\u5ba1", (String)"SouBidStartOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0])).append('\n');
        }
        return supplierCount;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void setContext(MainEntityType billEntityType, Map<String, Object> operateMeta, OperateOption option) {
        if ("false".equals(option.getVariableValue("writeLog", "true"))) {
            operateMeta.put("logEnable", false);
        } else {
            operateMeta.put("logEnable", true);
        }
        super.setContext(billEntityType, operateMeta, option);
    }
}

