/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SouBillTplImportValidator
extends AbstractValidator {
    private String materialEntry = "";

    private void initBillFieldKeys() {
        String entityKey = this.getEntityKey();
        if ("sou_inquiry".equals(entityKey) || "sou_bidbill".equals(entityKey)) {
            this.materialEntry = "materialentry";
        }
    }

    public void validate() {
        this.initBillFieldKeys();
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> materialUnitIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        HashSet<Long> lineTypeIds = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter("serviceattribute.entity.number", "=", (Object)"bd_material");
        DynamicObjectCollection lineTypeCol = QueryServiceHelper.query((String)"bd_linetype", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject lineType : lineTypeCol) {
            lineTypeIds.add(lineType.getLong("id"));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject inquiryBill = dataEntity.getDataEntity();
            DynamicObjectCollection materialentry = inquiryBill.getDynamicObjectCollection(this.materialEntry);
            for (DynamicObject entry : materialentry) {
                DynamicObject unitDyn = entry.getDynamicObject("unit");
                Long unitId = unitDyn != null ? unitDyn.getLong("id") : 0L;
                unitIds.add(unitId);
                DynamicObject lineType = entry.getDynamicObject("linetype");
                DynamicObject materialDyn = entry.getDynamicObject("material");
                if (null == materialDyn) continue;
                long materialId = materialDyn.getLong("id");
                materialIds.add(materialId);
                Long materialUnitId = materialDyn.getDynamicObject("baseunit").getLong("id");
                materialUnitIds.add(materialUnitId);
                this.checkMaterialLineType(dataEntity, lineType, materialDyn, lineTypeIds);
            }
        }
        Set<Long> cacheUnits = this.cacheUnits(unitIds);
        Map<Long, Set<Long>> unitConvsMap = this.cacheUnitConvs(materialUnitIds, unitIds);
        Map<Long, Set<Long>> materialUnitsMap = this.cacheMaterialUnits(materialIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject inquiryBill = dataEntity.getDataEntity();
            DynamicObjectCollection materialentry = inquiryBill.getDynamicObjectCollection(this.materialEntry);
            for (DynamicObject entry : materialentry) {
                this.checkMaterialUnit(entry, dataEntity, cacheUnits, unitConvsMap, materialUnitsMap);
            }
        }
    }

    private Map<Long, Set<Long>> cacheMaterialUnits(Set<Long> materialIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(1024);
        QFilter[] filters = new QFilter[]{new QFilter("materialid", "in", materialIds)};
        String selectFields = "id,materialid.id,measureunitid.id";
        Map multimeasureunits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : multimeasureunits.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            long materialId = value.getLong("materialid.id");
            long measureunitid = value.getLong("measureunitid.id");
            HashSet<Long> existMaterial = (HashSet<Long>)map.get(materialId);
            if (existMaterial == null) {
                existMaterial = new HashSet<Long>(1024);
            }
            existMaterial.add(measureunitid);
            map.put(materialId, existMaterial);
        }
        return map;
    }

    private void checkMaterialLineType(ExtendedDataEntity dataEntity, DynamicObject lineType, DynamicObject materialDyn, Set<Long> lineTypeIds) {
        DynamicObjectCollection serviceAttributes = materialDyn.getDynamicObjectCollection("serviceattribute");
        HashSet<Object> serviceAttributeList = new HashSet<Object>(serviceAttributes.size());
        for (DynamicObject serviceAttribute : serviceAttributes) {
            serviceAttributeList.add(serviceAttribute.get("fbasedataid_id"));
        }
        if (lineType != null && !lineTypeIds.contains(lineType.getLong("id"))) {
            return;
        }
        if (lineType != null && !serviceAttributeList.contains(lineType.getDynamicObject("serviceattribute").getPkValue())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f15\u5165\u7684\u5355\u636e\u7269\u6599\u2018%1$s\u2019\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0e\u884c\u7c7b\u578b\u2018%2$s%3$s\u2019\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f15\u5165\u3002", (String)"SouBillTplImportValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]), materialDyn.get("number"), lineType.get("number"), lineType.get("name")));
        }
    }

    private void checkMaterialUnit(DynamicObject entry, ExtendedDataEntity dataEntity, Set<Long> cacheUnits, Map<Long, Set<Long>> unitConvsMap, Map<Long, Set<Long>> materialUnitsMap) {
        DynamicObject unitDyn = entry.getDynamicObject("unit");
        DynamicObject material = entry.getDynamicObject("material");
        if (null == material) {
            return;
        }
        if (unitDyn == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"SouBillTplImportValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]), entry.get("seq")));
        } else {
            long materialId = material.getLong("id");
            Long unitId = unitDyn.getLong("id");
            String unitNum = unitDyn.getString("number");
            Long materialUnitId = material.getDynamicObject("baseunit").getLong("id");
            if (!cacheUnits.contains(unitId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8ba1\u91cf\u5355\u4f4d%2$s\u4e0d\u5b58\u5728\u3002", (String)"SouBillTplImportValidator_4", (String)"scm-sou-opplugin", (Object[])new Object[0]), entry.get("seq"), unitNum));
            } else if (!(unitId.equals(materialUnitId) || unitConvsMap.containsKey(materialUnitId) && unitConvsMap.get(materialUnitId).contains(unitId))) {
                Set<Long> multiUnits;
                if (!materialUnitsMap.isEmpty() && (multiUnits = materialUnitsMap.get(materialId)) != null && multiUnits.contains(unitId)) {
                    return;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u7ef4\u62a4\u901a\u7528\u5355\u4f4d\u6362\u7b97\u6216\u7ef4\u62a4\u8be5\u7269\u6599\u5355\u4f4d\u4fe1\u606f\u3002", (String)"SouBillTplImportValidator_5", (String)"scm-sou-opplugin", (Object[])new Object[0]), entry.get("seq")));
            }
        }
    }

    private Set<Long> cacheUnits(Set<Long> unitIds) {
        HashSet<Long> set = new HashSet<Long>(1024);
        DynamicObjectCollection unitDyns = QueryServiceHelper.query((String)"bd_measureunits", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", unitIds).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")))});
        for (DynamicObject unitDyn : unitDyns) {
            set.add(unitDyn.getLong("id"));
        }
        return set;
    }

    private Map<Long, Set<Long>> cacheUnitConvs(Set<Long> materialUnitIds, Set<Long> unitIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(1024);
        QFilter qFilter1 = new QFilter("srcmuid", "in", materialUnitIds).and(new QFilter("desmuid", "in", unitIds));
        QFilter qFilter2 = new QFilter("srcmuid", "in", unitIds).and(new QFilter("desmuid", "in", materialUnitIds));
        DynamicObjectCollection unitConvs = QueryServiceHelper.query((String)"bd_measureunitconv", (String)"id,srcmuid,desmuid", (QFilter[])new QFilter[]{qFilter1.or(qFilter2)});
        for (DynamicObject unitConv : unitConvs) {
            long srcmuId = unitConv.getLong("srcmuid");
            long desmuid = unitConv.getLong("desmuid");
            this.fillUnitMap(map, srcmuId, desmuid);
            this.fillUnitMap(map, desmuid, srcmuId);
        }
        return map;
    }

    private void fillUnitMap(Map<Long, Set<Long>> map, long srcmuId, long desmuid) {
        Set<Long> set = map.get(srcmuId);
        if (set == null) {
            set = new HashSet<Long>(16);
            map.put(srcmuId, set);
        }
        set.add(desmuid);
    }
}

