/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SouBillTypeDefaultOp
extends AbstractOperationServicePlugIn {
    private long defaultTypeId = 0L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype_id");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        long defaultBillType = this.getDefaultBillType(dataEntities[0].getDataEntityType().getName());
        for (DynamicObject dataEntity : dataEntities) {
            long billType = dataEntity.getLong("billtype_id");
            if (billType != 0L) continue;
            dataEntity.set("billtype_id", (Object)defaultBillType);
        }
    }

    public long getDefaultBillType(String formId) {
        if (this.defaultTypeId != 0L) {
            return this.defaultTypeId;
        }
        QFilter qFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        qFilter.and("billformid", "=", (Object)formId);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }
}

