/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.helper.pmapply.CompareFactory;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.sou.common.SouSendMessageUtil;
import kd.scm.sou.opplugin.validator.SouCompareValidator;

public class SouCompareAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("inquiryno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("materialentry.material");
        e.getFieldKeys().add("materialentry.supplier");
        e.getFieldKeys().add("materialentry.qty");
        e.getFieldKeys().add("materialentry.price");
        e.getFieldKeys().add("materialentry.taxprice");
        e.getFieldKeys().add("materialentry.srcbillid");
        e.getFieldKeys().add("materialentry.srcentryid");
        e.getFieldKeys().add("materialentry.prentryid");
        e.getFieldKeys().add("materialentry.prbillid");
        e.getFieldKeys().add("materialentry.note");
        e.getFieldKeys().add("materialentry.taxrateid");
        e.getFieldKeys().add("materialentry.taxrate");
        e.getFieldKeys().add("materialentry.remark");
        e.getFieldKeys().add("quoentry");
        e.getFieldKeys().add("quoentry.isadopt");
        e.getFieldKeys().add("quoentry.entrysupplier");
        e.getFieldKeys().add("quoentry.quobillno");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("creator");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] compareBillObs = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject compareBill : compareBillObs) {
                    compareBill.set("billdate", (Object)compareBill.getDate("auditdate"));
                }
                SaveServiceHelper.save((DynamicObject[])compareBillObs);
                ArrayList<String> inquiryBillNoList = new ArrayList<String>();
                ArrayList<Object> allQuoteBillIdList = new ArrayList<Object>();
                HashMap<String, List<Object>> quoteBillMap = new HashMap<String, List<Object>>();
                HashMap<String, DynamicObject> quoteEntryId_compareEntryMap = new HashMap<String, DynamicObject>();
                HashMap<String, String> auditMsgMap = new HashMap<String, String>();
                for (DynamicObject compareBill : compareBillObs) {
                    String inquiryBillNo = compareBill.getString("inquiryno");
                    if (!inquiryBillNoList.contains(inquiryBillNo) && StringUtils.isNotBlank((CharSequence)inquiryBillNo)) {
                        inquiryBillNoList.add(inquiryBillNo);
                    }
                    DynamicObjectCollection entryCols = compareBill.getDynamicObjectCollection("materialentry");
                    ArrayList<Long> quoteBillIdList = new ArrayList<Long>();
                    ArrayList<String> entryIdList = null;
                    for (DynamicObject entryCol : entryCols) {
                        String srcBillId = entryCol.getString("srcbillid");
                        if (!quoteBillIdList.contains(srcBillId) && StringUtils.isNotBlank((CharSequence)srcBillId)) {
                            quoteBillIdList.add(Long.valueOf(srcBillId));
                        }
                        String srcentryid = entryCol.getString("srcentryid");
                        entryIdList = (ArrayList<String>)quoteBillMap.get(srcBillId);
                        if (entryIdList != null) {
                            entryIdList.add(srcentryid);
                        } else {
                            entryIdList = new ArrayList<String>();
                            entryIdList.add(srcentryid);
                            quoteBillMap.put(srcBillId, entryIdList);
                        }
                        quoteEntryId_compareEntryMap.put(srcentryid, entryCol);
                    }
                    allQuoteBillIdList.addAll(quoteBillIdList);
                    if (null == compareBill.getLocaleString("remark")) continue;
                    auditMsgMap.put(inquiryBillNo, compareBill.getLocaleString("remark").getLocaleValue());
                }
                DynamicObject[] adoptQuoteBillObjs = this.getSouQuoteBillByBillId(allQuoteBillIdList);
                this.updateQuoteBill(adoptQuoteBillObjs, quoteEntryId_compareEntryMap, quoteBillMap);
                this.updateQuote(inquiryBillNoList, allQuoteBillIdList);
                this.noticeSupplier(compareBillObs);
                DynamicObject[] souInquiryObjs = InquiryUtil.getInquiryBillByBillNo(inquiryBillNoList);
                this.updateInquiryBizStatus(souInquiryObjs, auditMsgMap);
                if (ApiConfigUtil.hasCQScmConfig()) {
                    CompareFactory pmApplyStatusUpdateFactory = new CompareFactory();
                    PmApplyStatusUpdate pmApplyStatusUpdate = pmApplyStatusUpdateFactory.create("sou_compare", e.getOperationKey(), "B", e.getDataEntities());
                    pmApplyStatusUpdate.execute();
                }
                this.updateInquiryQuoSupEntry(adoptQuoteBillObjs, souInquiryObjs);
                break;
            }
        }
    }

    private void updateInquiryBizStatus(DynamicObject[] inquiryObjs, Map<String, String> auditMsgMap) {
        for (DynamicObject inquiryObj : inquiryObjs) {
            inquiryObj.set("bizstatus", (Object)BizStatusEnum.CONFIRMED.getVal());
            inquiryObj.set("decider", (Object)RequestContext.get().getUserId());
            inquiryObj.set("decidedate", (Object)TimeServiceHelper.now());
            inquiryObj.set("audit", (Object)auditMsgMap.get(inquiryObj.getString("billno")));
        }
        if (inquiryObjs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])inquiryObjs);
        }
    }

    private void updateQuote(List<String> inquiryBillNoList, List<Object> allQuoteBillIdList) {
        if (inquiryBillNoList.size() > 0) {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            DynamicObject[] quotes = InquiryUtil.getQuoteBillByInquiryBillNo(inquiryBillNoList);
            for (int i = 0; i < quotes.length; ++i) {
                if (allQuoteBillIdList.contains(quotes[i].get("id"))) continue;
                indexList.add(i);
            }
            DynamicObject[] newQuotes = new DynamicObject[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                newQuotes[i] = quotes[(Integer)indexList.get(i)];
                newQuotes[i].set("bizstatus", (Object)SupInquiryStatusEnum.NOTADOPTED.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])newQuotes);
        }
    }

    private void updateQuoteBill(DynamicObject[] souQuoteBillObjs, Map<String, DynamicObject> quoteEntryId_compareEntryMap, Map<String, List<Object>> quoteBillMap) {
        for (DynamicObject souQuoteBill : souQuoteBillObjs) {
            String billId = souQuoteBill.getPkValue().toString();
            List<Object> acceptEntryList = quoteBillMap.get(billId);
            if (acceptEntryList == null) {
                souQuoteBill.set("bizstatus", (Object)SupInquiryStatusEnum.NOTADOPTED.getVal());
                continue;
            }
            DynamicObjectCollection entryCols = souQuoteBill.getDynamicObjectCollection("materialentry");
            if (entryCols.size() == acceptEntryList.size()) {
                souQuoteBill.set("bizstatus", (Object)SupInquiryStatusEnum.HAVEADOPTED.getVal());
            } else {
                souQuoteBill.set("bizstatus", (Object)SupInquiryStatusEnum.PARTICALADOPTION.getVal());
            }
            for (DynamicObject entryCol : entryCols) {
                String entryId = entryCol.getPkValue().toString();
                DynamicObject compareEntry = quoteEntryId_compareEntryMap.get(entryId);
                if (compareEntry == null) {
                    entryCol.set("result", (Object)"2");
                    continue;
                }
                entryCol.set("result", (Object)"1");
                entryCol.set("cfmqty", (Object)compareEntry.getBigDecimal("qty"));
                entryCol.set("cfmprice", (Object)compareEntry.getBigDecimal("price"));
                entryCol.set("cfmtaxprice", (Object)compareEntry.getBigDecimal("taxprice"));
                entryCol.set("cfmnote", (Object)compareEntry.getString("note"));
                DynamicObject taxrateDO = (DynamicObject)compareEntry.get("taxrateid");
                entryCol.set("cfmtaxrateid", (Object)taxrateDO);
                entryCol.set("cfmtaxrate", (Object)(taxrateDO == null ? compareEntry.getBigDecimal("taxrate") : taxrateDO.getBigDecimal("taxrate")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])souQuoteBillObjs);
    }

    private void updateInquiryQuoSupEntry(DynamicObject[] adoptQuoteBillObjs, DynamicObject[] souInquiryBill) {
        ArrayList<String> billNoList = new ArrayList<String>(souInquiryBill.length);
        for (DynamicObject souInquiry : souInquiryBill) {
            billNoList.add(souInquiry.getString("billno"));
        }
        DynamicObject[] quoteBillObjs = InquiryUtil.getQuoteBillByInquiryBillNo(billNoList);
        HashMap<String, DynamicObject> quoteMap = new HashMap<String, DynamicObject>((int)((double)quoteBillObjs.length / 0.75));
        for (DynamicObject quoteBill : quoteBillObjs) {
            quoteMap.put(quoteBill.getString("supplier.id") + quoteBill.getString("inquiryno") + quoteBill.getString("turns"), quoteBill);
        }
        for (DynamicObject souInquiry : souInquiryBill) {
            String inquiryNo = souInquiry.getString("billno");
            DynamicObjectCollection quoteSupEntryCols = souInquiry.getDynamicObjectCollection("entryentity");
            for (DynamicObject quoteSupEntry : quoteSupEntryCols) {
                DynamicObject supplier = quoteSupEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                String entryturns = quoteSupEntry.getString("entryturns");
                DynamicObject quoteBillObj = this.getQuoteBillDynamicObject(adoptQuoteBillObjs, supplier.getPkValue().toString() + inquiryNo + entryturns);
                if (quoteBillObj == null && null != quoteMap.get(supplier.getString("id") + inquiryNo + entryturns)) {
                    quoteSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.NOTADOPTED.getVal());
                    continue;
                }
                if (null == quoteBillObj) continue;
                String bizStatus = quoteBillObj.getString("bizstatus");
                quoteSupEntry.set("supentrystatus", (Object)bizStatus);
            }
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)souInquiry, (String)"entryentity");
        }
        SaveServiceHelper.save((DynamicObject[])souInquiryBill);
    }

    private DynamicObject getQuoteBillDynamicObject(DynamicObject[] quoteBillObjs, String key) {
        for (DynamicObject quoteBillObj : quoteBillObjs) {
            DynamicObject supplier = quoteBillObj.getDynamicObject("supplier");
            String quoteInquiryNo = quoteBillObj.getString("inquiryno");
            String turns = quoteBillObj.getString("turns");
            if (!key.equals(supplier.getPkValue().toString() + quoteInquiryNo + turns)) continue;
            return quoteBillObj;
        }
        return null;
    }

    private DynamicObject[] getSouQuoteBillByBillId(List<Object> billIdList) {
        HashMap params = new HashMap(2);
        HashMap<String, Object[]> idMap = new HashMap<String, Object[]>(1);
        idMap.put("in", billIdList.toArray(new Object[0]));
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_quote", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_quote", (String)"materialentry", (boolean)false);
        return ORMUtil.load((String)"sou_quote", (String)selectFields, params);
    }

    private void beforeSendMessage(DynamicObject entrysupplier, DynamicObject quoteDO, DynamicObject quoInquiryDO, String adoptStatus, DynamicObject compareBill) {
        if (entrysupplier == null || quoteDO == null) {
            return;
        }
        long bizpartnerId = entrysupplier.getLong("bizpartner_id");
        HashSet<Long> bizpartnerIds = new HashSet<Long>();
        bizpartnerIds.add(bizpartnerId);
        HashSet<Long> userPkId = new HashSet<Long>();
        Long creator = quoteDO.getLong("creator");
        Long modifier = quoteDO.getLong("modifier");
        Long auditor = quoteDO.getLong("auditor");
        userPkId.add(creator);
        userPkId.add(modifier);
        userPkId.add(auditor);
        if (!bizpartnerIds.isEmpty() && !userPkId.isEmpty() && quoInquiryDO != null) {
            String content = MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u67e5\u8be2\u5355\uff08\u8be2\u4ef7\u6807\u9898\uff1a{0}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{1}\uff09\u7684\u7ed3\u679c\u72b6\u6001\u4e3a{2}\uff0c\u8bf7\u60a8\u67e5\u9605\u3002", (String)"SouCompareAuditOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0]), quoInquiryDO.getString("quotetitle"), quoInquiryDO.getString("billno"), adoptStatus);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            DynamicObject person = compareBill.getDynamicObject("person");
            if (person != null) {
                msgParams.put("senderId", String.valueOf(person.getPkValue()));
                msgParams.put("senderName", person.getString("name"));
            } else {
                DynamicObject compareCreator = compareBill.getDynamicObject("creator");
                msgParams.put("senderId", String.valueOf(compareCreator.getPkValue()));
                msgParams.put("senderName", compareCreator.getString("name"));
            }
            msgParams.put("title", ResManager.loadKDString((String)"\u8be2\u4ef7\u7ed3\u679c\u901a\u77e5", (String)"SouCompareAuditOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            msgParams.put("content", content);
            msgParams.put("failMsgTitle", ResManager.loadKDString((String)"\u8be2\u4ef7\u7ed3\u679c\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u901a\u77e5\u4e1a\u52a1\u90e8\u95e8\u8ddf\u8fdb\u3002", (String)"SouCompareAuditOp_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            msgParams.put("failMsgContent", String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a\u53d1\u9001\u5931\u8d25\u4fe1\u606f\uff1a%1$s", (String)"SouCompareAuditOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0]), content));
            msgParams.put("contentUrl", RequestContext.get().getClientUrl() + "?formId=" + "quo_inquiry" + "&pkId=" + quoInquiryDO.getLong("id"));
            msgParams.put("toMob", "false");
            msgParams.put("hasBizDataId", "false");
            SouSendMessageUtil.sendMessage(bizpartnerIds, new ArrayList(userPkId), msgParams);
        }
    }

    private void noticeSupplier(DynamicObject[] compareBillObs) {
        for (DynamicObject compareBill : compareBillObs) {
            String inquiryBillNo = compareBill.getString("inquiryno");
            DynamicObjectCollection quoentry = compareBill.getDynamicObjectCollection("quoentry");
            String adoptStatus = ResManager.loadKDString((String)"\u5df2\u91c7\u7eb3", (String)"SouCompareAuditOp_4", (String)"scm-sou-opplugin", (Object[])new Object[0]);
            DynamicObject quoInquiryDO = QueryServiceHelper.queryOne((String)"quo_inquiry", (String)"id,billno,quotetitle", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryBillNo)});
            for (DynamicObject supplierDO : quoentry) {
                String quoteBillNo;
                DynamicObject quoteDO;
                String isadopt = supplierDO.getString("isadopt");
                DynamicObject entrysupplier = supplierDO.getDynamicObject("entrysupplier");
                if (entrysupplier == null || (quoteDO = QueryServiceHelper.queryOne((String)"quo_quote", (String)"id,creator,modifier,auditor,bizstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(quoteBillNo = supplierDO.getString("quobillno")))})) == null) continue;
                String bizstatus = quoteDO.getString("bizstatus");
                if ("true".equals(isadopt)) {
                    if ("C".equals(bizstatus)) {
                        adoptStatus = ResManager.loadKDString((String)"\u5df2\u91c7\u7eb3", (String)"SouCompareAuditOp_4", (String)"scm-sou-opplugin", (Object[])new Object[0]);
                    } else if ("D".equals(bizstatus)) {
                        adoptStatus = ResManager.loadKDString((String)"\u90e8\u5206\u91c7\u7eb3", (String)"SouCompareAuditOp_5", (String)"scm-sou-opplugin", (Object[])new Object[0]);
                    }
                } else {
                    adoptStatus = ResManager.loadKDString((String)"\u672a\u91c7\u7eb3", (String)"SouCompareAuditOp_6", (String)"scm-sou-opplugin", (Object[])new Object[0]);
                }
                this.beforeSendMessage(entrysupplier, quoteDO, quoInquiryDO, adoptStatus, compareBill);
                DynamicObject[] souQuoteDyns = BusinessDataServiceHelper.load((String)"sou_quote", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)quoteBillNo)});
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                if ("C".equals(bizstatus) || "D".equals(bizstatus)) {
                    OperationServiceHelper.executeOperate((String)"sendmsgtoadopt", (String)"sou_quote", (DynamicObject[])new DynamicObject[]{souQuoteDyns[0]}, (OperateOption)option);
                }
                if (!"E".equals(bizstatus)) continue;
                OperationServiceHelper.executeOperate((String)"sendmsgtounadopt", (String)"sou_quote", (DynamicObject[])new DynamicObject[]{souQuoteDyns[0]}, (OperateOption)option);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouCompareValidator());
    }
}

