/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scm.common.util.CommonUtil;
import kd.scm.sou.common.WriteBackUtil;

public class SouCompareBillDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "materialentry";
    private static final String QTY = "qty";
    private static final String SUM_COMPAREQTY = "sumcompareqty";
    private static final String SRCBILLTYPE = "srcbilltype";
    private static final String SRCBILLID = "srcbillid";
    private static final String SRCENTRYID = "srcentryid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("materialentry.qty");
        filds.add("inquiryno");
        filds.add("materialentry.srcbilltype");
        filds.add("materialentry.srcbillid");
        filds.add("materialentry.srcentryid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] compareObjs = e.getDataEntities();
        if ("delete".equalsIgnoreCase(key)) {
            if (compareObjs.length == 0) {
                e.cancel = true;
                return;
            }
            this.writeBackSrcBill(compareObjs, ENTRYENTITY, "");
        }
    }

    private void writeBackSrcBill(DynamicObject[] compareObjs, String entryKey, String suffix) {
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> sumCompareQtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject compareObj : compareObjs) {
            DynamicObjectCollection entrys = compareObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                String srcEntryIdStr = entry.getString(SRCENTRYID + suffix);
                if (srcEntryIdStr == null || srcEntryIdStr.trim().isEmpty()) continue;
                Long srcEntryId = Long.valueOf(srcEntryIdStr);
                entryIdList.add(srcEntryId);
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get(QTY + suffix));
                if (sumCompareQtyMap.get(srcEntryIdStr) != null) {
                    sumCompareQtyMap.put(srcEntryIdStr, qty.add((BigDecimal)sumCompareQtyMap.get(String.valueOf(srcEntryId))));
                    continue;
                }
                sumCompareQtyMap.put(srcEntryIdStr, qty);
            }
            if (entrys.size() <= 0) continue;
            HashMap writeBackProMap = new HashMap(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add(SUM_COMPAREQTY);
            writeBackProMap.put(ENTRYENTITY, proList);
            WriteBackUtil.writeBackBill((String)"sou_quote", writeBackProMap, entryIdList, sumCompareQtyMap, (String)"delete");
        }
    }
}

