/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.ApiUtil;

public class SouCompareBillToContractPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("materialentry.qty");
        filds.add("materialentry.taxamount");
        filds.add("materialentry.taxrate");
        filds.add("materialentry.srcbillid");
        filds.add("materialentry.srcentryid");
        filds.add("org");
        filds.add("paycond");
        filds.add("curr");
        filds.add("loccurr");
        filds.add("person");
        filds.add("taxtype");
        filds.add("settletype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        String entityType = null;
        if (objs.length == 0) {
            return;
        }
        entityType = objs[0].getDataEntityType().getName();
        Map<String, Map<String, Object>> billInfoMap = this.getBillParam(objs);
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("data", billInfoMap);
            this.sendData(param, entityType);
        }
    }

    private void sendData(Map<String, Object> param, String entityType) {
        String msg;
        if (param.isEmpty()) {
            return;
        }
        param.put("billtype", entityType);
        param.put("action", "toOrder");
        param.put("code", "200");
        if (!entityType.equals("sou_compare") || (msg = ApiUtil.souCompareToContract(param)).isEmpty()) {
            // empty if block
        }
    }

    private Map<String, Map<String, Object>> getBillParam(DynamicObject[] objs) {
        HashMap<String, Map<String, Object>> billMap = new HashMap<String, Map<String, Object>>((int)((double)objs.length / 0.75));
        Map<Object, Object> detailMap = new HashMap();
        for (DynamicObject obj : objs) {
            detailMap = this.getParam(obj);
            String billIdStr = String.valueOf(obj.getPkValue());
            billMap.put(billIdStr, detailMap);
        }
        return billMap;
    }

    private Map<String, Object> getParam(DynamicObject bill) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection("materialentry");
        DynamicObject[] srcBillObjs = this.querySrcBillInfo(entryCols, "materialentry");
        if (srcBillObjs.length == 0) {
            // empty if block
        }
        this.setHeadParam(paramMap, bill);
        HashMap billMap = new HashMap();
        for (DynamicObject entryCol : entryCols) {
            String entryIdStr = String.valueOf(entryCol.getPkValue());
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            String srcBillEntryId = entryCol.getString("srcentryid");
            String srcBillId = entryCol.getString("srcbillid");
            DynamicObject supplier = entryCol.getDynamicObject("supplier");
            entryMap.put("supplier", supplier == null ? "" : supplier.getString("number"));
            entryMap.put("confirmqty", entryCol.get("qty"));
            entryMap.put("price", entryCol.get("price"));
            entryMap.put("confirmtaxprice", entryCol.get("taxprice"));
            entryMap.put("taxrate", entryCol.get("taxrate"));
            DynamicObject srcObjEntry = this.getSrcBillEntry(srcBillObjs, srcBillId, srcBillEntryId);
            if (null == srcBillEntryId || srcObjEntry == null) continue;
            String srcBid = srcObjEntry.getString("srcbillid");
            String srcBeid = srcObjEntry.getString("srcentryid");
            entryMap.put("srcbillid", srcBid);
            entryMap.put("srcbillentryid", srcBeid);
            billMap.put(entryIdStr, entryMap);
        }
        paramMap.put("entry", billMap);
        return paramMap;
    }

    private void setHeadParam(Map<String, Object> headMap, DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        headMap.put("purorg", org == null ? "" : org.getString("number"));
        DynamicObject curr = bill.getDynamicObject("curr");
        headMap.put("settlecurr", curr == null ? "" : curr.getString("number"));
        DynamicObject loccurr = bill.getDynamicObject("loccurr");
        headMap.put("localcurr", loccurr == null ? "" : loccurr.getString("number"));
        DynamicObject payCond = bill.getDynamicObject("paycond");
        headMap.put("paycond", payCond == null ? "" : payCond.getString("number"));
        DynamicObject person = bill.getDynamicObject("person");
        headMap.put("purperson", person == null ? "" : person.getString("number"));
        String taxType = bill.getString("taxtype");
        headMap.put("taxtype", taxType);
        DynamicObject settleType = bill.getDynamicObject("settletype");
        headMap.put("settletype", settleType == null ? "" : settleType.getString("number"));
    }

    private DynamicObject[] querySrcBillInfo(DynamicObjectCollection entryCol, String entryEntity) {
        DynamicObject[] dynamicObjects = null;
        String selectFields = "id,billno,materialentry.id,materialentry.srcbillid,materialentry.srcentryid";
        HashMap paramMap = new HashMap();
        HashMap<String, Set<Object>> idMap = new HashMap<String, Set<Object>>();
        idMap.put("in", this.getIdList(entryCol, entryEntity));
        paramMap.put("id", idMap);
        dynamicObjects = ORMUtil.query((String)"sou_quote", (String)selectFields, paramMap);
        return dynamicObjects;
    }

    private Set<Object> getIdList(DynamicObjectCollection entryCol, String entryEntity) {
        HashSet<Object> idList = new HashSet<Object>();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbi = null;
            sb = entry.get("srcbillid");
            sbi = entry.get("srcentryid");
            if (sbi == null || sbi.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            Long srcBillId = Long.valueOf(sb.toString());
            idList.add(srcBillId);
        }
        return idList;
    }

    private DynamicObject getSrcBillEntry(DynamicObject[] srcBillObjs, Object srcBillId, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String billId = String.valueOf(srcBill.getPkValue());
            if (!srcBillId.equals(billId)) continue;
            DynamicObjectCollection entryCols = srcBill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryCol : entryCols) {
                String billEntryId = String.valueOf(entryCol.getPkValue());
                if (!srcBillEntryId.equals(billEntryId)) continue;
                return entryCol;
            }
        }
        return entry;
    }
}

