/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.sou.opplugin.validator.SouCompareSubmitValidator;

public class SouCompareSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String INQUIRY_NO = "inquiryno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("datefrom");
        e.getFieldKeys().add("dateto");
        e.getFieldKeys().add("delidate");
        e.getFieldKeys().add("pushresult");
        e.getFieldKeys().add(INQUIRY_NO);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>(128);
        HashSet<String> existInquirynos = new HashSet<String>(1024);
        ArrayList<String> status = new ArrayList<String>(2);
        status.add(BillStatusEnum.SUBMIT.getVal());
        status.add(BillStatusEnum.AUDIT.getVal());
        QFilter filter = new QFilter("billstatus", "in", status);
        DynamicObjectCollection inquiryBillColl = QueryServiceHelper.query((String)"sou_compare", (String)INQUIRY_NO, (QFilter[])new QFilter[]{filter});
        inquiryBillColl.forEach(inquiryBill -> existInquirynos.add(inquiryBill.getString(INQUIRY_NO)));
        List validExtDataEntities = e.getValidExtDataEntities();
        validExtDataEntities.sort(Comparator.comparing(ExtendedDataEntity::getBillNo).reversed());
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            DynamicObject dynamicObject = validExtDataEntity.getDataEntity();
            String inquiryno = dynamicObject.getString(INQUIRY_NO);
            if (inquiryno != null && !"".equals(inquiryno) && existInquirynos.contains(inquiryno)) {
                Object pkId = validExtDataEntity.getDataEntity().getPkValue();
                int dataIndex = validExtDataEntity.getDataEntityIndex();
                String billNo = dynamicObject.getString("billno");
                String content = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u68c0\u67e5\u5bf9\u5e94\u8be2\u4ef7\u5355\u662f\u5426\u5df2\u6709\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6bd4\u4ef7\u5355\u3002", (String)"SouCompareSubmitOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]), billNo);
                ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, 0, "QuoteAuditOp", "", content, ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
                continue;
            }
            passDataEntitys.add(validExtDataEntity);
            existInquirynos.add(inquiryno);
        }
        e.getValidExtDataEntities().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getValidExtDataEntities().addAll(passDataEntitys);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dyns;
        for (DynamicObject dyn : dyns = e.getDataEntities()) {
            String pushresult = dyn.getString("pushresult");
            if ("1".equals(pushresult)) continue;
            dyn.set("pushresult", (Object)"0");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouCompareSubmitValidator());
    }
}

