/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.ApiConfigUtil;

public class SouInquiryImportOp
extends BatchImportPlugin {
    private static final int MUST_INPUT_IDX = 0;
    private static final int BASE_PROP_IDX = 1;
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";

    public List<ComboItem> getOverrideFieldsConfig() {
        String billFormId = this.getBillFormId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        Field field = entityMetadata.getFieldByKey("billno");
        DynamicProperty dynamicProperty = entityType.getProperty("billno");
        if (StringUtils.equals((CharSequence)field.getKey(), (CharSequence)dynamicProperty.getName())) {
            items.add(new ComboItem(dynamicProperty.getDisplayName(), dynamicProperty.getName()));
        }
        return items;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.validateMaterialUnit(rowdatas, logger);
        if (!rowdatas.isEmpty()) {
            Map<String, String[]> requireFields = this.getEntryRequireFields(rowdatas);
            this.validateTaxType(rowdatas, logger);
            this.validateNullData(rowdatas, logger, requireFields);
        }
        return super.save(rowdatas, logger);
    }

    private Map<String, String[]> getEntryRequireFields(List<ImportBillData> rowdatas) {
        ImportEntityMapping entityMapping = rowdatas.get(0).getEntityMapping();
        Map entryCols = ((ImportEntityMapping)entityMapping.getEntries().get("materialentry")).getCols();
        HashMap<String, String[]> requireFields = new HashMap<String, String[]>((int)((double)entryCols.size() / 0.75));
        for (Map.Entry entry : entryCols.entrySet()) {
            requireFields.put((String)entry.getKey(), new String[]{String.valueOf(((ImportEntityMapping.ColInfo)entry.getValue()).isMustInput()), ((ImportEntityMapping.ColInfo)entry.getValue()).getBasedataProp()});
        }
        if (!requireFields.containsKey("unit")) {
            requireFields.put("unit", new String[]{FALSE_STRING, ""});
        }
        return requireFields;
    }

    private void validateTaxType(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (!ApiConfigUtil.hasEASConfig()) {
            Iterator<ImportBillData> iterator = rowdatas.iterator();
            while (iterator.hasNext()) {
                ImportBillData rowdata = iterator.next();
                int row = rowdata.getStartIndex();
                JSONObject data = rowdata.getData();
                String taxType = (String)data.get((Object)"taxtype");
                if (!TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) continue;
                logger.log(Integer.valueOf(row), ResManager.loadKDString((String)"\u4ef7\u5185\u7a0e\uff08\u542b\u7a0e\uff09\u4e0d\u662f\u5408\u6cd5\u8f93\u5165\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7a0e\u7c7b\u578b\u3002", (String)"SouInquiryImportOp_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                logger.fail();
                iterator.remove();
            }
        }
    }

    private void validateNullData(List<ImportBillData> rowdatas, ImportLogger logger, Map<String, String[]> requireFields) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            boolean fail = false;
            ImportBillData rowdata = iterator.next();
            int row = rowdata.getStartIndex();
            JSONObject data = rowdata.getData();
            JSONArray array = (JSONArray)data.get((Object)"materialentry");
            for (Object entryObj : array) {
                JSONObject unitObj;
                JSONObject jsonObj = (JSONObject)entryObj;
                JSONObject materialObj = (JSONObject)jsonObj.get((Object)"material");
                if (materialObj == null || materialObj.getString("number") == null) {
                    logger.log(Integer.valueOf(row), ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u3002", (String)"SouInquiryImportOp_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    fail = true;
                }
                if (TRUE_STRING.equals(requireFields.get("unit")[0]) && ((unitObj = (JSONObject)jsonObj.get((Object)"unit")) == null || unitObj.getString(requireFields.get("unit")[1]) == null)) {
                    logger.log(Integer.valueOf(row), ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SouInquiryImportOp_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    fail = true;
                }
                ++row;
            }
            if (!fail) continue;
            logger.fail();
            iterator.remove();
        }
    }

    private Map<Integer, String[]> queryExcelData(List<ImportBillData> rowdatas, Map<String, String[]> requireFields) {
        HashMap<Integer, String[]> excelMap = new HashMap<Integer, String[]>(1024);
        for (ImportBillData rowdata : rowdatas) {
            int row = rowdata.getStartIndex();
            JSONObject data = rowdata.getData();
            JSONArray array = (JSONArray)data.get((Object)"materialentry");
            for (Object entryObj : array) {
                JSONObject jsonObj = (JSONObject)entryObj;
                String key = ((JSONObject)jsonObj.get((Object)"material")).getString("number");
                String value = "";
                if (jsonObj.get((Object)"unit") != null) {
                    value = ((JSONObject)jsonObj.get((Object)"unit")).getString(requireFields.get("unit")[1]);
                }
                excelMap.put(row++, new String[]{key, value});
            }
        }
        return excelMap;
    }

    private Map<String, String> querySystemData(Map<Integer, String[]> excelMap, Map<String, String[]> requireFields) {
        int materialIdx = 0;
        int unitIdx = 1;
        HashSet itemNum = new HashSet(1024);
        excelMap.forEach((k, v) -> itemNum.add(v[materialIdx]));
        HashMap<String, String> itemMap = new HashMap<String, String>((int)((double)itemNum.size() / 0.75));
        QFilter[] itemFilter = new QFilter[]{new QFilter("number", "in", itemNum)};
        DynamicObjectCollection bdMaterialDC = QueryServiceHelper.query((String)"bd_material", (String)"id,number,baseunit.number,baseunit.name", (QFilter[])itemFilter);
        for (DynamicObject dynamicObject : bdMaterialDC) {
            String number = dynamicObject.getString("number");
            String baseunit = "number".equals(requireFields.get("unit")[1]) ? dynamicObject.getString("baseunit.number") : dynamicObject.getString("baseunit.name");
            itemMap.put(number, baseunit);
        }
        if (TRUE_STRING.equals(requireFields.get("unit")[0])) {
            HashSet unitNum = new HashSet(1024);
            excelMap.forEach((k, v) -> unitNum.add(v[unitIdx]));
            QFilter[] unitFilters = new QFilter[]{new QFilter(requireFields.get("unit")[1], "in", unitNum)};
            DynamicObjectCollection bdUnitDC = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,number,name", (QFilter[])unitFilters);
            Iterator<Map.Entry<Integer, String[]>> entryIterator = excelMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                String unitStr = entryIterator.next().getValue()[unitIdx];
                boolean exist = false;
                for (DynamicObject unitObj : bdUnitDC) {
                    if (!unitStr.equals(unitObj.getString(requireFields.get("unit")[1]))) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                entryIterator.remove();
            }
        }
        return itemMap;
    }

    private void compareData(List<ImportBillData> rowdatas, ImportLogger logger, Map<String, String[]> requireFields, Map<Integer, String[]> excelMap, Map<String, String> itemMap) {
        int unitIdx = 1;
        Iterator<ImportBillData> iterator2 = rowdatas.iterator();
        while (iterator2.hasNext()) {
            boolean fail = false;
            ImportBillData rowdata = iterator2.next();
            int row = rowdata.getStartIndex();
            JSONObject data = rowdata.getData();
            JSONArray array = (JSONArray)data.get((Object)"materialentry");
            for (Object entryObj : array) {
                JSONObject jsonObj = (JSONObject)entryObj;
                String key = ((JSONObject)jsonObj.get((Object)"material")).getString("number");
                if (FALSE_STRING.equals(requireFields.get("unit")[0]) && "".equals(excelMap.get(row)[unitIdx])) {
                    JSONObject unitObj = new JSONObject();
                    unitObj.put("importprop", (Object)requireFields.get("unit")[1]);
                    unitObj.put(requireFields.get("unit")[1], (Object)itemMap.get(key));
                    jsonObj.put("unit", (Object)unitObj);
                } else {
                    String itemValue;
                    String value = ((JSONObject)jsonObj.get((Object)"unit")).getString(requireFields.get("unit")[1]);
                    if (!value.equals(itemValue = itemMap.get(key)) && excelMap.containsKey(row)) {
                        logger.log(Integer.valueOf(row), ResManager.loadKDString((String)"\u5355\u4f4d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SouInquiryImportOp_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                        fail = true;
                    }
                }
                ++row;
            }
            if (!fail) continue;
            logger.fail();
            iterator2.remove();
        }
    }

    private void validateMaterialUnit(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            boolean success = true;
            HashSet<String> materialNos = new HashSet<String>(1024);
            HashMap<Object, String> unitMap = new HashMap<Object, String>(1024);
            JSONArray array = (JSONArray)data.get((Object)"materialentry");
            for (Object entryObj : array) {
                JSONObject jsonObj = (JSONObject)entryObj;
                String materialNo = ((JSONObject)jsonObj.get((Object)"material")).getString("number");
                materialNos.add(materialNo);
            }
            HashSet<String> disableMaterials = new HashSet<String>(1024);
            HashSet<String> disableUnits = new HashSet<String>(1024);
            HashSet<Object> statusMaterials = new HashSet<Object>(1024);
            QFilter materialFilter = new QFilter("number", "in", materialNos);
            DynamicObjectCollection sysMaterials = QueryServiceHelper.query((String)"bd_material", (String)"number,baseunit.number,baseunit.name,enable,status", (QFilter[])new QFilter[]{materialFilter});
            materialNos.clear();
            for (DynamicObject sysMaterial : sysMaterials) {
                String materialNo = sysMaterial.getString("number");
                if ("0".equals(sysMaterial.getString("enable"))) {
                    disableMaterials.add(materialNo);
                }
                materialNos.add(materialNo);
                if (!"C".equals(sysMaterial.getString("status"))) {
                    statusMaterials.add(materialNo);
                }
                unitMap.put(materialNo, sysMaterial.getString("baseunit.number"));
            }
            QFilter unitFilter = new QFilter("number", "in", unitMap.values());
            DynamicObjectCollection sysUnits = QueryServiceHelper.query((String)"bd_measureunits", (String)"number, enable,status", (QFilter[])new QFilter[]{unitFilter});
            for (DynamicObject sysUnit : sysUnits) {
                if (!"0".equals(sysUnit.getString("enable"))) continue;
                disableUnits.add(sysUnit.getString("number"));
            }
            JSONArray jsonArray = (JSONArray)data.get((Object)"materialentry");
            for (Object obj : jsonArray) {
                String unitNo;
                JSONObject jsonObj = (JSONObject)obj;
                String materialNo = ((JSONObject)jsonObj.get((Object)"material")).getString("number");
                if (!materialNos.contains(materialNo)) {
                    success = false;
                    logger.log(Integer.valueOf(rowdata.getStartIndex()), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u7269\u6599\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002", (String)"SouInquiryImportOp_7", (String)"scm-sou-opplugin", (Object[])new Object[0]), materialNo));
                    continue;
                }
                if (disableMaterials.contains(materialNo)) {
                    success = false;
                    logger.log(Integer.valueOf(rowdata.getStartIndex()), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u7269\u6599\u201c{0}\u201d\u4e0d\u53ef\u7528\u3002", (String)"SouInquiryImportOp_4", (String)"scm-sou-opplugin", (Object[])new Object[0]), materialNo));
                }
                if (statusMaterials.contains(materialNo)) {
                    success = false;
                    logger.log(Integer.valueOf(rowdata.getStartIndex()), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u7269\u6599\u201c{0}\u201d\u672a\u5ba1\u6838\u3002", (String)"SouInquiryImportOp_6", (String)"scm-sou-opplugin", (Object[])new Object[0]), materialNo));
                }
                if (!disableUnits.contains(unitNo = (String)unitMap.get(materialNo))) continue;
                success = false;
                logger.log(Integer.valueOf(rowdata.getStartIndex()), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u7684\u7269\u6599\u201c{0}\u201d\u7684\u57fa\u672c\u5355\u4f4d\u201c{1}\u201d\u4e0d\u53ef\u7528\u3002", (String)"SouInquiryImportOp_5", (String)"scm-sou-opplugin", (Object[])new Object[0]), materialNo, unitNo));
            }
            if (success) continue;
            logger.fail();
            iterator.remove();
        }
    }
}

