/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.sou.opplugin.validator.SouInquiryOpenBidValidator;

public class SouInquiryOpenBidOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SouInquiryOpenBidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("bizstatus");
        fieldKeys.add("enddate");
        fieldKeys.add("opener");
        fieldKeys.add("opendate");
        fieldKeys.add("quotenum");
        fieldKeys.add("minsumamount");
        fieldKeys.add("minsupplier");
        fieldKeys.add("maxsumamount");
        fieldKeys.add("maxsupplier");
        fieldKeys.add("avgsumamount");
        fieldKeys.add("opentype");
        fieldKeys.add("entryentity.supentrystatus");
        fieldKeys.add("entryentity.quotedate");
        fieldKeys.add("entryentity.canshow");
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("supquonum");
        fieldKeys.add("materialentry.srcentryid");
        fieldKeys.add("materialentry.id");
        fieldKeys.add("materialentry.validnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SouInquiryOpenBidValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List validExtDataEntities = e.getValidExtDataEntities();
        DynamicObject dynamicObject = null;
        DynamicObjectCollection supplierColl = null;
        ArrayList<String> inquiryBillNoList = new ArrayList<String>(validExtDataEntities.size());
        ArrayList<Long> pkIds = new ArrayList<Long>(validExtDataEntities.size());
        ArrayList<DynamicObject> needDealInquiryBill = new ArrayList<DynamicObject>(validExtDataEntities.size());
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            String billNo = extendedDataEntity.getBillNo();
            dynamicObject = extendedDataEntity.getDataEntity();
            pkIds.add(dynamicObject.getLong("id"));
            needDealInquiryBill.add(dynamicObject);
            inquiryBillNoList.add(billNo);
            dynamicObject.set("bizstatus", (Object)BizStatusEnum.OPENEDTHEBID.getVal());
            dynamicObject.set("opener", (Object)RequestContext.get().getUserId());
            dynamicObject.set("opendate", (Object)TimeServiceHelper.now());
            supplierColl = dynamicObject.getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection dataEntityPropertyCollection = supplierColl.getDynamicObjectType().getProperties();
            DynamicProperty supEntryStatus = (DynamicProperty)dataEntityPropertyCollection.get((Object)"supentrystatus");
            for (DynamicObject supplierRow : supplierColl) {
                Object supplierEntryStatus = supEntryStatus.getValueFast((Object)supplierRow);
                if (!InquirySupParticipateUtils.isShowSelect((DynamicObject)supplierRow) || !SupInquiryStatusEnum.QUOTEDPRICE.getVal().equals(supplierEntryStatus.toString())) continue;
                supplierRow.set("supentrystatus", (Object)SupInquiryStatusEnum.OPENEDTHEBID.getVal());
            }
        }
        if (inquiryBillNoList.size() > 0) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u4e2d" + pkIds);
            DynamicObject[] quoteBillObjs = InquiryUtil.getQuoteBillByInquiryBillNo(inquiryBillNoList);
            this.updateQuoteBill(quoteBillObjs, pkIds);
            InquiryUtil.updateInquiryBill((DynamicObject[])needDealInquiryBill.toArray(new DynamicObject[0]), (DynamicObject[])quoteBillObjs);
        }
    }

    private void updateQuoteBill(DynamicObject[] quoteBillObjs, List<Long> pkIds) {
        if (quoteBillObjs.length == 0) {
            return;
        }
        for (DynamicObject quoteBill : quoteBillObjs) {
            quoteBill.set("bizstatus", (Object)BizStatusEnum.OPENEDTHEBID.getVal());
        }
        log.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u4e2d,\u5904\u7406\u62a5\u4ef7\u5355\u6570\u636e" + pkIds);
        SaveServiceHelper.save((IDataEntityType)quoteBillObjs[0].getDynamicObjectType(), (Object[])quoteBillObjs);
    }

    public void setContext(MainEntityType billEntityType, Map<String, Object> operateMeta, OperateOption option) {
        if ("false".equals(option.getVariableValue("writeLog", "true"))) {
            operateMeta.put("logEnable", false);
        } else {
            operateMeta.put("logEnable", true);
        }
        super.setContext(billEntityType, operateMeta, option);
    }
}

