/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class SouBidSubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (preparePropertys == null) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("checkperm");
        return preparePropertys;
    }

    public void validate() {
        HashMap<Long, Integer> cacheMap = new HashMap<Long, Integer>(1024);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObjectCollection rows;
            boolean checkperm;
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            String biztype = dynamicObject.getString("biztype");
            String billstatus = dynamicObject.getString("billstatus");
            int bidnumber = dynamicObject.getInt("bidnumber");
            Date delidate1 = dynamicObject.getDate("delidate1");
            Date resultdate = dynamicObject.getDate("resultdate");
            Date enrolldate = dynamicObject.getDate("enrolldate");
            if (!billstatus.equals("A")) continue;
            if (enrolldate == null || enrolldate.before(TimeServiceHelper.now())) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SouBidSubmitValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            }
            if (delidate1 != null && delidate1.before(resultdate)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4ea4\u8d27\u65e5\u671f\u5e94\u665a\u4e8e\u516c\u5e03\u7ed3\u679c\u65f6\u95f4\u3002", (String)"SouBidSubmitValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            }
            if (checkperm = dynamicObject.getBoolean("checkperm")) {
                this.validateRule(cacheMap, rowDataEntity);
            }
            if (!biztype.equals("2") || (rows = dynamicObject.getDynamicObjectCollection("supquoentry")) != null && rows.size() >= bidnumber) continue;
            this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u4e0d\u5e94\u5c0f\u4e8e{0}\u5bb6\u3002", (String)"SouBidSubmitValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]), bidnumber));
        }
    }

    protected void validateRule(Map<Long, Integer> infoMap, ExtendedDataEntity rowDataEntity) {
        DynamicObject inquiry = rowDataEntity.getDataEntity();
        String supscope = inquiry.getString("biztype");
        DynamicObjectCollection info = inquiry.getDynamicObjectCollection("supquoentry");
        if ("2".equals(supscope)) {
            int i = 0;
            if (info != null) {
                for (DynamicObject dynamicObject : info) {
                    long supplierId = dynamicObject.getLong("entrysupplier_id");
                    ++i;
                    if (supplierId == 0L) continue;
                    Integer rule = infoMap.get(supplierId);
                    if (rule != null && rule.equals(0)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u7ade\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u7ade\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouInquirySubmitValidator_11", (String)"scm-sou-opplugin", (Object[])new Object[0]), i, dynamicObject.getString("entrysupplier.name"), inquiry.getString("org.name")));
                    }
                    Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)supplierId);
                    HashSet<Long> set = new HashSet<Long>(1);
                    set.add(bizPartnerId);
                    List supUserIds = BizPartnerUtil.getSupEnableUserIdsByBizPartner(set);
                    boolean flag = false;
                    if (supUserIds.size() > 0) {
                        for (Long supUserId : supUserIds) {
                            rule = PermissionServiceHelper.checkPermission((Long)supUserId, (Long)inquiry.getLong("org.id"), (String)"SE7/UZFDVIE", (String)"quo_bidbill", (String)"47150e89000000ac");
                            if (rule == null || !rule.equals(1)) continue;
                            infoMap.put(supplierId, rule);
                            flag = true;
                            break;
                        }
                    }
                    if (flag) continue;
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u7ade\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u7ade\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouInquirySubmitValidator_11", (String)"scm-sou-opplugin", (Object[])new Object[0]), i, dynamicObject.getString("entrysupplier.name"), inquiry.getString("org.name")));
                }
            }
        }
    }
}

