/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SouOpenTypeEnum;

public class SouInquiryOpenBidValidator
extends AbstractValidator {
    public void validate() {
        Object bizStatus = null;
        Object billStatus = null;
        Object endDate = null;
        String openType = null;
        DynamicObject dynamicObject = null;
        DynamicObjectCollection col = null;
        boolean flag = false;
        boolean isSupplier = false;
        this.setOperationName(ResManager.loadKDString((String)"\u5f00\u6807", (String)"SouInquiryOpenBidValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            flag = false;
            StringBuilder inquiryMsg = new StringBuilder();
            dynamicObject = rowDataEntity.getDataEntity();
            bizStatus = dynamicObject.get("bizstatus");
            billStatus = dynamicObject.get("billstatus");
            endDate = dynamicObject.get("enddate");
            openType = dynamicObject.getString("opentype");
            col = dynamicObject.getDynamicObjectCollection("entryentity");
            if (!"".equals(bizStatus) && "E".equals(bizStatus.toString())) {
                inquiryMsg.append(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u4e0d\u80fd\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                flag = true;
            } else {
                if (billStatus == null || !"C".equals(billStatus.toString())) {
                    inquiryMsg.append(ResManager.loadKDString((String)"\u9879\u76ee\u672a\u5ba1\u6838", (String)"SouInquiryOpenBidValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    flag = true;
                }
                if (!"".equals(bizStatus) && !"A".equals(bizStatus.toString())) {
                    if (inquiryMsg.length() > 0) {
                        inquiryMsg.append("\u3001");
                        inquiryMsg.append(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5f00\u6807\uff0c\u65e0\u9700\u91cd\u590d\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    } else {
                        inquiryMsg.append(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5f00\u6807\uff0c\u65e0\u9700\u91cd\u590d\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_4", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    flag = true;
                }
                if ((SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal().equals(openType) || SouOpenTypeEnum.INVISIBLE_AUTOOPEN.getVal().equals(openType)) && (endDate == null || TimeServiceHelper.now().before((Date)endDate))) {
                    if (inquiryMsg.length() > 0) {
                        inquiryMsg.append("\u3001");
                        inquiryMsg.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5230\u8fbe\u540e\u4f1a\u81ea\u52a8\u5f00\u6807\uff0c\u4e0d\u9700\u8981\u624b\u52a8\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_7", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    } else {
                        inquiryMsg.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5230\u8fbe\u540e\u4f1a\u81ea\u52a8\u5f00\u6807\uff0c\u4e0d\u9700\u8981\u624b\u52a8\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    flag = true;
                }
                if ((SouOpenTypeEnum.INVISIBLE_MANUALOPEN.getVal().equals(openType) || SouOpenTypeEnum.VISIBLE_MANUALOPEN.getVal().equals(openType)) && (endDate == null || TimeServiceHelper.now().before((Date)endDate))) {
                    if (inquiryMsg.length() > 0) {
                        inquiryMsg.append("\u3001");
                        inquiryMsg.append(ResManager.loadKDString((String)"\u672a\u5230\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u80fd\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_5", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    } else {
                        inquiryMsg.append(ResManager.loadKDString((String)"\u672a\u5230\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u80fd\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_6", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    flag = true;
                }
                for (DynamicObject obj : col) {
                    if (obj.getDate("quotedate") == null) continue;
                    isSupplier = true;
                    break;
                }
                if (!isSupplier) {
                    if (inquiryMsg.length() > 0) {
                        inquiryMsg.append("");
                    } else {
                        inquiryMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_9", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    flag = true;
                }
                if (this.getQuoteByInquiryNo(rowDataEntity.getDataEntity()).size() == 0) {
                    if (inquiryMsg.length() == 0) {
                        inquiryMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u7684\u62a5\u4ef7\u5355\uff0c\u4e0d\u5141\u8bb8\u5f00\u6807\u3002", (String)"SouInquiryOpenBidValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                    }
                    flag = true;
                }
            }
            if (!flag) continue;
            this.addErrorMessage(rowDataEntity, inquiryMsg.toString());
        }
    }

    public DynamicObjectCollection getQuoteByInquiryNo(DynamicObject inquiryDyn) {
        List<QFilter> filters = this.buildCondition(inquiryDyn);
        return QueryServiceHelper.query((String)"sou_quote", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
    }

    public List<QFilter> buildCondition(DynamicObject inquiryDyn) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Long org = inquiryDyn.getLong("org.id");
        if (null != org) {
            QFilter orgFilter = new QFilter("org", "=", (Object)org);
            filters.add(orgFilter);
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter billnoFilter = new QFilter("inquiryno", "=", (Object)inquiryDyn.getString("billno"));
        QFilter entryStatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
        filters.add(statusFilter);
        filters.add(billnoFilter);
        filters.add(entryStatusFilter);
        return filters;
    }
}

