/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sou.opplugin.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class SouInquirySubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (preparePropertys == null) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("checkperm");
        return preparePropertys;
    }

    public void validate() {
        HashMap<Long, Integer> cacheMap = new HashMap<Long, Integer>(1024);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String supcurrtype;
            DynamicObject inquiryBillObject = rowDataEntity.getDataEntity();
            String billstatus = inquiryBillObject.getString("billstatus");
            Date endDate = inquiryBillObject.getDate("enddate");
            Date datefrom = inquiryBillObject.getDate("datefrom");
            Date dateto = inquiryBillObject.getDate("dateto");
            Date delidate = inquiryBillObject.getDate("delidate");
            Date enddate = inquiryBillObject.getDate("enddate");
            String supscope = inquiryBillObject.getString("supscope");
            this.setOperationName(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"SouInquirySubmitValidator_0", (String)"scm-sou-opplugin", (Object[])new Object[0]));
            DynamicObjectCollection col = inquiryBillObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection materialentryUnit = inquiryBillObject.getDynamicObjectCollection("materialentry");
            if ("A".equals(billstatus)) {
                if (endDate == null || endDate.before(TimeServiceHelper.now())) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SouInquirySubmitValidator_1", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
                if (datefrom != null && dateto != null && datefrom.after(dateto)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4ef7\u683c\u6709\u6548\u671f\u81f3\u4e0d\u80fd\u65e9\u4e8e\u201c\u4ef7\u683c\u6709\u6548\u671f\u4ece\u201d\u3002", (String)"SouInquirySubmitValidator_2", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
                if (delidate != null && enddate != null && delidate.before(enddate)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4ea4\u8d27\u65e5\u671f\u5e94\u665a\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u3002", (String)"SouInquirySubmitValidator_3", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
                if ("2".equals(supscope) && col.size() <= 0) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be2\u4ef7\u8303\u56f4\u4e3a\u201c\u6307\u5b9a\u4f9b\u5e94\u5546\u201d\u65f6\uff0c\u53c2\u4e0e\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SouInquirySubmitValidator_4", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
            }
            if (!"1".equals(supcurrtype = inquiryBillObject.getString("supcurrtype"))) {
                DynamicObject exchtype = inquiryBillObject.getDynamicObject("exchtype");
                Date ratedate = inquiryBillObject.getDate("ratedate");
                if (exchtype == null) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0d\u6309\u7167\u8be2\u4ef7\u5355\u7ed3\u7b97\u5e01\u62a5\u4ef7\u65f6\uff0c\u6c47\u7387\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SouInquirySubmitValidator_7", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
                if (ratedate == null) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0d\u6309\u7167\u8be2\u4ef7\u5355\u7ed3\u7b97\u5e01\u62a5\u4ef7\u65f6\uff0c\u6c47\u7387\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SouInquirySubmitValidator_8", (String)"scm-sou-opplugin", (Object[])new Object[0]));
                }
            }
            ArrayList unitIds = new ArrayList(materialentryUnit.size());
            materialentryUnit.forEach(row -> unitIds.add(row.getLong("unit_id")));
            QFilter qFilter = new QFilter("id", "in", unitIds);
            DynamicObjectCollection sysUnits = QueryServiceHelper.query((String)"bd_measureunits", (String)"id, enable", (QFilter[])new QFilter[]{qFilter});
            HashMap sysUnitMap = new HashMap(materialentryUnit.size());
            sysUnits.forEach(unit -> sysUnitMap.put(unit.getLong("id"), unit.getString("enable")));
            boolean checkperm = inquiryBillObject.getBoolean("checkperm");
            if (checkperm) {
                this.validateRule(cacheMap, rowDataEntity);
            }
            for (int i = 0; i < unitIds.size(); ++i) {
                Long unitId = (Long)unitIds.get(i);
                if (!sysUnitMap.containsKey(unitId)) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6ca1\u6709\u8fd9\u4e2a\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SouInquirySubmitValidator_5", (String)"scm-sou-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (!"0".equals(sysUnitMap.get(unitId))) continue;
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c\u884c%1$s\uff0c\u8ba1\u91cf\u5355\u4f4d\u5df2\u88ab\u7981\u7528\u3002", (String)"SouInquirySubmitValidator_6", (String)"scm-sou-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }

    protected void validateRule(Map<Long, Integer> infoMap, ExtendedDataEntity rowDataEntity) {
        DynamicObject inquiry = rowDataEntity.getDataEntity();
        String supscope = inquiry.getString("supscope");
        DynamicObjectCollection info = inquiry.getDynamicObjectCollection("entryentity");
        if ("2".equals(supscope)) {
            int i = 0;
            if (info != null) {
                for (DynamicObject dynamicObject : info) {
                    long supplierId = dynamicObject.getLong("supplier_id");
                    ++i;
                    if (supplierId == 0L) continue;
                    Integer rule = infoMap.get(supplierId);
                    if (rule != null && rule.equals(0)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u8be2\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u8be2\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouInquirySubmitValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]), i, dynamicObject.getString("supplier.name"), inquiry.getString("org.name")));
                    }
                    Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)dynamicObject.getLong("supplier_id"));
                    HashSet<Long> set = new HashSet<Long>(1);
                    set.add(bizPartnerId);
                    List supUserIds = BizPartnerUtil.getSupEnableUserIdsByBizPartner(set);
                    boolean flag = false;
                    if (supUserIds.size() > 0) {
                        for (Long supUserId : supUserIds) {
                            rule = PermissionServiceHelper.checkPermission((Long)supUserId, (Long)inquiry.getLong("org.id"), (String)"SE7/UZFDVIE", (String)"quo_inquiry", (String)"47150e89000000ac");
                            if (rule == null || !rule.equals(1)) continue;
                            infoMap.put(dynamicObject.getLong("supplier_id"), rule);
                            flag = true;
                            break;
                        }
                    }
                    if (flag) continue;
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u4f9b\u5e94\u5546\u7b2c%1$s\u884c\uff1a%2$s\uff0c\u6ca1\u6709%3$s\u7684\u7684\u8be2\u4ef7\u67e5\u8be2\u6743\u9650\u65f6\u5c06\u65e0\u6cd5\u67e5\u770b\u672c\u8be2\u4ef7\u5355\uff0c\u8bf7\u5148\u7ed9\u4f9b\u5e94\u5546\u7528\u6237\u6388\u4e88\u5bf9\u5e94\u7ec4\u7ec7\u6743\u9650\u3002", (String)"SouInquirySubmitValidator_10", (String)"scm-sou-opplugin", (Object[])new Object[0]), i, dynamicObject.getString("supplier.name"), inquiry.getString("org.name")));
                }
            }
        }
    }
}

